/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;

class SelectedDenseDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected double[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseDoubleMatrix1D(double[] dArray, int[] nArray) {
        this(nArray.length, dArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseDoubleMatrix1D(int n, double[] dArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public double[] elements() {
        return this.elements;
    }

    public double getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public DoubleMatrix1D like(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix2D reshape(int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n, n2);
        double[] dArray = (double[])((DoubleMatrix2D)denseDoubleMatrix2D).elements();
        int n3 = (int)((AbstractMatrix2D)denseDoubleMatrix2D).index(0, 0);
        int n4 = denseDoubleMatrix2D.rowStride();
        int n5 = denseDoubleMatrix2D.columnStride();
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7 = n3 + i * n5;
            for (int j = 0; j < n; ++j) {
                dArray[n7] = this.getQuick(n6++);
                n7 += n4;
            }
        }
        return denseDoubleMatrix2D;
    }

    public DoubleMatrix3D reshape(int n, int n2, int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseDoubleMatrix3D denseDoubleMatrix3D = new DenseDoubleMatrix3D(n, n2, n3);
        double[] dArray = (double[])((DoubleMatrix3D)denseDoubleMatrix3D).elements();
        int n4 = (int)((AbstractMatrix3D)denseDoubleMatrix3D).index(0, 0, 0);
        int n5 = denseDoubleMatrix3D.sliceStride();
        int n6 = denseDoubleMatrix3D.rowStride();
        int n7 = denseDoubleMatrix3D.columnStride();
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n9 = n4 + i * n5 + j * n7;
                for (int k = 0; k < n2; ++k) {
                    dArray[n9] = this.getQuick(n8++);
                    n9 += n6;
                }
            }
        }
        return denseDoubleMatrix3D;
    }

    public void setQuick(int n, double d) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = d;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D selectedDenseDoubleMatrix1D = (SelectedDenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedDenseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == denseDoubleMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDoubleMatrix1D(this.elements, nArray);
    }
}

