/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;

public class FloatILU
implements FloatPreconditioner {
    private SparseRCFloatMatrix2D LU;
    private final FloatMatrix1D y;
    private int[] diagind;
    private final int n;

    public FloatILU(int n) {
        this.n = n;
        this.y = new DenseFloatMatrix1D(n);
    }

    public FloatMatrix1D apply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.lowerUnitSolve(floatMatrix1D, this.y);
        return this.upperSolve(this.y, floatMatrix1D2);
    }

    public FloatMatrix1D transApply(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D2 == null) {
            floatMatrix1D2 = floatMatrix1D.like();
        }
        this.upperTransSolve(floatMatrix1D, this.y);
        return this.loverUnitTransSolve(this.y, floatMatrix1D2);
    }

    public void setMatrix(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCFloatMatrix2D(this.n, this.n);
        this.LU.assign(floatMatrix2D);
        if (!this.LU.hasColumnIndexesSorted()) {
            this.LU.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        float[] fArray = this.LU.getValues();
        this.diagind = this.findDiagonalIndexes(this.n, nArray, nArray2);
        for (int i = 1; i < this.n; ++i) {
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                int n = nArray[j];
                float f = fArray[this.diagind[n]];
                if (f == 0.0f) {
                    throw new RuntimeException("Zero pivot encountered on row " + (j + 1) + " during ILU process");
                }
                int n2 = j;
                float f2 = fArray[n2] / f;
                fArray[n2] = f2;
                float f3 = f2;
                int n3 = nArray2[i] + 1;
                for (int k = this.diagind[n] + 1; k < nArray2[n + 1]; ++k) {
                    while (n3 < nArray2[i + 1] && nArray[n3] < nArray[k]) {
                        ++n3;
                    }
                    if (nArray[n3] != nArray[k]) continue;
                    int n4 = n3;
                    fArray[n4] = fArray[n4] - f3 * fArray[k];
                }
            }
        }
    }

    private int[] findDiagonalIndexes(int n, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = Sorting.binarySearchFromTo(nArray, i, nArray2[i], nArray2[i + 1] - 1);
            if (nArray3[i] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (i + 1));
        }
        return nArray3;
    }

    private FloatMatrix1D lowerUnitSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        float[] fArray3 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            float f = 0.0f;
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                f += fArray3[j] * fArray2[nArray[j]];
            }
            fArray2[i] = fArray[i] - f;
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D loverUnitTransSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        float[] fArray2 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = nArray2[i]; j < this.diagind[i]; ++j) {
                int n2 = nArray[j];
                fArray[n2] = fArray[n2] - fArray2[j] * fArray[i];
            }
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D).elements();
        float[] fArray2 = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        float[] fArray3 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = n - 1; i >= 0; --i) {
            float f = 0.0f;
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                f += fArray3[j] * fArray2[nArray[j]];
            }
            fArray2[i] = (fArray[i] - f) / fArray3[this.diagind[i]];
        }
        return floatMatrix1D2;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        floatMatrix1D2.assign(floatMatrix1D);
        float[] fArray = ((DenseFloatMatrix1D)floatMatrix1D2).elements();
        int[] nArray = this.LU.getColumnIndexes();
        int[] nArray2 = this.LU.getRowPointers();
        float[] fArray2 = this.LU.getValues();
        int n = this.LU.rows();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            fArray[n2] = fArray[n2] / fArray2[this.diagind[i]];
            for (int j = this.diagind[i] + 1; j < nArray2[i + 1]; ++j) {
                int n3 = nArray[j];
                fArray[n3] = fArray[n3] - fArray2[j] * fArray[i];
            }
        }
        return floatMatrix1D2;
    }
}

