/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tbit;

import cern.colt.PersistentObject;
import cern.colt.function.tint.IntIntProcedure;
import cern.colt.matrix.tbit.BitVector;
import cern.colt.matrix.tbit.QuickBitVector;
import java.awt.Rectangle;

public class BitMatrix
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected int columns;
    protected int rows;
    protected long[] bits;

    public BitMatrix(int n, int n2) {
        this.elements(QuickBitVector.makeBitVector(n * n2, 1), n, n2);
    }

    public void and(BitMatrix bitMatrix) {
        this.checkDimensionCompatibility(bitMatrix);
        this.toBitVector().and(bitMatrix.toBitVector());
    }

    public void andNot(BitMatrix bitMatrix) {
        this.checkDimensionCompatibility(bitMatrix);
        this.toBitVector().andNot(bitMatrix.toBitVector());
    }

    public int cardinality() {
        return this.toBitVector().cardinality();
    }

    protected void checkDimensionCompatibility(BitMatrix bitMatrix) {
        if (this.columns != bitMatrix.columns() || this.rows != bitMatrix.rows()) {
            throw new IllegalArgumentException("Incompatible dimensions: (columns,rows)=(" + this.columns + "," + this.rows + "), (other.columns,other.rows)=(" + bitMatrix.columns() + "," + bitMatrix.rows() + ")");
        }
    }

    public void clear() {
        this.toBitVector().clear();
    }

    public Object clone() {
        BitMatrix bitMatrix = (BitMatrix)super.clone();
        if (this.bits != null) {
            bitMatrix.bits = (long[])this.bits.clone();
        }
        return bitMatrix;
    }

    public int columns() {
        return this.columns;
    }

    protected void containsBox(int n, int n2, int n3, int n4) {
        if (n < 0 || n + n3 > this.columns || n2 < 0 || n2 + n4 > this.rows) {
            throw new IndexOutOfBoundsException("column:" + n + ", row:" + n2 + " ,width:" + n3 + ", height:" + n4);
        }
    }

    public BitMatrix copy() {
        return (BitMatrix)this.clone();
    }

    protected long[] elements() {
        return this.bits;
    }

    protected void elements(long[] lArray, int n, int n2) {
        if (n < 0 || n < 0 || n * n2 > lArray.length * 64) {
            throw new IllegalArgumentException();
        }
        this.bits = lArray;
        this.columns = n;
        this.rows = n2;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BitMatrix)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitMatrix bitMatrix = (BitMatrix)object;
        if (this.columns != bitMatrix.columns() || this.rows != bitMatrix.rows()) {
            return false;
        }
        return this.toBitVector().equals(bitMatrix.toBitVector());
    }

    public boolean forEachCoordinateInState(boolean bl, IntIntProcedure intIntProcedure) {
        long l;
        if (this.size() == 0) {
            return true;
        }
        BitVector bitVector = new BitVector(this.bits, this.size());
        long[] lArray = this.bits;
        int n = this.columns - 1;
        int n2 = this.rows - 1;
        long l2 = lArray[this.bits.length - 1];
        int n3 = bitVector.numberOfBitsInPartialUnit();
        while (--n3 >= 0) {
            l = l2 & 1L << n3;
            if ((bl && l != 0L || !bl && l == 0L) && !intIntProcedure.apply(n, n2)) {
                return false;
            }
            if (--n >= 0) continue;
            n = this.columns - 1;
            --n2;
        }
        l = bl ? 0L : -1L;
        int n4 = bitVector.numberOfFullUnits();
        while (--n4 >= 0) {
            int n5;
            l2 = lArray[n4];
            if (l2 != l) {
                if (bl) {
                    n5 = 64;
                    while (--n5 >= 0) {
                        if ((l2 & 1L << n5) != 0L && !intIntProcedure.apply(n, n2)) {
                            return false;
                        }
                        if (--n >= 0) continue;
                        n = this.columns - 1;
                        --n2;
                    }
                    continue;
                }
                n5 = 64;
                while (--n5 >= 0) {
                    if ((l2 & 1L << n5) == 0L && !intIntProcedure.apply(n, n2)) {
                        return false;
                    }
                    if (--n >= 0) continue;
                    n = this.columns - 1;
                    --n2;
                }
                continue;
            }
            if ((n -= 64) >= 0) continue;
            n += 64;
            n5 = 64;
            while (--n5 >= 0) {
                if (--n >= 0) continue;
                n = this.columns - 1;
                --n2;
            }
        }
        return true;
    }

    public boolean get(int n, int n2) {
        if (n < 0 || n >= this.columns || n2 < 0 || n2 >= this.rows) {
            throw new IndexOutOfBoundsException("column:" + n + ", row:" + n2);
        }
        return QuickBitVector.get(this.bits, n2 * this.columns + n);
    }

    public boolean getQuick(int n, int n2) {
        return QuickBitVector.get(this.bits, n2 * this.columns + n);
    }

    public int hashCode() {
        return this.toBitVector().hashCode();
    }

    public void not() {
        this.toBitVector().not();
    }

    public void or(BitMatrix bitMatrix) {
        this.checkDimensionCompatibility(bitMatrix);
        this.toBitVector().or(bitMatrix.toBitVector());
    }

    public BitMatrix part(int n, int n2, int n3, int n4) {
        if (n < 0 || n + n3 > this.columns || n2 < 0 || n2 + n4 > this.rows) {
            throw new IndexOutOfBoundsException("column:" + n + ", row:" + n2 + " ,width:" + n3 + ", height:" + n4);
        }
        if (n3 <= 0 || n4 <= 0) {
            return new BitMatrix(0, 0);
        }
        BitMatrix bitMatrix = new BitMatrix(n3, n4);
        bitMatrix.replaceBoxWith(0, 0, n3, n4, this, n, n2);
        return bitMatrix;
    }

    public void put(int n, int n2, boolean bl) {
        if (n < 0 || n >= this.columns || n2 < 0 || n2 >= this.rows) {
            throw new IndexOutOfBoundsException("column:" + n + ", row:" + n2);
        }
        QuickBitVector.put(this.bits, n2 * this.columns + n, bl);
    }

    public void putQuick(int n, int n2, boolean bl) {
        QuickBitVector.put(this.bits, n2 * this.columns + n, bl);
    }

    public void replaceBoxWith(int n, int n2, int n3, int n4, BitMatrix bitMatrix, int n5, int n6) {
        Cloneable cloneable;
        Cloneable cloneable2;
        this.containsBox(n, n2, n3, n4);
        bitMatrix.containsBox(n5, n6, n3, n4);
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (bitMatrix == this && ((Rectangle)(cloneable2 = new Rectangle(n, n2, n3, n4))).intersects((Rectangle)(cloneable = new Rectangle(n5, n6, n3, n4)))) {
            bitMatrix = bitMatrix.copy();
        }
        cloneable2 = bitMatrix.toBitVector();
        cloneable = this.toBitVector();
        int n7 = bitMatrix.columns();
        while (--n4 >= 0) {
            int n8 = n2 * this.columns + n;
            int n9 = n6 * n7 + n5;
            ((BitVector)cloneable).replaceFromToWith(n8, n8 + n3 - 1, (BitVector)cloneable2, n9);
            ++n2;
            ++n6;
        }
    }

    public void replaceBoxWith(int n, int n2, int n3, int n4, boolean bl) {
        this.containsBox(n, n2, n3, n4);
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        BitVector bitVector = this.toBitVector();
        while (--n4 >= 0) {
            int n5 = n2 * this.columns + n;
            bitVector.replaceFromToWith(n5, n5 + n3 - 1, bl);
            ++n2;
        }
    }

    public int rows() {
        return this.rows;
    }

    public int size() {
        return this.columns * this.rows;
    }

    public BitVector toBitVector() {
        return new BitVector(this.bits, this.size());
    }

    public String toString() {
        return this.toBitVector().toString();
    }

    public void xor(BitMatrix bitMatrix) {
        this.checkDimensionCompatibility(bitMatrix);
        this.toBitVector().xor(bitMatrix.toBitVector());
    }
}

