/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.Timer;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.FormerFactory;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.algo.DoubleStatistic;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DoubleBinFunctions1D;

public class DoubleFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public DoubleFormatter() {
        this("%G");
    }

    public DoubleFormatter(String string) {
        this.setFormat(string);
        this.setAlignment("decimal");
    }

    public static void demo1() {
        int n;
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"%G", "%1.10G", "%f", "%1.2f", "%0.2e", null};
        int n2 = stringArray.length;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(dArrayArray);
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            stringArray2[n] = new DoubleFormatter(string).toString(doubleMatrix2D);
            stringArray3[n] = new DoubleFormatter(string).toSourceCode(doubleMatrix2D);
        }
        System.out.println("original:\n" + new DoubleFormatter().toString(doubleMatrix2D));
        for (n = 0; n < n2; ++n) {
            System.out.println("\nstring(" + stringArray[n] + "):\n" + stringArray2[n]);
            System.out.println("\nsourceCode(" + stringArray[n] + "):\n" + stringArray3[n]);
        }
    }

    public static void demo2() {
        int n;
        double[] dArray = new double[]{5.0, 0.0, -0.0, Double.NaN, Double.NaN, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        String[] stringArray = new String[]{"%G", "%1.19G"};
        int n2 = stringArray.length;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string = stringArray[n];
            stringArray2[n] = new DoubleFormatter(string).toString(denseDoubleMatrix1D);
            int n3 = 0;
            while ((long)n3 < denseDoubleMatrix1D.size()) {
                System.out.println(String.valueOf(denseDoubleMatrix1D.get(n3)));
                ++n3;
            }
        }
        System.out.println("original:\n" + new DoubleFormatter().toString(denseDoubleMatrix1D));
        for (n = 0; n < n2; ++n) {
            System.out.println("\nstring(" + stringArray[n] + "):\n" + stringArray2[n]);
        }
    }

    public static void demo3(int n, double d) {
        int n2;
        Timer timer = new Timer();
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(n, n, d);
        timer.reset().start();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (--n3 >= 0) {
            n2 = n;
            while (--n2 >= 0) {
                stringBuffer.append(doubleMatrix2D.getQuick(n3, n2));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        Former former = new FormerFactory().create("%G");
        stringBuffer = new StringBuffer();
        n2 = n;
        while (--n2 >= 0) {
            int n4 = n;
            while (--n4 >= 0) {
                stringBuffer.append(former.form(doubleMatrix2D.getQuick(n2, n4)));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        String string = new DoubleFormatter(null).toString(doubleMatrix2D);
        System.out.println(string);
        string = null;
        timer.stop().display();
        timer.reset().start();
        string = new DoubleFormatter("%G").toString(doubleMatrix2D);
        System.out.println(string);
        string = null;
        timer.stop().display();
    }

    public static void demo4() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(dArrayArray);
        System.out.println("\n\n" + new DoubleFormatter("%G").toTitleString(doubleMatrix2D, stringArray2, stringArray, "rowAxis", "colAxis", "VM Performance: Provider vs. matrix density"));
    }

    public static void demo5() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(DoubleFactory2D.dense.make(dArrayArray));
        System.out.println(new DoubleFormatter("%G").toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo6() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"W", "X", "Y", "Z"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(new DoubleFormatter().toString(DoubleFactory2D.dense.make(dArrayArray)));
        System.out.println(new DoubleFormatter().toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo7() {
        double[][] dArrayArray = new double[][]{{5.0, 10.0, 20.0, 40.0}, {7.0, 8.0, 6.0, 7.0}, {12.0, 10.0, 20.0, 19.0}, {3.0, 1.0, 5.0, 6.0}};
        String[] stringArray = new String[]{"1996", "1997", "1998", "1999"};
        String[] stringArray2 = new String[]{"PowerBar", "Benzol", "Mercedes", "Sparcling"};
        String string = "CPU";
        String string2 = "Year";
        String string3 = "CPU performance over time [nops/sec]";
        DoubleBinFunctions1D doubleBinFunctions1D = DoubleBinFunctions1D.functions;
        DoubleBinFunction1D[] doubleBinFunction1DArray = new DoubleBinFunction1D[8];
        doubleBinFunction1DArray[0] = DoubleBinFunctions1D.mean;
        doubleBinFunction1DArray[1] = DoubleBinFunctions1D.rms;
        doubleBinFunction1DArray[2] = DoubleBinFunctions1D.quantile(0.25);
        doubleBinFunction1DArray[3] = DoubleBinFunctions1D.median;
        doubleBinFunction1DArray[4] = DoubleBinFunctions1D.quantile(0.75);
        doubleBinFunction1DArray[5] = DoubleBinFunctions1D.stdDev;
        doubleBinFunction1DArray[6] = DoubleBinFunctions1D.min;
        doubleBinFunction1DArray[7] = DoubleBinFunctions1D.max;
        DoubleBinFunction1D[] doubleBinFunction1DArray2 = doubleBinFunction1DArray;
        String string4 = "%1.2G";
        System.out.println(new DoubleFormatter(string4).toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, string, string2, string3, doubleBinFunction1DArray2));
    }

    protected String form(DoubleMatrix1D doubleMatrix1D, int n, Former former) {
        return former.form(doubleMatrix1D.get(n));
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Former former) {
        return this.form((DoubleMatrix1D)abstractMatrix1D, n, former);
    }

    public String[][] format(DoubleMatrix2D doubleMatrix2D) {
        String[][] stringArray = new String[doubleMatrix2D.rows()][doubleMatrix2D.columns()];
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(doubleMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((DoubleMatrix2D)abstractMatrix2D);
    }

    protected int indexOfDecimalPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.lastIndexOf(101);
        }
        if (n < 0) {
            n = string.lastIndexOf(69);
        }
        if (n < 0) {
            n = string.length();
        }
        return n;
    }

    protected int lead(String string) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(string);
        }
        return super.lead(string);
    }

    public String toSourceCode(DoubleMatrix1D doubleMatrix1D) {
        DoubleFormatter doubleFormatter = (DoubleFormatter)this.clone();
        doubleFormatter.setPrintShape(false);
        doubleFormatter.setColumnSeparator(", ");
        String string = "{";
        String string2 = "};";
        return string + doubleFormatter.toString(doubleMatrix1D) + string2;
    }

    public String toSourceCode(DoubleMatrix2D doubleMatrix2D) {
        DoubleFormatter doubleFormatter = (DoubleFormatter)this.clone();
        String string = this.blanks(3);
        doubleFormatter.setPrintShape(false);
        doubleFormatter.setColumnSeparator(", ");
        doubleFormatter.setRowSeparator("},\n" + string + "{");
        String string2 = "{\n" + string + "{";
        String string3 = "}\n};";
        return string2 + doubleFormatter.toString(doubleMatrix2D) + string3;
    }

    public String toSourceCode(DoubleMatrix3D doubleMatrix3D) {
        DoubleFormatter doubleFormatter = (DoubleFormatter)this.clone();
        String string = this.blanks(3);
        String string2 = this.blanks(6);
        doubleFormatter.setPrintShape(false);
        doubleFormatter.setColumnSeparator(", ");
        doubleFormatter.setRowSeparator("},\n" + string2 + "{");
        doubleFormatter.setSliceSeparator("}\n" + string + "},\n" + string + "{\n" + string2 + "{");
        String string3 = "{\n" + string + "{\n" + string2 + "{";
        String string4 = "}\n" + string + "}\n}";
        return string3 + doubleFormatter.toString(doubleMatrix3D) + string4;
    }

    public String toString(DoubleMatrix1D doubleMatrix1D) {
        DoubleMatrix2D doubleMatrix2D = doubleMatrix1D.like2D(1, (int)doubleMatrix1D.size());
        doubleMatrix2D.viewRow(0).assign(doubleMatrix1D);
        return this.toString(doubleMatrix2D);
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        return super.toString(doubleMatrix2D);
    }

    public String toString(DoubleMatrix3D doubleMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        for (int i = 0; i < doubleMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(doubleMatrix3D.viewSlice(i)));
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, DoubleFormatter.shape(doubleMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((DoubleMatrix2D)abstractMatrix2D);
    }

    protected String toTitleString(DoubleMatrix2D doubleMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        if (doubleMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] objectArray = this.format(doubleMatrix2D);
        this.align((String[][])objectArray);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(objectArray), stringArray, stringArray2, string, string2, string3);
    }

    public String toTitleString(DoubleMatrix2D doubleMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3, DoubleBinFunction1D[] doubleBinFunction1DArray) {
        int n;
        Object object;
        if (doubleMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        if (doubleBinFunction1DArray == null || doubleBinFunction1DArray.length == 0) {
            return this.toTitleString(doubleMatrix2D, stringArray, stringArray2, string, string2, string3);
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(doubleMatrix2D.rows(), doubleBinFunction1DArray.length);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.like(doubleBinFunction1DArray.length, doubleMatrix2D.columns());
        DoubleStatistic.aggregate(doubleMatrix2D, doubleBinFunction1DArray, doubleMatrix2D3);
        DoubleStatistic.aggregate(doubleMatrix2D.viewDice(), doubleBinFunction1DArray, doubleMatrix2D2.viewDice());
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D.like(doubleMatrix2D.rows() + doubleBinFunction1DArray.length, doubleMatrix2D.columns());
        doubleMatrix2D4.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D.columns()).assign(doubleMatrix2D);
        doubleMatrix2D4.viewPart(doubleMatrix2D.rows(), 0, doubleBinFunction1DArray.length, doubleMatrix2D.columns()).assign(doubleMatrix2D3);
        doubleMatrix2D3 = null;
        Object[][] objectArray = this.format(doubleMatrix2D4);
        this.align((String[][])objectArray);
        doubleMatrix2D4 = null;
        Object[][] objectArray2 = this.format(doubleMatrix2D2);
        this.align((String[][])objectArray2);
        doubleMatrix2D2 = null;
        ObjectMatrix2D objectMatrix2D = ObjectFactory2D.dense.make(doubleMatrix2D.rows() + doubleBinFunction1DArray.length, doubleMatrix2D.columns() + doubleBinFunction1DArray.length + 1);
        objectMatrix2D.viewPart(0, 0, doubleMatrix2D.rows() + doubleBinFunction1DArray.length, doubleMatrix2D.columns()).assign(objectArray);
        objectMatrix2D.viewColumn(doubleMatrix2D.columns()).assign("|");
        objectMatrix2D.viewPart(0, doubleMatrix2D.columns() + 1, doubleMatrix2D.rows(), doubleBinFunction1DArray.length).assign(objectArray2);
        objectArray = null;
        objectArray2 = null;
        if (stringArray2 != null) {
            object = new ObjectArrayList(stringArray2);
            ((ObjectArrayList)object).add("|");
            for (n = 0; n < doubleBinFunction1DArray.length; ++n) {
                ((ObjectArrayList)object).add(doubleBinFunction1DArray[n].name());
            }
            stringArray2 = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray2);
        }
        if (stringArray != null) {
            object = new ObjectArrayList(stringArray);
            for (n = 0; n < doubleBinFunction1DArray.length; ++n) {
                ((ObjectArrayList)object).add(doubleBinFunction1DArray[n].name());
            }
            stringArray = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray);
        }
        object = new ObjectFormatter().toTitleString(objectMatrix2D, stringArray, stringArray2, string, string2, string3);
        int n2 = n = ((String)object).length() + 1;
        int n3 = Math.max(0, string == null ? 0 : string.length() - doubleMatrix2D.rows() - doubleBinFunction1DArray.length);
        for (int i = 0; i < doubleBinFunction1DArray.length + 1 + n3; ++i) {
            n2 = n;
            n = ((String)object).lastIndexOf(this.rowSeparator, n - 1);
        }
        StringBuffer stringBuffer = new StringBuffer((String)object);
        stringBuffer.insert(n2, this.rowSeparator + this.repeat('-', n2 - n - 1));
        return stringBuffer.toString();
    }

    public String toTitleString(DoubleMatrix3D doubleMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4, DoubleBinFunction1D[] doubleBinFunction1DArray) {
        if (doubleMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < doubleMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(doubleMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i], doubleBinFunction1DArray));
        }
        return stringBuffer.toString();
    }

    private String xtoTitleString(DoubleMatrix3D doubleMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4) {
        if (doubleMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < doubleMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(doubleMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i]));
        }
        return stringBuffer.toString();
    }
}

