% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tablePrevalence}
\alias{tablePrevalence}
\title{Table of prevalence results}
\usage{
tablePrevalence(
  result,
  type = "gt",
  header = c("estimate_name"),
  groupColumn = character(),
  settingsColumn = omopgenerics::settingsColumns(result),
  hide = character(),
  .options = list(),
  settingsColumns = lifecycle::deprecated()
)
}
\arguments{
\item{result}{Prevalence results}

\item{type}{Type of table. Can be "gt", "flextable", or "tibble"}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"denominator_cohort_name", "outcome_cohort_name", "prevalence_start_date",
"prevalence_end_date", "estimate_name", variables in the \code{strata_name} column,
and any of the settings columns specified in \code{settingsColumn} argument.
The header can also include other names to use as overall header labels}

\item{groupColumn}{Variables to use as group labels. Allowed columns are the
same as in \code{header}}

\item{settingsColumn}{Variables from the settings atribute to dispaly in
the table}

\item{hide}{Table columns to exclude, options are the ones described in
\code{header}}

\item{.options}{Table options to apply}

\item{settingsColumns}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
Table of prevalence results
}
\description{
Table of prevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome",
  interval = "months"
)
tablePrevalence(prev)
}
}
