% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{valueDecomposition}
\alias{valueDecomposition}
\title{valueDecomposition}
\usage{
valueDecomposition(x, pvar, qvar, pervar, prodID, priceMethod,
  sample = "matched")
}
\arguments{
\item{x}{data frame with input data}

\item{pvar}{character string for the name of the price column}

\item{qvar}{character string for the name of the quantity column}

\item{pervar}{character string for the name of the time period variable}

\item{prodID}{character string for the name of the product ID column}

\item{priceMethod}{character string for the price indicator method. Valid options
are "laspeyres", "paasche", "bennet", or "montgomery". This parameter also
determines the method used for the quantity indicator. If a laspeyres price
indicator is chosen, then a paasche quantity indicator is used.
If a paasche price indicator is used then a laspeyres quantity indicator
is used. For bennet and montgomery indicators, the same method is
used for both the price and quantity indicators.}

\item{sample}{whether to use a matched sample (sample = "matched")}
}
\value{
a dataframe containing the price indicator, quantity indicator
the value change and the value level.
}
\description{
Perform a decomposition of value change using price
and quantity indicators. This is an additive decomposition
so that change due to price plus change due to quantity
equals the total value change.
}
\examples{
# decompose the value changes in the CES_sigma_2 dataset using the Bennet method
valueDecomposition(CES_sigma_2, pvar = "prices", qvar = "quantities",
prodID = "prodID", pervar = "time", priceMethod = "bennet")
}
