% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Standardization_AMPI.R
\name{Standardization_AMPI}
\alias{Standardization_AMPI}
\title{Standardization of data with Adjusted Maziotta-Pareto index}
\usage{
Standardization_AMPI(data, pol = "pos")
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative
variables}

\item{pol}{polarity if not selected is "positive"", otherwise write "neg"
(see details)}
}
\value{
It returns a dataframe of normalized data
}
\description{
This is a function that standardized the data with Adjusted Maziotta-Pareto
index with positive or negative polarity
}
\details{
The ‘polarity’ of an indicator is the sign of the relation between the
indicator and the phenomenon to be measured ( + if the indicator represents
a dimension considered positive and - otherwise)
}
\examples{

data("Education")
Standardization_AMPI=Standardization_AMPI(Education)
print(Standardization_AMPI)

#----With negative polarity
Standardization_AMPI_neg=Standardization_AMPI(Education,"neg")
print(Standardization_AMPI_neg)

}
\references{
Matteo Mazziotta & Adriano Pareto, 2018. "Measuring Well-Being
Over Time: The Adjusted Mazziotta–Pareto Index Versus Other Non-compensatory
Indices," Social Indicators Research: An International and Interdisciplinary
Journal for Quality-of-Life Measurement, Springer, vol. 136(3), pages
967-976, April
}
\keyword{AMPI}
\keyword{Standardization}
