% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDescription.R
\docType{data}
\name{ScoreInd}
\alias{ScoreInd}
\title{Simulated time to event data with 5 time independent covariates}
\format{A data.frame containing a row per subject with eleven columns:}
\description{
This dataset is inspired by the simulation described in Hsu and Taylor,
Statistics in Medicine (2009) 28:462-475 with an additional DCO.time column
}
\section{Fields}{

\describe{
\item{\code{Id}}{subject identifier}

\item{\code{arm}}{factor for treatment group control=0, active=1}

\item{\code{Z1}}{binary time independent covariate}

\item{\code{Z2}}{continuous time independent covariate}

\item{\code{Z3}}{binary time independent covariate}

\item{\code{Z4}}{continuous time independent covariate}

\item{\code{Z5}}{binary time independent covariate}

\item{\code{event}}{event indicator (1 yes, 0 no)}

\item{\code{time}}{subject censoring/event time (in years)}

\item{\code{to.impute}}{logical, should an event time be imputed for this subject?
(this is ignored if subject has event time)}

\item{\code{DCO.time}}{The time the subject would have been censored if they had not
had an event or been censored before the data cut off date}
}}

