% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{BinFeaturesPlot_SingleData}
\alias{BinFeaturesPlot_SingleData}
\title{Visualization of characteristic binary features of a single data set}
\usage{
BinFeaturesPlot_SingleData(leadCpds = c(), orderLab = c(), features = c(),
  data = NULL, colorLab = NULL, nrclusters = NULL, cols = NULL,
  name = c("Data"), colors1 = c("gray90", "blue"), colors2 = c("gray90",
  "green"), highlightFeat = NULL, margins = c(5.5, 3.5, 0.5, 5.5),
  plottype = "new", location = NULL)
}
\arguments{
\item{leadCpds}{A character vector with the names of the objects in a first group, i.e., the group for which the specified features are characteristic. Default is NULL.}

\item{orderLab}{A character vector with the order of the objects. Default is NULL.}

\item{features}{A character vector with the names of the features to be visualized. Default is NULL.}

\item{data}{The data matrix. Default is NULL.}

\item{colorLab}{Optional. A clustering object if the objects are to be coloured accoring to their clustering order. Default is NULL.}

\item{nrclusters}{Optional. The number of clusters to divide the dendrogram of ColorLab. Default is NULL.}

\item{cols}{Optional. A character vector with the colours of the different clusters. Default is NULL.}

\item{name}{A character string with the name of the data. Default is "Data".}

\item{colors1}{A character vector with the colours to indicate the presence (first element) or the absence of the features for the objects in LeadCpds. Default is c('gray90','blue').}

\item{colors2}{A character vector with the colours to indicate the presence (first element) or the absence of the features for the objects in the remaining objects. Default is c('gray90','green').}

\item{highlightFeat}{Optional. A character vector with names of features to be highlighted. The names of the features are coloured purple. Default is NULL.}

\item{margins}{A vector with the margings of the plot. Default is c(5.5,3.5,0.5,5.5).}

\item{plottype}{Should be one of "pdf","new" or "sweave". If "pdf", a
location should be provided in "location" and the figure is saved there. If
"new" a new graphic device is opened and if "sweave", the figure is made
compatible to appear in a sweave or knitr document, i.e. no new device is
opened and the plot appears in the current device or document. Default is "new".}

\item{location}{Optional. If plottype is "pdf", a location should be provided in
"location" and the figure is saved there. Default is NULL.}
}
\description{
A tool to visualize characteristic binary features of a set of objects in comparison with the remaining objects for a single data set. The result is a matrix with coloured cells. Columns represent 
objects and rows represent the specified features. A feature which is present is give a coloured cell while an absent feature is represented by a grey cell. The labels on the right indicate the names of the features while the labels on the bottom are the names of the objects.
}
\examples{
\dontrun{
data(fingerprintMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

Comps=FindCluster(list(MCF7_F),nrclusters=10,select=c(1,8)) 

MCF7_Char=CharacteristicFeatures(List=list(fingerprintMat),Selection=Comps,
binData=list(fingerprintMat),datanames=c("FP"),nrclusters=NULL,topC=NULL,
sign=0.05,fusionsLog=TRUE,weightclust=TRUE,names=c("FP"))Feat=MCF7_Char$
Selection$Characteristics$FP$TopFeat$Names[c(1:10)]

BinFeaturesPlot_SingleData(leadCpds=Comps,orderLab=MCF7_Char$Selection$
objects$OrderedCpds,features=Feat,data=fingerprintMat,colorLab=NULL,
nrclusters=NULL,cols=NULL,name=c("FP"),colors1=c('gray90','blue'),colors2=
c('gray90','green'),highlightFeat=NULL,margins=c(5.5,3.5,0.5,5.5),
plottype="new",location=NULL)
}
}
