% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CompareSvsM}
\alias{CompareSvsM}
\title{Comparison of clustering results for the single and multiple source
clustering.}
\usage{
CompareSvsM(ListS, ListM, nrclusters = NULL, cols = NULL,
  fusionsLogS = FALSE, fusionsLogM = FALSE, weightclustS = FALSE,
  weightclustM = FALSE, namesS = NULL, namesM = NULL, margins = c(8.1,
  3.1, 3.1, 4.1), plottype = "new", location = NULL)
}
\arguments{
\item{ListS}{A list of the outputs from the single source clusterings to be
compared. The first element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{ListM}{A list of the outputs from the multiple source clusterings to
be compared. The first element of the list will be used as the reference.}

\item{nrclusters}{The number of clusters to cut the dendrogram in. Default is NULL.}

\item{cols}{A character vector with the names of the colours. Default is NULL.}

\item{fusionsLogS}{The fusionslog parameter for the elements in ListS. To be
handed to \code{ReorderToReference}. Default is FALSE.}

\item{fusionsLogM}{The fusionsLog parameter for the elements in ListM. To be
handed to \code{ReorderToReference}. Default is FALSE.}

\item{weightclustS}{The weightclust parameter for the elements in ListS. To
be handed to \code{ReorderToReference}. Default is FALSE.}

\item{weightclustM}{The weightclust parameter for the elements in ListM. To
be handed to \code{ReorderToReference}. Default is FALSE.}

\item{namesS}{Optional. Names of the single source clusterings to be used as
labels for the columns. Default is NULL.}

\item{namesM}{Optional. Names of the multiple source clusterings to be used
as labels for the columns. Default is NULL.}

\item{margins}{Optional. Margins to be used for the plot. Default is c(8.1,3.1,3.1,4.1).}

\item{plottype}{Should be one of "pdf","new" or "sweave". If "pdf", a
location should be provided in "location" and the figure is saved there. If
"new" a new graphic device is opened and if "sweave", the figure is made
compatible to appear in a sweave or knitr document, i.e. no new device is
opened and the plot appears in the current device or document. Default is "new".}

\item{location}{If plottype is "pdf", a location should be provided in
"location" and the figure is saved there. Default is NULL.}
}
\value{
The returned value is a plot with on the left the comparison over
the objects in ListS and on the right a comparison over the objects in
ListM.
}
\description{
A visual comparison of all methods is handy to see which objects will
always cluster together independent of the applied methods. The function
\code{CompareSvsM} plots the \code{ComparePlot} of the single source
clustering results on the left and that of the multiple source clustering
results on the right such that a visual comparison is possible.
}
\examples{
\dontrun{
data(fingerprintMat)
data(targetMat)
data(Colors1)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(fingerprintMat,targetMat)

MCF7_W=WeightedClust(List=L,type="data", distmeasure=c("tanimoto","tanimoto"),
normalize=c(FALSE,FALSE),method=c(NULL,NULL),weight=seq(1,0,-0.1),weightclust=0.5
,clust="agnes",linkage="ward",StopRange=FALSE)

ListM=list(MCF7_W)
namesM=seq(1.0,0.0,-0.1)

ListS=list(MCF7_F,MCF7_T)
namesS=c("FP","TP")

CompareSvsM(ListS,ListM,nrclusters=7,cols=Colors1,fusionsLogS=FALSE,
fusionsLogM=FALSE,weightclustS=FALSE,weightclustM=FALSE,namesS,
namesM,plottype="new",location=NULL)
}
}
