% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PermuteIntLIM.R
\name{PermuteIntLIM}
\alias{PermuteIntLIM}
\title{Run permutations of the IntLIM code to search for random cross-omic associations in dataset}
\usage{
PermuteIntLIM(
  data,
  stype = "",
  outcome = 1,
  independent.var.type = 1,
  covar = c(),
  save.covar.pvals = FALSE,
  continuous = FALSE,
  pvalcutoff = 0.05,
  interactionCoeffPercentile = 0,
  rsquaredCutoff = 0,
  num.permutations = 1,
  seed = 1
)
}
\arguments{
\item{data}{IntLimData object (output of ReadData()) with analylte levels and
associated sample meta-data}

\item{stype}{column name that represents sample type (by default, it will be used
in the interaction term). Only 2 categories are currently supported.}

\item{outcome}{'1' or '2' must be set as outcome/independent variable
(default is '1')}

\item{independent.var.type}{'1' or '2' must be set as independent variable
(default is '1')}

\item{covar}{Additional variables from the phenotypic data that be integrated into linear model}

\item{save.covar.pvals}{boolean to indicate whether or not to save the p-values of all covariates,
which can be analyzed later but will also lengthen computation time. The default is FALSE.}

\item{continuous}{boolean to indicate whether the data is continuous or discrete}

\item{pvalcutoff}{FDR adjusted p-value cutoff for number of significant multi-omic 
pairs (default = 0.20)}

\item{interactionCoeffPercentile}{Interaction coefficient cutoff for the IntLIM linear model (default = 0.10)}

\item{rsquaredCutoff}{Cutoff for the R-squared values for the models as a quality control (default = 0.50)}

\item{num.permutations}{Number of permutations to be ran (default = 1)}

\item{seed}{set.seed paramter allowing for custom random number generation seeds}
}
\value{
List object with 1st slot populated with dataframe containing the R^2 values of the models, 
and number of significant pairs before and after p-value adjustment. The 2nd slot in the list contains 
a string vector of the IDs of the significant pairs.
}
\description{
This function allows users to test different permutations of the metadata with their analytes to ensure
that any pairs being deemed significant by IntIM are not being suggested due to random chance, as is 
sometimes a problem in correlative associations.
}
