% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterpretTP.R
\name{InterpretTP}
\alias{InterpretTP}
\title{InterpretTP.}
\usage{
InterpretTP(fml = NULL, param = "APCIpos", ...)
}
\arguments{
\item{fml}{A chemical formula of the standard used for transformation product generation.}

\item{param}{Keyword or parameter list, similar as in \link{InterpretMSSpectrum}.}

\item{...}{
  Arguments passed on to \code{\link[=InterpretMSSpectrum]{InterpretMSSpectrum}}
  \describe{
    \item{\code{spec}}{A 2-column matrix of mz/int pairs. If spec=NULL then \code{InterpretMSSpectrum}
tries to read data from clipboard (i.e. two columns copied from an Excel spreadsheet).}
    \item{\code{precursor}}{The ion (m/z) from spec closest to this mass will be considered as
precursor (can be nominal, i.e. if precursor=364 then 364.1234 would be selected from
spectrum if it is closest).}
    \item{\code{correct_peak}}{For testing purposes. A character in the form of "name, formula, mz"
to evaluate spectra against. Note! Separating character is ', '.}
    \item{\code{met_db}}{A metabolite DB (e.g. GMD or internal) can be provided to search for
candidates comparing M+H ions (cf. Examples).}
    \item{\code{typical_losses_definition}}{A file name (e.g. D:/BuildingBlocks_GCAPCI.txt) from
where to load relevant neutral losses (cf. Details). Alternatively an data frame with
columns 'Name', 'Formula' and 'Mass'.}
    \item{\code{silent}}{Logical. If TRUE no plot is generated and no output except final candidate
list is returned.}
    \item{\code{dppm}}{Specifies ppm error for Rdisop formula calculation.}
    \item{\code{formula_db}}{A pre calculated database of sum formulas and their isotopic fine
structures can be used to extremely speed up the function.}
  }}
}
\value{
An annotated plot of the mass spectrum and detailed information 
    within the console. Main result, list of final candidate formulas and 
    their putative fragments, will be returned invisibly.
}
\description{
\code{InterpretTP} is a wrapper function around 
    \link{InterpretMSSpectrum} which will read, evaluate and plot 
    a deconvoluted mass spectrum (mass*intensity pairs) from either 
    TMS-derivatized GC-APCI-MS data or ESI+/- data. 
    It allows to provide a chemical formula as a potential precursor of the 
    spectrum. This formula will be used to set the parameters 
    'allowed_elements' and 'maxElements' during de-novo formula generation.
}
\details{
For further details refer to \link{InterpretMSSpectrum}.
}
\examples{
# load test data
utils::data(apci_spectrum)

# provide information of a correct peak (if you know) as character
cp <- "Glutamic acid (3TMS), C14H33NO4Si3, 364.1790"

# provide database of known peaks and correct peak
mdb <- data.frame(
  "Name" = c("Glutamic acid (3TMS)", "other peak with same sum formula"),
  "Formula" = c("C14H33NO4Si3", "C14H33NO4Si3"),
  "M+H" = c(364.179, 364.179), stringsAsFactors = FALSE, check.names = FALSE
)

# provide a database of precalculated formulas to speed up the process
fdb <- system.file("extdata", "APCI_min.db", package = "InterpretMSSpectrum")

# apply function providing above arguments (dppm is set to 0.5 to reduce run time)
InterpretTP(fml = "C14H33NO4Si3", spec=apci_spectrum, param="APCIpos")

}
