% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{calculateWeightedDistMatrix}
\alias{calculateWeightedDistMatrix}
\title{Calculates a weighted representation of the distance matrix.}
\usage{
calculateWeightedDistMatrix(distM)
}
\arguments{
\item{distM, }{2D matrix with the distance among all pair of coordinates.}
}
\value{
weighted distance matrix. The sum of this matrix is 1.
}
\description{
\code{calculateWeightedDistMatrix} The weighted matrix is used as a standardized version of the distance matrix.
}
\details{
Computes the similarity matrix of the distance by taking the reciprocal of the distance \eqn{\frac{1}{d}}. A value of Zero is assigned when this value can not be calculated.
The whole reciprocal matrix is scaled by dividing each value by the sum of all the elements of the matrix.
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data<-loadFile(fileInput)
distM<-calculateEuclideanDistance(data$data)
distW<-calculateWeightedDistMatrix(distM)
}
