% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agespectrum.R
\name{agespectrum}
\alias{agespectrum}
\alias{agespectrum.default}
\alias{agespectrum.ArAr}
\title{Plot a (40Ar/39Ar) release spectrum}
\usage{
agespectrum(x, ...)

\method{agespectrum}{default}(x, alpha = 0.05, plateau = TRUE,
  plateau.col = rgb(0, 1, 0, 0.5), non.plateau.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, line.col = "red", lwd = 2, title = TRUE, ...)

\method{agespectrum}{ArAr}(x, alpha = 0.05, plateau = TRUE,
  plateau.col = rgb(0, 1, 0, 0.5), non.plateau.col = rgb(0, 1, 1, 0.5),
  sigdig = 2, exterr = TRUE, line.col = "red", lwd = 2, i2i = FALSE,
  ...)
}
\arguments{
\item{x}{a three-column matrix whose first column gives the amount
    of \eqn{^{39}}Ar in each aliquot, and whose second and third
    columns give the age and its uncertainty.

OR

an object of class \code{ArAr}}

\item{...}{optional parameters to the generic \code{plot} function}

\item{alpha}{the confidence limits of the error bars/boxes.}

\item{plateau}{logical flag indicating whether a plateau age should
be calculated. If \code{plateau=TRUE}, the function will
compute the weighted mean of the largest succession of steps
that yield values passing the Chi-square test for age
homogeneity.}

\item{plateau.col}{the fill colour of the rectangles used to mark
the steps belonging to the age plateau.}

\item{non.plateau.col}{if \code{plateau=TRUE}, the steps that do
NOT belong to the plateau are given a different colour.}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output (only used
if \code{plateau=TRUE}).}

\item{line.col}{colour of the isochron line}

\item{lwd}{line width}

\item{title}{add a title to the plot? If \code{FALSE}, returns a
list with plateau parameters.}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{i2i}{`isochron to intercept': calculates the initial (aka `inherited',
`excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar ratio from an
isochron fit. Setting \code{i2i} to \code{FALSE} uses the
default values stored in \code{settings('iratio',...)}}
}
\value{
if \code{title=FALSE}, returns a list with the following
    items:

\describe{
\item{mean}{a 2-element vector with the plateau mean and standard error}

\item{mswd}{the mean square of the weighted deviates of the plateau}

\item{p.value}{the p-value of a Chi-square test with \eqn{n-1}
degrees of freedom, where \eqn{n} is the number of steps in the
plateau.}

\item{fract}{the fraction of \eqn{^{39}}Ar contained in the
plateau} }
}
\description{
Produces a plot of boxes whose widths correspond to the cumulative
amount of \eqn{^{39}}Ar (or any other volume proxy), and whose
heights express the analytical uncertainties.  Only propagates the
analytical uncertainty associated with decay constants and
J-factors after computing the plateau composition.
}
\examples{
data(examples)
agespectrum(examples$ArAr,ylim=c(0,80))
}
