% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discordia.R
\name{concordia.age}
\alias{concordia.age}
\title{Calculate U-Pb concordia ages}
\usage{
concordia.age(x, wetherill = TRUE, dcu = TRUE)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{wetherill}{boolean flag to indicate whether the data should
be evaluated in Wetherill (\code{TRUE}) or Tera-Wasserburg
(\code{FALSE}) space}

\item{dcu}{propagate the decay constant uncertainties?}
}
\value{
a list with the following items:

\code{x}: a named vector with the weighted mean U-Pb composition

\code{x.cov}: the covariance matrix of the mean U-Pb composition

\code{age}: the concordia age (in Ma)

\code{age.err}: the standard error of the concordia age

\code{mswd}: a list with two items (\code{equivalence} and
\code{concordance}) containing the MSWD (Mean of the Squared
Weighted Deviates, a.k.a the reduced Chi-squared statistic outside
of geochronology) of isotopic equivalence and age concordance,
respectively.

\code{p.value}: a list with two items (\code{equivalence} and
\code{concordance}) containing the p-value of the Chi-square test
for isotopic equivalence and age concordance, respectively.
}
\description{
Evaluates the equivalence of multiple
(\eqn{^{206}}Pb/\eqn{^{238}}U-\eqn{^{207}}Pb/\eqn{^{235}}U or
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U)
compositions, computes the weighted mean isotopic composition and
the corresponding concordia age using the method of maximum
likelihood, computes the mswd of equivalence and concordance and
their respective Chi-squared p-values.
}
\examples{
data(UPb)
fit <- concordia.age(UPb)
print(paste('age = ',fit$age,'+/-',fit$age.err,'Ma, MSWD = ',fit$mswd))
}

