% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age}
\alias{age}
\alias{age.ArAr}
\alias{age.ReOs}
\alias{age.UPb}
\alias{age.UThHe}
\alias{age.default}
\alias{age.detritals}
\alias{age.fissiontracks}
\title{Calculate isotopic ages}
\usage{
age(x, ...)

\method{age}{default}(x, method = "Pb206U238", exterr = TRUE, J = c(NA,
  NA), zeta = c(NA, NA), rhoD = c(NA, NA), ...)

\method{age}{UPb}(x, concordia = 1, wetherill = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{detritals}(x, ...)

\method{age}{ArAr}(x, isochron = FALSE, exterr = TRUE, i = NA,
  sigdig = NA, ...)

\method{age}{UThHe}(x, central = FALSE, i = NA, sigdig = NA, ...)

\method{age}{fissiontracks}(x, central = FALSE, i = NA, sigdig = NA,
  exterr = TRUE, ...)

\method{age}{ReOs}(x, isochron = TRUE, exterr = TRUE, i = NA,
  sigdig = NA, ...)
}
\arguments{
\item{x}{can be:
\itemize{
\item a scalar containing an isotopic ratio,

\item a two element vector containing an isotopic ratio and its standard
error, or the spontaneous and induced track densities \code{Ns} and
\code{Ni} (if \code{method='fissiontracks'}),

\item a four element vector containing \code{Ar40Ar39},
\code{s[Ar40Ar39]}, \code{J}, \code{s[J]},

\item a six element vector containing \code{U}, \code{s[U]}, \code{Th},
\code{s[Th]}, \code{He} and \code{s[He]},

\item an eight element vector containing \code{U}, \code{s[U]},
\code{Th}, \code{s[Th]}, \code{He}, \code{s[He]}, \code{Sm} and
\code{s[Sm]}
}

OR

\itemize{
\item an object of class \code{UPb}, \code{ArAr}, \code{ReOs},
\code{UThHe} or \code{fissiontracks}.
}}

\item{...}{additional arguments}

\item{method}{one of either \code{'Pb206U238'}, \code{'Pb207U235'},
\code{'Pb207Pb206'}, \code{'Ar-Ar'}, \code{'Re-Os'},
\code{U-Th-He} or \code{fissiontracks}}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{J}{two-element vector with the J-factor and its standard
error.}

\item{zeta}{two-element vector with the zeta-factor and its standard
error.}

\item{rhoD}{two-element vector with the track density of the
dosimeter glass and its standard error.}

\item{concordia}{scalar flag indicating whether each U-Pb analysis
should be considered separately (\code{concordia=1}), a
concordia age should be calculated from all U-Pb analyses
together (\code{concordia=2}), or a discordia line should be
fit through all the U-Pb analyses (\code{concordia=3}).}

\item{wetherill}{logical flag to indicate whether the data should
be evaluated in Wetherill (\code{TRUE}) or Tera-Wasserburg
(\code{FALSE}) space.  This option is only used when
\code{concordia=2}}

\item{i}{(optional) index of a particular aliquot}

\item{sigdig}{number of significant digits for the uncertainty
estimate (only used if \code{concordia=1}, \code{isochron=FALSE}
or \code{central=FALSE}).}

\item{isochron}{logical flag indicating whether each Ar-Ar analysis
should be considered separately (\code{isochron=FALSE}) or an
isochron age should be calculated from all Ar-Ar analyses
together (\code{isochron=TRUE}).}

\item{central}{logical flag indicating whether each U-Th-He analysis
should be considered separately (\code{central=FALSE}) or a
central age should be calculated from all U-Th-He analyses
together (\code{central=TRUE}).}
}
\value{
\enumerate{

\item if \code{x} is a scalar or a vector, returns the age using
the geochronometer given by \code{method} and its standard error.

\item if \code{x} has class \code{UPb} and \code{concordia=1},
returns a table with the following columns: \code{t.75},
\code{err[t.75]}, \code{t.68}, \code{err[t.68]}, \code{t.76},
\code{err[t.76]}, \code{t.conc}, \code{err[t.conc]}, containing the
\eqn{^{207}}Pb/\eqn{^{235}}U-age and standard error, the
\eqn{^{206}}Pb/\eqn{^{238}}U-age and standard error, the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-age and standard error, and the
concordia age and standard error, respectively.
 
\item if \code{x} has class \code{UPb} and \code{concordia=2},
returns a list with the following items:

\describe{
\item{x}{ a named vector with the (weighted mean) U-Pb composition }

\item{cov}{ the covariance matrix of the (mean) U-Pb composition }

\item{age}{ the concordia age (in Ma) }

\item{age.err}{ the standard error of the concordia age }

\item{mswd}{ a list with two items (\code{equivalence} and
\code{concordance}) containing the MSWD (Mean of the Squared
Weighted Deviates, a.k.a the reduced Chi-squared statistic outside
of geochronology) of isotopic equivalence and age concordance,
respectively. }

\item{p.value}{ a list with two items (\code{equivalence} and
\code{concordance}) containing the p-value of the Chi-square test
for isotopic equivalence and age concordance, respectively. }
}

\item if \code{x} has class \code{UPb} and \code{concordia=3},
returns a list with the following items:

\describe{
\item{x}{ a two element vector with the upper and lower intercept
ages (if wetherill==TRUE) or the lower intercept age and
\eqn{^{207}}Pb/\eqn{^{206}}Pb intercept (for Tera-Wasserburg) }

\item{cov}{ the covariance matrix of the elements in \code{x} }
}

\item if \code{x} has class \code{ArAr} or \code{ReOs} and \code{isochron=FALSE},
returns a table of Ar-Ar or Re-Os ages and standard errors.

\item if \code{x} has class \code{ArAr} or \code{ReOs} and
\code{isochron=TRUE}, returns a list with the following items:

\describe{

\item{a}{ the intercept of the straight line fit and its standard
error. }

\item{b}{ the slope of the fit and its standard error. }

\item{y0}{ the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar or initial
\eqn{^{187}}Os/\eqn{^{188}}Os ratio and its standard error. }

\item{age}{ the \eqn{^{40}}Ar/\eqn{^{39}}Ar or
\eqn{^{187}}Os/\eqn{^{187}}Re age and its standard error. }

}

\item if \code{x} has class \code{UThHe} and \code{central=FALSE},
returns a table of U-Th-He ages and standard errors.

\item if \code{x} has class \code{UThHe} and \code{central=TRUE},
returns a list with the following items:

\describe{

\item{uvw}{ a three-element list with the weighted mean log[U/He],
log[Th/He] and log[Sm/He] compositions. }

\item{covmat}{ a 3x3 covariance matrix for uvw}

\item{mswd}{ the reduced Chi-square value for the
log[U/He]-log[Th/He] compositions. }

\item{p.value}{ the p-value of concordance between the
log[U/He]-log[Th/He] compositions. }

\item{age}{ two-element vector with the central age and its
standard error. }

}

\item if \code{x} has class \code{fissiontracks} and
\code{central=FALSE}, returns a table of fission track ages and
standard errors.

\item if \code{x} has class \code{fissiontracks} and
\code{central=TRUE}, returns a list with the following items:

\describe{

\item{mswd}{ the reduced Chi-square value for the fission track
ages. }

\item{p.value}{ the p-value of concordance between the fission
track ages. }

\item{age}{ a two-element vector with the central age and its
standard error. }

\item{disp}{ the (over)dispersion of the single grain ages beyond
the formal analytical uncertainties. }
}
}
}
\description{
Calculates  ages and propagates their analytical
uncertainties.
}
\examples{
data(examples)
print(age(examples$UPb))
print(age(examples$UPb,concordia=1))
print(age(examples$UPb,concordia=2))
}

