% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ludwig.R
\name{ludwig}
\alias{ludwig}
\alias{ludwig.default}
\title{Linear regression of U-Pb data with correlated errors, taking
into account decay constant uncertainties.}
\usage{
ludwig(x, ...)

\method{ludwig}{default}(x, exterr = FALSE, alpha = 0.05, model = 1,
  anchor = list(FALSE, NA), ...)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{...}{optional arguments}

\item{exterr}{propagate external sources of
uncertainty (i.e. decay constants)?}

\item{alpha}{cutoff value for confidence intervals}

\item{model}{one of three regression models:

\code{1}: fit a discordia line through the data using the maximum
likelihood algorithm of Ludwig (1998), which assumes that the
scatter of the data is solely due to the analytical
uncertainties. In this case, \code{IsoplotR} will either calculate
an upper and lower intercept age (for Wetherill concordia), or a
lower intercept age and common
(\eqn{^{207}}Pb/\eqn{^{206}}Pb)\eqn{_\circ}-ratio intercept (for
Tera-Wasserburg). If \eqn{MSWD}>0, then the analytical
uncertainties are augmented by a factor \eqn{\sqrt{MSWD}}.

\code{2}: fit a discordia line ignoring the analytical uncertainties

\code{3}: fit a discordia line using a modified maximum likelihood
algorithm that includes accounts for any overdispersion by adding a
geological (co)variance term.}

\item{anchor}{control parameters to fix the intercept age or common
    Pb composition of the discordia fit. This is a two-element
    list.

The first element is a boolean flag indicating whether the
discordia line should be anchored. If this is \code{FALSE}, then
the second item is ignored and both the common Pb composition and
age are estimated.

If the first element is \code{TRUE} and the second element is
\code{NA}, then the common Pb composition is fixed at the values
stored in \code{settings('iratio',...)}.

If the first element is \code{TRUE} and the second element is a
number, then the discordia line is forced to intersect the
concordia line at an age equal to that number.}
}
\value{
\describe{

\item{LL}{the log likelihood of the discordia fit}

\item{par}{a vector with the lower concordia intercept, the common
Pb ratios and (if \code{model=3}) the dispersion parameter}

\item{cov}{the covariance matrix of \code{par}}

\item{logpar}{the logarithms of \code{par}}

\item{logcov}{the logarithms of \code{cov}}

\item{df}{the degrees of freedom of the model fit (\eqn{n-2} if
\code{x$format<4} or \eqn{2n-3} if \code{x$format>3}, where \eqn{n}
is the number of aliquots).}

\item{mswd}{the mean square of weighted deviates (a.k.a. reduced
Chi-square statistic) for the fit.}

\item{p.value}{p-value of a Chi-square test for the linear fit}

}
}
\description{
Implements the maximum likelihood algorithm for Total-Pb/U isochron
regression of Ludwig (1998) and extends the underlying methodology
to accommodate U-Th-Pb data and initial U-series disequilibrium.
}
\details{
The 3-dimensional regression algorithm of Ludwig and Titterington
(1994) was modified by Ludwig (1998) to fit so-called `Total Pb-U
isochrons'. These are constrained to a radiogenic endmember
composition that falls on the \code{\link{concordia}} line. In its
most sophisticated form, this algorithm does not only allow for
correlated errors between variables, but also between
aliquots. \code{IsoplotR} currently uses this algorithm to
propagate decay constant uncertainties in the total Pb-U isochron
ages.
}
\examples{
f <- system.file("UPb4.csv",package="IsoplotR")
d <- read.data(f,method="U-Pb",format=4)
fit <- ludwig(d)

}
\references{
Ludwig, K.R., 1998. On the treatment of concordant uranium-lead
ages. Geochimica et Cosmochimica Acta, 62(4), pp.665-676.

Ludwig, K.R. and Titterington, D.M., 1994. Calculation of
\eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.
}
\seealso{
\code{\link{concordia}}, \code{\link{titterington}},
    \code{\link{isochron}}
}
