/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.SyntaxArea;
import org.rosuda.JGR.toolkit.SyntaxDocument;
import org.rosuda.JGR.toolkit.iFrame;

public class SyntaxInput
extends SyntaxArea
implements KeyListener {
    private boolean disableEnter = false;
    private String fun = null;
    private String funHelp = null;
    Popup funHelpTip = null;
    private Popup cmdHelp = null;
    private JToolTip Tip = new JToolTip();
    public CodeCompleteMultiple mComplete;
    private Point pc;
    private Point pco;
    private Point ph;
    private iFrame parent;
    private String comp;

    public SyntaxInput(String string, boolean bl) {
        this.disableEnter = bl;
        this.addKeyListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SyntaxInput.this.funHelpTip != null) {
                    SyntaxInput.this.funHelpTip.hide();
                }
                if (SyntaxInput.this.mComplete != null && SyntaxInput.this.mComplete.isVisible()) {
                    if (SyntaxInput.this.cmdHelp != null) {
                        SyntaxInput.this.cmdHelp.hide();
                    }
                    SyntaxInput.this.mComplete.setVisible(false);
                }
            }
        });
        this.setDocument(new SyntaxInputDocument());
        this.mComplete = new CodeCompleteMultiple(this);
        this.comp = string;
        this.setFocusTraversalKeysEnabled(false);
    }

    private String getLastCommand() {
        char c;
        int n;
        int n2;
        int n3;
        if (this.funHelpTip != null) {
            this.funHelpTip.hide();
        }
        Object var1_1 = null;
        String string = this.getText();
        int n4 = this.getCaretPosition();
        int n5 = this.getText(0, n4 + 1).lastIndexOf(40);
        int n6 = this.getText(0, n4).lastIndexOf(41);
        if (n6 > n5) {
            return null;
        }
        if (n5 < 0) {
            return null;
        }
        if (n4 < 0) {
            return null;
        }
        try {
            n3 = this.getLineOfOffset(n4);
            n2 = this.getLineStartOffset(n3);
            n = this.getLineEndOffset(n3);
            if (n5 > n) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (string.substring(n2, n4).indexOf("#") >= 0) {
            return null;
        }
        int n7 = n5--;
        int n8 = n5;
        if (string == null) {
            return null;
        }
        for (n4 = n5; n7 > -1 && n4 > -1 && ((c = string.charAt(n4)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_'); --n7, --n4) {
        }
        n7 = n7 == -1 ? 0 : n7;
        try {
            n3 = this.getLineOfOffset(this.getCaretPosition());
            n2 = this.getLineStartOffset(n3);
            n = this.getLineEndOffset(n3);
            if (n7 < n2 || n8 > n) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (this.getCaretPosition() < n7) {
            return null;
        }
        return n7 != (n8 = ++n5) ? string.substring(n7, n8).trim() : null;
    }

    private String getLastPart() {
        char c;
        Object var1_1 = null;
        String string = this.getText();
        int n = this.getCaretPosition();
        if (n > 0 && string.length() > 0 && string.charAt(n - 1) == '(') {
            --n;
        }
        if (n < 0) {
            return null;
        }
        int n2 = n - 1;
        int n3 = n--;
        if (string == null) {
            return null;
        }
        int n4 = string.length();
        while (n2 > -1 && n > -1 && ((c = string.charAt(n)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '\\' || c == '/' || c == '~' || c == '$')) {
            --n2;
            --n;
        }
        n2 = n2 == -1 ? 0 : ++n2;
        return n2 != n3 ? string.substring(n2, n3).trim() : null;
    }

    public void commentSelection(boolean bl) throws BadLocationException {
        int n = this.getLineOfOffset(this.getSelectionEnd());
        for (int i = this.getLineOfOffset(this.getSelectionStart()); i <= n; ++i) {
            int n2;
            int n3 = this.getLineStartOffset(i);
            n3 = this.getSelectionStart() > n3 ? this.getSelectionStart() : n3;
            int n4 = this.getLineEndOffset(i);
            if (bl && !this.getText(n3, n4 - n3).trim().startsWith("#") && !this.getText(n3 - 1, 1).equals("#")) {
                this.insertAt(n3, "#");
            }
            if (bl || (n2 = this.getText(n3 = this.getLineStartOffset(i), n4 - n3).indexOf("#")) < 0) continue;
            this.getDocument().remove(n3 + n2, 1);
        }
    }

    public void shiftSelection(int n) throws BadLocationException {
        int n2 = this.getLineOfOffset(this.getSelectionEnd());
        for (int i = this.getLineOfOffset(this.getSelectionStart()); i <= n2; ++i) {
            int n3 = this.getLineStartOffset(i);
            int n4 = this.getLineEndOffset(i);
            if (n == -1 && this.getText(n3, n4 - n3).startsWith("\t")) {
                this.getDocument().remove(n3, 1);
                continue;
            }
            if (n != 1) continue;
            this.insertAt(n3, "\t");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCompletions(String[] stringArray) {
        try {
            this.requestFocus(true);
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
            }
            this.pc = this.getCaret().getMagicCaretPosition();
            if (this.pc == null) {
                this.processKeyEvent(new KeyEvent(this, 400, 0L, 9, 9, '\t'));
                this.pc = this.getCaret().getMagicCaretPosition();
            }
            if (this.pco != null && this.pco.equals(this.pc)) {
                this.pc = this.pco;
            } else {
                SwingUtilities.convertPointToScreen(this.pc, this);
            }
            this.mComplete.refresh(stringArray);
            this.mComplete.setVisible(true);
            this.cmdHelp = PopupFactory.getSharedInstance().getPopup(this, this.mComplete, this.pc.x, this.pc.y + 15);
            this.cmdHelp.show();
        }
        catch (Exception exception) {
        }
        finally {
            this.requestFocus(true);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.requestFocus(true);
        if (JGRPrefs.useEmacsKeyBindings) {
            int n;
            int n2;
            if (keyEvent.getKeyCode() == 69 && keyEvent.isControlDown()) {
                try {
                    n2 = this.getLineOfOffset(this.getCaretPosition());
                    n = this.getLineEndOffset(n2);
                    this.setCaretPosition(this.getLineCount() == 1 ? n : n - 1);
                }
                catch (Exception exception) {
                    this.setCaretPosition(this.getText().length());
                }
            }
            if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
                try {
                    n2 = this.getLineOfOffset(this.getCaretPosition());
                    n = this.getLineStartOffset(n2);
                    this.setCaretPosition(n);
                }
                catch (Exception exception) {
                    this.setCaretPosition(0);
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            int n;
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
            String string = null;
            int n2 = this.getCaretPosition();
            if (n2 == 0) {
                return;
            }
            try {
                n = this.getLineStartOffset(this.getLineOfOffset(n2));
                string = this.getText(n, n2 - n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                return;
            }
            n = string.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (n4 == 0 && c == '\'' && (n3 ^= 1) == 0) {
                    n5 = i;
                }
                if (n3 != 0 || c != '\"' || (n4 ^= 1) != 0) continue;
                n5 = i;
            }
            this.fun = this.getLastPart();
            String[] stringArray = null;
            if (n3 + n4 > 0) {
                stringArray = RController.completeFile(this.fun == null ? "" : this.fun);
            } else if (this.fun != null) {
                stringArray = RController.completeCommand(this.fun.replaceAll("\\.", "\\."));
            }
            if (stringArray != null && stringArray.length > 1) {
                if (this.funHelpTip != null) {
                    this.funHelpTip.hide();
                }
                if (this.pc == null || !this.pc.equals(this.getCaret().getMagicCaretPosition())) {
                    this.showCompletions(stringArray);
                }
            } else if (stringArray != null && stringArray.length > 0 && stringArray[0] != null && !stringArray[0].equals(this.fun)) {
                this.insertAt(n2, stringArray[0].replaceFirst(this.fun, ""));
                if (this.cmdHelp != null) {
                    this.cmdHelp.hide();
                }
                if (this.mComplete != null) {
                    this.mComplete.setVisible(false);
                }
            } else if (this.fun != null && this.fun.length() > 0) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.mComplete != null && this.mComplete.isVisible()) {
            int n = keyEvent.getKeyCode();
            if (!(n == 27 || n == 10 || n == 40 || n == 38 || n == 37 || n == 39 || n == 9 || keyEvent.isShiftDown() || keyEvent.isMetaDown() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isAltGraphDown())) {
                this.fun = this.getLastPart();
                if (this.fun != null) {
                    String[] stringArray = new String[1];
                    stringArray = RController.completeCommand(this.fun);
                    if (stringArray != null && stringArray.length > 0) {
                        if (this.funHelpTip != null) {
                            this.funHelpTip.hide();
                            this.funHelpTip = null;
                        }
                        this.showCompletions(stringArray);
                    } else {
                        if (this.cmdHelp != null) {
                            this.cmdHelp.hide();
                        }
                        this.mComplete.setVisible(false);
                    }
                } else {
                    if (this.cmdHelp != null) {
                        this.cmdHelp.hide();
                    }
                    this.mComplete.setVisible(false);
                }
            }
        } else if (keyEvent.getKeyCode() == 10) {
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
            }
            this.mComplete.setVisible(false);
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
        }
        if (!(keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10 || keyEvent.isMetaDown() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || !JGRPrefs.useHelpAgent || !this.isHelpAgentWanted() || keyEvent.isShiftDown())) {
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
                this.funHelpTip = null;
            }
            this.showFunHelp(this.getLastCommand());
        }
        if (keyEvent.getKeyCode() == 27) {
            if (this.cmdHelp != null) {
                this.cmdHelp.hide();
                this.pco = this.pc;
            }
            this.mComplete.setVisible(false);
            if (this.funHelpTip != null) {
                this.funHelpTip.hide();
            }
            this.pc = null;
        }
        if ((this.mComplete.isVisible() || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 9) && this.funHelpTip != null) {
            this.funHelpTip.hide();
        }
    }

    private boolean isHelpAgentWanted() {
        if (this.comp.equals("console")) {
            return JGRPrefs.useHelpAgentConsole;
        }
        if (this.comp.equals("editor")) {
            return JGRPrefs.useHelpAgentEditor;
        }
        return JGRPrefs.useHelpAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFunHelp(String string) {
        try {
            this.requestFocus(true);
            this.funHelp = RController.getFunHelpTip(string);
            if (string != null && this.funHelp != null) {
                this.Tip = new JToolTip();
                this.Tip.setTipText(this.funHelp);
                this.Tip.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (SyntaxInput.this.funHelpTip != null) {
                            SyntaxInput.this.funHelpTip.hide();
                            SyntaxInput.this.funHelpTip = null;
                        }
                    }
                });
                this.ph = this.getCaret().getMagicCaretPosition();
                SwingUtilities.convertPointToScreen(this.ph, this);
                this.funHelpTip = PopupFactory.getSharedInstance().getPopup(this, this.Tip, this.ph.x, this.ph.y + 20);
                this.funHelpTip.show();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.requestFocus(true);
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (this.disableEnter && keyEvent.getKeyCode() == 10) {
            return true;
        }
        if (this.mComplete.isVisible() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
            return true;
        }
        InputMap inputMap = this.getInputMap(n);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    public class CodeCompleteMultiple
    extends JPanel {
        public JList cmds = new JList();
        private JScrollPane sp = new JScrollPane();
        private SyntaxInput parent = null;

        public CodeCompleteMultiple(SyntaxInput syntaxInput2) {
            this.parent = syntaxInput2;
            this.cmds.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        CodeCompleteMultiple.this.completeCommand();
                    }
                }
            });
            this.cmds.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        CodeCompleteMultiple.this.completeCommand();
                    }
                }
            });
            this.sp = new JScrollPane(this.cmds);
            this.sp.setMinimumSize(new Dimension(200, 120));
            this.sp.setPreferredSize(new Dimension(200, 120));
            this.sp.setMaximumSize(new Dimension(200, 120));
            this.sp.setVerticalScrollBarPolicy(22);
            this.sp.setAutoscrolls(true);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.sp);
            this.setVisible(false);
        }

        public void refresh(String[] stringArray) {
            this.cmds.setListData(stringArray);
            this.cmds.setSelectedIndex(0);
            this.cmds.ensureIndexIsVisible(0);
        }

        public void completeCommand() {
            this.parent.insertAt(this.parent.getCaretPosition(), this.cmds.getSelectedValue().toString().replaceFirst(SyntaxInput.this.fun == null ? "" : SyntaxInput.this.fun, ""));
            this.setVisible(false);
            if (SyntaxInput.this.cmdHelp != null) {
                SyntaxInput.this.cmdHelp.hide();
            }
        }

        public void selectPrevious() {
            int n = this.cmds.getSelectedIndex();
            if (--n >= 0) {
                this.cmds.setSelectedIndex(n);
            }
            this.cmds.ensureIndexIsVisible(this.cmds.getSelectedIndex());
        }

        public void selectNext() {
            int n = this.cmds.getSelectedIndex();
            if (++n < this.cmds.getModel().getSize()) {
                this.cmds.setSelectedIndex(n);
            }
            this.cmds.ensureIndexIsVisible(this.cmds.getSelectedIndex());
        }

        public void setVisible(boolean bl) {
            if (!bl && SyntaxInput.this.cmdHelp != null) {
                SyntaxInput.this.cmdHelp.hide();
            }
            super.setVisible(bl);
        }
    }

    class SyntaxInputDocument
    extends SyntaxDocument {
        SyntaxInputDocument() {
        }
    }
}

