/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.HeadNode;
import org.rosuda.JGR.browser.Refresher;

public class BrowserTree
extends JTree {
    HeadNode head;
    DefaultTreeModel mod;
    Refresher ref;
    static int nodeOffset = -1;

    public BrowserTree() {
        if (nodeOffset == -1) {
            nodeOffset = (Integer)UIManager.get("Tree.rightChildIndent") + (Integer)UIManager.get("Tree.leftChildIndent");
        }
        this.head = new HeadNode();
        this.mod = new DefaultTreeModel(this.head);
        this.setModel(this.mod);
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new BrowserCellRenderer());
        new Thread(new Runnable(){

            public void run() {
                BrowserTree.this.head.update(BrowserTree.this.mod);
            }
        }).start();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.repaint();
        ExpandListener expandListener = new ExpandListener();
        this.addTreeWillExpandListener(expandListener);
        this.addTreeExpansionListener(expandListener);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.addMouseListener(treeMouseListener);
        this.setRowHeight(0);
        this.setToggleClickCount(1000);
    }

    public void startRefresher() {
        if (this.ref != null) {
            return;
        }
        this.ref = new Refresher(this.mod);
        new Thread(this.ref).start();
    }

    public void stopRefresher() {
        if (this.ref != null) {
            this.ref.stopRunning();
            this.ref = null;
        }
    }

    class TreeMouseListener
    implements MouseListener {
        TreeMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = BrowserTree.this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                BrowserTree.this.setSelectionRow(n);
                final BrowserNode browserNode = (BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent();
                new Thread(new Runnable(){

                    public void run() {
                        browserNode.editObject();
                    }
                }).start();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.pop(mouseEvent);
            } else {
                int n = BrowserTree.this.getParent().getWidth();
                if (mouseEvent.getX() < n - nodeOffset && mouseEvent.getX() >= n - nodeOffset * 2) {
                    this.pop(mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.pop(mouseEvent);
            }
        }

        private void pop(MouseEvent mouseEvent) {
            int n = BrowserTree.this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            BrowserTree.this.setSelectionRow(n);
            JPopupMenu jPopupMenu = ((BrowserNode)BrowserTree.this.getSelectionPath().getLastPathComponent()).getPopupMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class ExpandListener
    implements TreeWillExpandListener,
    TreeExpansionListener {
        ExpandListener() {
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            final BrowserNode browserNode = (BrowserNode)treeExpansionEvent.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                public void run() {
                    browserNode.setExpanded(true);
                    browserNode.update(((ExpandListener)ExpandListener.this).BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ExpandListener)(this).ExpandListener.this).BrowserTree.this.mod.reload(browserNode);
                        }
                    });
                }
            }).start();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            final BrowserNode browserNode = (BrowserNode)treeExpansionEvent.getPath().getLastPathComponent();
            new Thread(new Runnable(){

                public void run() {
                    browserNode.setExpanded(false);
                    browserNode.update(((ExpandListener)ExpandListener.this).BrowserTree.this.mod);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ExpandListener)(this).ExpandListener.this).BrowserTree.this.mod.reload(browserNode);
                        }
                    });
                }
            }).start();
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }
    }

    class BrowserCellRenderer
    implements TreeCellRenderer {
        BrowserCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            BrowserNode browserNode = (BrowserNode)object;
            return browserNode.getRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }
}

