% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmc_0.R
\name{jmc_0}
\alias{jmc_0}
\title{Joint Modelling for Continuous outcomes}
\usage{
jmc_0(
  p,
  yfile,
  cfile,
  mfile,
  point = 20,
  maxiterations = 1e+05,
  do.trace = FALSE,
  type_file = TRUE
)
}
\arguments{
\item{p}{The dimension of fixed effects (include intercept) in yfile.}

\item{yfile}{Y matrix for longitudinal measurements in long format. For example, for a subject with n measurements, there should be n rows for this subject. The # of rows in y matrix is the total number of measurements for all subjects in the study. The columns in Y should start with the longitudinal outcome (column 1), the covariates for the random effects, and then the covariates for the fixed effects.}

\item{cfile}{C matrix for competing risks failure time data. Each subject has one data entry, so the number of rows equals to the number of subjects. The survival / censoring time is included in the first column, and the failure type coded as 0 (censored events), 1 (risk 1), or 2 (risk 2) is given in the second column. Two competing risks are assumed. The covariates are included in the third column and on.}

\item{mfile}{M vector to indicate the number of longitudinal measurements per subject. The number of rows equals to the number of subjects.}

\item{point}{Quadrature points used in the EM procedure.Default is 20.}

\item{maxiterations}{Maximum values of iterations. Default is 100000.}

\item{do.trace}{Print detailed information of each iteration. Default is false, i.e., not to print the iteration details.}

\item{type_file}{Types of inputs. Default is true, i.e.  data files with headers. If set to "F", inputs are changed to data matrixes or data.frames (with headers)}
}
\value{
Object of class \code{JMcmprsk} with elements
  \tabular{ll}{
      \code{vcmatrix}    \tab  The variance-covariance matrix for all the parameters. The parameters are in the order: \eqn{\beta}, \eqn{\sigma^2}, \eqn{\gamma}, \eqn{\nu}, and \eqn{\Sigma}. The elements in \eqn{\Sigma} are output in the order along the main diagonal line, then the second main diagonal line, and so on. \cr
      \code{betas} \tab The point  estimates of \eqn{\beta}. \cr
      \code{se_betas} \tab The standard error estimate of \eqn{\beta}. \cr
      \code{gamma_matrix} \tab  The point  estimate of \eqn{\gamma}. \cr
      \code{se_gamma_matrix}   \tab  The standard error estimate of \eqn{\gamma}. \cr
      \code{v_estimate} \tab The point  estimate of \eqn{\nu}. \cr
      \code{se_v_estimate}    \tab The standard error estimate of \eqn{\nu}. \cr
      \code{sigma2_val}     \tab  The point estimate of \eqn{\sigma^2}.\cr
      \code{se_sigma2_val}     \tab  The standard error estimate of \eqn{\sigma^2}.\cr
      \code{sigma_matrix}     \tab The point estimate of \eqn{\Sigma} (only the upper triangle portion of the matrix is output).\cr
      \code{se_sigma}     \tab The standard error estimate of \eqn{\Sigma}.The standard errors are given in this order: main diagonal, the second main diagonal, and so on. \cr
      \code{loglike}     \tab Log Likelihood.\cr
  }
}
\description{
Joint modeling of longitudinal continuous data and competing risks
}
\examples{
# A toy example on a dataset called from file paths
require(JMcmprsk)
set.seed(123)
yfile=system.file("extdata", "jmcsimy.txt", package = "JMcmprsk")
cfile=system.file("extdata", "jmcsimc.txt", package = "JMcmprsk")
mfile=system.file("extdata", "jmcsimm.txt", package = "JMcmprsk")
jmc_0fit = jmc_0(p=4, yfile, cfile, mfile, point=6, do.trace = FALSE)
\dontrun{
# A toy example on data frames/matrices
require(JMcmprsk)
set.seed(123)
data(lung)
lungY <- lung[, c(2:11)]
lungC <- unique(lung[, c(1, 12, 13, 6:10)])
lungC <- lungC[, -1]
lungM <- data.frame(table(lung$ID))
lungM <- as.data.frame(lungM[, 2])
res1=jmc_0(p=8, lungY, lungC, lungM, point=20, do.trace = FALSE, type_file = FALSE)
res1
}
}
\references{
\itemize{
\item Elashoff, Robert M., Gang Li, and Ning Li. "A joint model for longitudinal measurements and survival data in the presence of multiple failure types." Biometrics 64.3 (2008): 762-771.
}
}
\seealso{
\code{\link{jmo}}
}
