% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{friedman_data}
\alias{friedman_data}
\title{Simulate data from the Friedman model}
\usage{
friedman_data(n = 500, d = 10, gamma = 10)
}
\arguments{
\item{n}{Number of points to simulate.}

\item{d}{The dimension of the predictor variable \eqn{x}.}

\item{gamma}{A parameter controlling the Bayes error, with higher values of
\code{gamma} corresponding to lower error rates.}
}
\value{
Returns a list with the following components:
\item{y}{Vector of simulated response in \code{c(-1,1)}.}
\item{X}{An \code{n}x\code{d} matrix of simulated predictors.}
\item{p}{The true conditional probability \eqn{p(y=1|x)}.}
}
\description{
Simulate draws from a bernoulli distribution over \code{c(-1,1)}, where the
log-odds is defined according to:
\deqn{log{p(y=1|x)/p(y=-1|x)} = gamma*(1 - x_1 + x_2 - ... + x_6)*(x_1 + x_2 + ... + x_6)}
and \eqn{x} is distributed as N(0, I_\code{d}x\code{d}).  See Friedman (2000).
}
\examples{
set.seed(111)
dat = friedman_data(n = 500, d = 10, gamma = 0.5)

}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2000). Additive logistic
regression: a statistical view of boosting (with discussion), Annals of
Statistics 28: 337-307.
}

