% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JacobiR.R
\name{JacobiR}
\alias{JacobiR}
\title{The Jacobi Algorithm in Pure R}
\usage{
JacobiR(x, symmetric = TRUE, only.values = FALSE, eps = if (!only.values)
  .Machine$double.eps else sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{a real symmetric matrix}

\item{symmetric}{a logical value.  Is the matrix symmetric?  (Only symmetric matrices are allowed.)}

\item{only.values}{A logical value: Do you want only the eigenvalues?}

\item{eps}{a small positive error tolerance}
}
\value{
a list of two components as for \code{base::eigen}
}
\description{
The Jacobi Algorithm
}
\details{
Eigenvalues and optionally, eigenvectore of a real symmetric matrix using the
classical Jacobi algorithm, (Jacobi, 1854)
}
\examples{
(V <- crossprod(matrix(1:25, 5)))
JacobiR(V)
identical(Jacobi(V), JacobiR(V))
all.equal(Jacobi(V)$values, base::eigen(V)$values)
}

