/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.CharFormatter;
import antlr.collections.impl.IntRange;
import antlr.collections.impl.Vector;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int NIBBLE = 4;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    public void add(int n) {
        int n2 = this.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | this.bitMask(n);
    }

    public BitSet and(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.andInPlace(bitSet);
        return bitSet2;
    }

    public void andInPlace(BitSet bitSet) {
        int n = Math.min(this.bits.length, bitSet.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n2];
            --n2;
        }
        int n4 = n;
        while (n4 < this.bits.length) {
            this.bits[n4] = 0L;
            ++n4;
        }
    }

    private final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public void clear() {
        int n = this.bits.length - 1;
        while (n >= 0) {
            this.bits[n] = 0L;
            --n;
        }
    }

    public void clear(int n) {
        int n2 = this.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (this.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int degree() {
        int n = 0;
        int n2 = this.bits.length - 1;
        while (n2 >= 0) {
            long l = this.bits[n2];
            if (l != 0L) {
                int n3 = 63;
                while (n3 >= 0) {
                    if ((l & 1L << n3) != 0L) {
                        ++n;
                    }
                    --n3;
                }
            }
            --n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BitSet) {
            int n;
            BitSet bitSet = (BitSet)object;
            int n2 = n = Math.min(this.bits.length, bitSet.bits.length);
            while (n2-- > 0) {
                if (this.bits[n2] == bitSet.bits[n2]) continue;
                return false;
            }
            if (this.bits.length > n) {
                int n3 = this.bits.length;
                while (n3-- > n) {
                    if (this.bits[n3] == 0L) continue;
                    return false;
                }
            } else if (bitSet.bits.length > n) {
                int n4 = bitSet.bits.length;
                while (n4-- > n) {
                    if (bitSet.bits[n4] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vector getRanges(int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        if (nArray.length <= 2) {
            return null;
        }
        Vector vector = new Vector(5);
        int n = 0;
        while (n < nArray.length - 2) {
            int n2 = nArray.length - 1;
            int n3 = n + 1;
            while (n3 < nArray.length) {
                if (nArray[n3] != nArray[n3 - 1] + 1) {
                    n2 = n3 - 1;
                    break;
                }
                ++n3;
            }
            if (n2 - n > 2) {
                vector.appendElement(new IntRange(nArray[n], nArray[n2]));
            }
            ++n;
        }
        return vector;
    }

    public void growToInclude(int n) {
        int n2 = Math.max(this.bits.length << 1, this.numWordsToHold(n));
        long[] lArray = new long[n2];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public boolean member(int n) {
        int n2 = this.wordNumber(n);
        if (n2 > this.bits.length) {
            return false;
        }
        return (this.bits[n2] & this.bitMask(n)) != 0L;
    }

    public boolean nil() {
        int n = this.bits.length - 1;
        while (n >= 0) {
            if (this.bits[n] != 0L) {
                return false;
            }
            --n;
        }
        return true;
    }

    public BitSet not() {
        BitSet bitSet = (BitSet)this.clone();
        bitSet.notInPlace();
        return bitSet;
    }

    public void notInPlace() {
        int n = this.bits.length - 1;
        while (n >= 0) {
            this.bits[n] = this.bits[n] ^ 0xFFFFFFFFFFFFFFFFL;
            --n;
        }
    }

    public void notInPlace(int n) {
        this.notInPlace(0, n);
    }

    public void notInPlace(int n, int n2) {
        this.growToInclude(n2);
        int n3 = n;
        while (n3 <= n2) {
            int n4;
            int n5 = n4 = this.wordNumber(n3);
            this.bits[n5] = this.bits[n5] ^ this.bitMask(n3);
            ++n3;
        }
    }

    private final int numWordsToHold(int n) {
        return (n >> 6) + 1;
    }

    public static BitSet of(int n) {
        BitSet bitSet = new BitSet(n + 1);
        bitSet.add(n);
        return bitSet;
    }

    public BitSet or(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n = Math.min(this.bits.length, bitSet.bits.length);
        int n2 = n - 1;
        while (n2 >= 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] | bitSet.bits[n2];
            --n2;
        }
    }

    public void remove(int n) {
        int n2 = this.wordNumber(n);
        if (n2 >= this.bits.length) {
            this.growToInclude(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (this.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int n) {
        long[] lArray = new long[n];
        int n2 = Math.min(n, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n2);
        this.bits = lArray;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean subset(BitSet bitSet) {
        if (bitSet == null || !(bitSet instanceof BitSet)) {
            return false;
        }
        return this.and(bitSet).equals(this);
    }

    public void subtractInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        int n = 0;
        while (n < this.bits.length && n < bitSet.bits.length) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[n] ^ 0xFFFFFFFFFFFFFFFFL);
            ++n;
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.degree()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.bits.length << 6) {
            if (this.member(n2)) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        return nArray;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        String string2 = "";
        int n = 0;
        while (n < this.bits.length << 6) {
            if (this.member(n)) {
                if (string2.length() > 0) {
                    string2 = String.valueOf(string2) + string;
                }
                string2 = String.valueOf(string2) + n;
            }
            ++n;
        }
        return string2;
    }

    public String toString(String string, CharFormatter charFormatter) {
        String string2 = "";
        int n = 0;
        while (n < this.bits.length << 6) {
            if (this.member(n)) {
                if (string2.length() > 0) {
                    string2 = String.valueOf(string2) + string;
                }
                string2 = String.valueOf(string2) + charFormatter.literalChar(n);
            }
            ++n;
        }
        return string2;
    }

    public String toString(String string, Vector vector) {
        if (vector == null) {
            return this.toString(string);
        }
        String string2 = "";
        int n = 0;
        while (n < this.bits.length << 6) {
            if (this.member(n)) {
                if (string2.length() > 0) {
                    string2 = String.valueOf(string2) + string;
                }
                string2 = n >= vector.size() ? String.valueOf(string2) + "<bad element " + n + ">" : (vector.elementAt(n) == null ? String.valueOf(string2) + "<" + n + ">" : String.valueOf(string2) + (String)vector.elementAt(n));
            }
            ++n;
        }
        return string2;
    }

    public String toStringOfHalfWords() {
        String string = new String();
        int n = 0;
        while (n < this.bits.length) {
            if (n != 0) {
                string = String.valueOf(string) + ", ";
            }
            long l = this.bits[n];
            string = String.valueOf(string) + (l &= 0xFFFFFFFFL) + "UL";
            string = String.valueOf(string) + ", ";
            l = this.bits[n] >>> 32;
            string = String.valueOf(string) + (l &= 0xFFFFFFFFL) + "UL";
            ++n;
        }
        return string;
    }

    public String toStringOfWords() {
        String string = new String();
        int n = 0;
        while (n < this.bits.length) {
            if (n != 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + this.bits[n] + "L";
            ++n;
        }
        return string;
    }

    public String toStringWithRanges(String string, CharFormatter charFormatter) {
        String string2 = "";
        int[] nArray = this.toArray();
        if (nArray.length == 0) {
            return "";
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            int n3 = n + 1;
            while (n3 < nArray.length) {
                if (nArray[n3] != nArray[n3 - 1] + 1) break;
                n2 = n3++;
            }
            if (string2.length() > 0) {
                string2 = String.valueOf(string2) + string;
            }
            if (n2 - n >= 2) {
                string2 = String.valueOf(string2) + charFormatter.literalChar(nArray[n]);
                string2 = String.valueOf(string2) + "..";
                string2 = String.valueOf(string2) + charFormatter.literalChar(nArray[n2]);
                n = n2;
            } else {
                string2 = String.valueOf(string2) + charFormatter.literalChar(nArray[n]);
            }
            ++n;
        }
        return string2;
    }

    private final int wordNumber(int n) {
        return n >> 6;
    }
}

