/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.TaskManagement;

import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.ObjectDatabase;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.System.Globals;
import org.omegahat.Environment.TaskManagement.Task;

public class SimulationTask
implements Task {
    protected Evaluator evaluator = this.getGlobalEvaluator();
    protected Database database;
    protected ExpressionInt expression;

    public synchronized Object eval() {
        Object object = null;
        this.evaluator.attach(this.database);
        try {
            object = this.evaluator.evaluate(this.expression);
        }
        catch (Throwable throwable) {
            this.evaluator.warning(throwable, "Exception during evaluation of task");
        }
        this.evaluator.detach(this.database);
        return object;
    }

    public Object eval(Object[] objectArray) {
        return this.eval();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public ExpressionInt getExpression() {
        return this.expression;
    }

    public Evaluator getGlobalEvaluator() {
        Evaluator evaluator = null;
        try {
            evaluator = Globals.evaluator();
        }
        catch (Throwable throwable) {}
        return evaluator;
    }

    public Database setDatabase(String string) {
        ObjectDatabase objectDatabase = new ObjectDatabase(1);
        objectDatabase.setName(string);
        return this.setDatabase(objectDatabase);
    }

    public Database setDatabase(Database database) {
        this.database = database;
        return this.database;
    }

    public Evaluator setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this.evaluator;
    }

    public ExpressionInt setExpression(ExpressionInt expressionInt) {
        this.expression = expressionInt;
        return this.expression;
    }
}

