/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Interpreter;

import antlr.Tokenizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.omegahat.Environment.DataStructures.Copyable;
import org.omegahat.Environment.Databases.AttachedDatabase;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.DatabaseCustomer;
import org.omegahat.Environment.Databases.LazyFunctionDatabase;
import org.omegahat.Environment.Databases.NameTypeSearchFilter;
import org.omegahat.Environment.Databases.ObjectDatabase;
import org.omegahat.Environment.Databases.ObjectNotFoundException;
import org.omegahat.Environment.Databases.PersistentObjectDatabase;
import org.omegahat.Environment.Databases.SearchPath;
import org.omegahat.Environment.Databases.TypedDatabase;
import org.omegahat.Environment.Debugger.Debugger;
import org.omegahat.Environment.Debugger.ErrorHandler;
import org.omegahat.Environment.Debugger.SystemErrorHandler;
import org.omegahat.Environment.IO.ArchiveEntry;
import org.omegahat.Environment.IO.BasicTaskDisplay;
import org.omegahat.Environment.IO.InputFileInt;
import org.omegahat.Environment.IO.ObjectDisplayFilter;
import org.omegahat.Environment.IO.TaskDisplayFilter;
import org.omegahat.Environment.Interpreter.EndSourceInputException;
import org.omegahat.Environment.Interpreter.EvaluationEvent;
import org.omegahat.Environment.Interpreter.EvaluationException;
import org.omegahat.Environment.Interpreter.EvaluationListener;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.EvaluatorManager;
import org.omegahat.Environment.Interpreter.ManagedEvaluatorInt;
import org.omegahat.Environment.Interpreter.Options;
import org.omegahat.Environment.Interpreter.SubEvaluationListener;
import org.omegahat.Environment.Interpreter.Task;
import org.omegahat.Environment.Language.Evaluable;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Parser.AntlrParser.omegaJavaGrammar;
import org.omegahat.Environment.Parser.AntlrParser.omegaNestedStringLexer;
import org.omegahat.Environment.Parser.Parse.ConstantExpression;
import org.omegahat.Environment.Parser.Parse.ConstructorExpression;
import org.omegahat.Environment.Parser.Parse.DynamicFieldAccess;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.Parser.Parse.StatementList;
import org.omegahat.Environment.System.DynamicClassLoader;
import org.omegahat.Environment.Tools.ClassList.ClassList;
import org.omegahat.Environment.Tools.ClassList.ClassLocator;
import org.omegahat.Environment.Tools.ClassList.ClassLocatorInt;
import org.omegahat.Environment.Tools.ClassList.GroupedClassLocator;
import org.omegahat.Environment.Tools.ClassList.LocalClassLocator;
import org.omegahat.Environment.Tools.FileLocator.FileLocator;
import org.omegahat.Environment.Utils.OrderedTable;
import org.omegahat.Environment.Utils.StringUtils;

public class BasicEvaluator
implements DatabaseCustomer,
Serializable,
ManagedEvaluatorInt,
Runnable {
    public static final Class[] primitive_classes = new Class[]{Integer.TYPE, Double.TYPE, Short.TYPE, Float.TYPE, Long.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Void.TYPE};
    public static final String[] primitiveTypeNames = new String[]{"int", "double", "short", "float", "long", "boolean", "byte", "char", "void"};
    public static final String[] PrimitiveClassNames = new String[]{"Integer", "Double", "Short", "Float", "Long", "Boolean", "Byte", "Character", "Void"};
    public static final String[] internalPrimitiveClassNames = new String[]{"I", "D", "S", "F", "J", "Z", "B", "C", "V"};
    public static boolean ShowMultipleClasses = false;
    protected static boolean initialized = false;
    public static Hashtable primitiveClasses = null;
    public static Hashtable primitiveTypes = null;
    public static Hashtable internalPrimitiveClassTable;
    public static Hashtable reversePrimitiveTypes;
    protected Options options = null;
    protected SearchPath databases = new SearchPath(4);
    protected Object data = null;
    protected int DefaultAttachIndex = 1;
    protected ExpressionInt toplevelExpression;
    protected Tokenizer lexer;
    protected omegaJavaGrammar parser;
    protected ObjectDisplayFilter output = null;
    protected Vector taskHistory = new Vector();
    protected Database defaultDatabase;
    protected ErrorHandler errorHandler;
    protected Vector warningMessages;
    protected ClassLocatorInt class_lists = null;
    protected LocalClassLocator localClasses;
    protected DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();
    protected EvaluatorManager manager = null;
    protected PrintWriter stderr;
    protected PrintWriter stdout;
    protected ExpressionInt currentExpression;
    protected Debugger debugger;
    protected Vector evaluationListeners;
    protected Vector SubEvaluationListeners;
    protected EvaluationEvent evaluationEvent;
    protected OrderedTable internalFunctionTables = null;
    protected boolean allowUnrestrictedAccess = true;
    protected Stack sourceStack = new Stack();
    static /* synthetic */ Class class$org$omegahat$Environment$Language$Function;
    static /* synthetic */ Class class$org$omegahat$Environment$Language$Method;
    static /* synthetic */ Class class$java$lang$Object;

    static {
        reversePrimitiveTypes = BasicEvaluator.classInit();
    }

    public BasicEvaluator() {
        this(new Options());
    }

    protected BasicEvaluator(Evaluator evaluator) {
        this.initialize(evaluator);
    }

    public BasicEvaluator(EvaluatorManager evaluatorManager) {
        try {
            this.initialize(evaluatorManager.evaluator(false));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        evaluatorManager.addEvaluator(this);
    }

    public BasicEvaluator(Options options) {
        this.options(options);
        this.init();
    }

    public boolean Debug() {
        String string = this.options().getProperty("debug", true);
        return this.Debug(string);
    }

    public boolean Debug(Boolean bl) {
        return this.Debug((boolean)bl);
    }

    public boolean Debug(Object object) {
        Class<?> clazz = object.getClass();
        String string = this.options().getProperty("debug." + clazz.getName(), true);
        return this.Debug(string);
    }

    public boolean Debug(String string) {
        if (string == null) {
            return false;
        }
        return new Boolean(string);
    }

    public boolean Debug(boolean bl) {
        ((Hashtable)this.options()).put("debug.", new Boolean(bl).toString());
        return this.Debug();
    }

    public ClassList Import(File file) {
        if (!file.canRead() && (file = (File)this.manager().fileLocator().find(file)) == null) {
            return null;
        }
        if (this.classLists() == null) {
            this.classLists(new ClassLocator());
        }
        return (ClassList)((ClassLocator)this.classLists()).add(file);
    }

    public ClassList Import(URL uRL) {
        if (this.classLists() == null) {
            this.classLists(new ClassLocator());
        }
        return (ClassList)((ClassLocator)this.classLists()).add(uRL);
    }

    public ClassList Import(Name name) {
        ClassList classList = null;
        Object object = this.findPackage(name);
        String string = System.getProperty("file.separator");
        if (this.classLists() == null) {
            this.classLists(new ClassLocator());
        }
        if (object instanceof File || object instanceof ZipFile) {
            System.err.println("Importing from " + object + " " + object.getClass());
            classList = ((ClassLocator)this.classLists()).classList((File)object, String.valueOf(string) + name.collapse(string));
            classList.setPackageName(name.collapse(string));
        }
        if (classList == null) {
            throw new RuntimeException("Cannot find directory " + name.collapse() + " to import.");
        }
        ((ClassLocator)this.classLists()).add(classList, classList.packageName());
        return classList;
    }

    public int addEvaluationListener(EvaluationListener evaluationListener) {
        Vector<EvaluationListener> vector2;
        boolean bl = evaluationListener instanceof SubEvaluationListener;
        Vector<EvaluationListener> vector3 = vector2 = bl ? this.getSubEvaluationListeners() : this.getEvaluationListeners();
        if (vector2 == null) {
            vector2 = new Vector<EvaluationListener>();
            if (bl) {
                this.setSubEvaluationListeners(vector2);
            } else {
                this.setEvaluationListeners(vector2);
            }
        }
        vector2.addElement(evaluationListener);
        EvaluationEvent evaluationEvent = this.getEvaluationEvent();
        if (evaluationEvent == null || evaluationEvent.getSource() != this) {
            this.setEvaluationEvent(new EvaluationEvent(this));
        }
        return vector2.size();
    }

    public int addFunctionTable(Object object) {
        String string = object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1, string.length());
        }
        return this.addFunctionTable(object, string);
    }

    public int addFunctionTable(Object object, String string) {
        if (this.internalFunctionTables == null) {
            this.internalFunctionTables(new OrderedTable(2));
        }
        this.internalFunctionTables.put(string, object);
        return this.internalFunctionTables.size();
    }

    public boolean addMethod(org.omegahat.Environment.Language.Method method, Name name) {
        this.stderr().println("System level method " + name);
        return true;
    }

    public Object addSourceInput(Object object) {
        return this.sourceStack().push(object);
    }

    public Task addToHistory(Object object, Object object2, String string) {
        Task task = new Task(string, (ExpressionInt)object);
        task.value(object2);
        this.taskHistory().addElement(task);
        return task;
    }

    public boolean allowUnrestrictedAccess() {
        return this.allowUnrestrictedAccess;
    }

    public boolean allowUnrestrictedAccess(boolean bl) {
        this.allowUnrestrictedAccess = bl;
        return this.allowUnrestrictedAccess();
    }

    public Object asObject(Name name) throws Throwable {
        return this.asObject(name, name.size());
    }

    public Object asObject(Name name, int n) throws Throwable {
        return this.asObject(name, n, false);
    }

    /*
     * Unable to fully structure code
     */
    public Object asObject(Name var1_1, int var2_2, boolean var3_3) throws Throwable {
        block7: {
            block8: {
                var4_4 = (String)var1_1.elementAt(0);
                var5_5 = null;
                var6_6 = this.which(var4_4);
                if (var6_6 != null) {
                    return var6_6.get(var4_4);
                }
                try {
                    var5_5 = this.findAsField(var1_1, var2_2, var3_3);
                    break block7;
                }
                catch (Exception v0) {
                    if (this.internalFunctionTables != null && this.internalFunctionTables.containsKey((String)var1_1.elementAt(0))) {
                        return this.internalFunctionTables.get((String)var1_1.elementAt(0));
                    }
                    var8_7 = new DynamicFieldAccess((String)var1_1.elementAt(var2_2 - 1));
                    if (this.internalFunctionTables == null) break block8;
                    var9_8 = this.internalFunctionTables.elements();
                    ** while (var9_8.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    var7_9 = var9_8.nextElement();
                    var8_7.qualifier(new ConstantExpression(var7_9));
                    try {
                        return var8_7.eval(this);
                    }
                    catch (Throwable v1) {}
                    continue;
                }
            }
            var8_7.qualifier(new ConstantExpression(this));
            return var8_7.eval(this);
        }
        return var5_5;
    }

    public String asObjectName(Name name) {
        return name.collapse();
    }

    public Class asPrimitiveClass(String string) {
        return (Class)primitiveTypes.get(string);
    }

    public PrintWriter asWriter(OutputStream outputStream) {
        if (outputStream != null) {
            return new PrintWriter(outputStream, true);
        }
        return null;
    }

    public boolean assign(String string, Object object) throws Exception {
        return this.assign(string, object, 0);
    }

    public boolean assign(String string, Object object, int n) throws Exception {
        if (n < 0 || n > this.databases.size() - 1) {
            return false;
        }
        return this.assign(string, object, (Database)this.databases.elementAt(n));
    }

    public boolean assign(String string, Object object, Database database) throws Exception {
        if (database == null) {
            return false;
        }
        database.assign(string, object);
        return true;
    }

    public AttachedDatabase attach(File file) throws Exception {
        return this.attach(file, this.DefaultAttachIndex);
    }

    public AttachedDatabase attach(File file, int n) throws Exception {
        ObjectDatabase objectDatabase = file.isDirectory() ? new PersistentObjectDatabase(file) : ObjectDatabase.readSerialized(new FileInputStream(file));
        return this.attach(objectDatabase, n);
    }

    public AttachedDatabase attach(String string) {
        return this.attach(string, this.DefaultAttachIndex);
    }

    public AttachedDatabase attach(String string, int n) {
        return this.attach(new ObjectDatabase(string), n);
    }

    public AttachedDatabase attach(URL uRL) {
        throw new RuntimeException("attach(URL) not implemented yet");
    }

    public AttachedDatabase attach(Database database) {
        return this.attach(database, this.DefaultAttachIndex);
    }

    public AttachedDatabase attach(Database database, int n) {
        if (!database.attach(this)) {
            return null;
        }
        return this.searchPath().attach(database, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static synchronized Hashtable classInit() {
        if (initialized) {
            return reversePrimitiveTypes;
        }
        int n = primitive_classes.length;
        Class clazz = null;
        primitiveClasses = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            clazz = primitive_classes[n2];
            primitiveClasses.put("java.lang." + PrimitiveClassNames[n2], clazz);
            ++n2;
        }
        primitiveTypes = new Hashtable(primitiveTypeNames.length);
        Hashtable hashtable = new Hashtable(primitiveTypeNames.length);
        n2 = 0;
        while (n2 < primitiveTypeNames.length) {
            clazz = primitive_classes[n2];
            primitiveTypes.put(primitiveTypeNames[n2], clazz);
            try {
                hashtable.put(primitiveTypeNames[n2], Class.forName("java.lang." + PrimitiveClassNames[n2]));
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
        Hashtable<Class, String> hashtable2 = new Hashtable<Class, String>(n);
        n2 = 0;
        while (n2 < n) {
            hashtable2.put(primitive_classes[n2], internalPrimitiveClassNames[n2]);
            ++n2;
        }
        internalPrimitiveClassTable = hashtable2;
        initialized = true;
        return hashtable;
    }

    public ClassLocatorInt classLists() {
        String string;
        if (this.class_lists == null && ((string = System.getProperty("OmegahatClassLists")) == null || new Boolean(string).booleanValue())) {
            this.createClassLists();
        }
        return this.class_lists;
    }

    protected ClassLocatorInt classLists(ClassLocatorInt classLocatorInt) {
        this.class_lists = classLocatorInt;
        return this.classLists();
    }

    public Vector classPath() {
        String string = System.getProperty("java.class.path");
        return this.classPath(string);
    }

    public Vector classPath(String string) {
        Vector<String> vector2;
        block5: {
            String string2 = System.getProperty("path.separator");
            String[] stringArray = StringUtils.stringList(string, string2.charAt(0));
            vector2 = new Vector<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                vector2.addElement(stringArray[n]);
                ++n;
            }
            if (vector2.size() != 1) break block5;
            try {
                String string3 = (String)vector2.elementAt(0);
                Object object = this.getBaseURL(string3);
                JarFile jarFile = new JarFile(string3);
                String string4 = jarFile.getManifest().getMainAttributes().getValue("Class-Path");
                stringArray = StringUtils.stringList(string4, ' ');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    vector2.addElement(this.expandedClassPathElement(stringArray[n2], object));
                    ++n2;
                }
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        return vector2;
    }

    public String[] commandLine() {
        if (this.manager() != null) {
            return this.manager().commandLine();
        }
        return null;
    }

    public Object convertPrimitive(Object object, Class clazz) {
        Object object2 = object;
        if (clazz == Integer.TYPE) {
            if (object instanceof Number) {
                object2 = new Integer(((Number)object).intValue());
            }
        } else if (clazz == Double.TYPE) {
            if (object instanceof Number) {
                object2 = new Double(((Number)object).doubleValue());
            }
        } else if (clazz == Long.TYPE) {
            if (object instanceof Number) {
                object2 = new Long(((Number)object).longValue());
            }
        } else if (clazz == Short.TYPE && object instanceof Number) {
            object2 = new Short(((Number)object).shortValue());
        }
        return object2;
    }

    public Object copy(Object object) throws Exception {
        return this.copy(object, true);
    }

    public Object copy(Object object, boolean bl) throws Exception {
        Object object2 = null;
        object2 = this.copyByConstructor(object, bl);
        if (object2 == null) {
            object2 = this.copyBySerialization(object);
        }
        return object2;
    }

    public Object copyByConstructor(Object object, boolean bl) {
        Object object2 = null;
        if (object instanceof Copyable) {
            return ((Copyable)object).copy(bl);
        }
        try {
            Object[] objectArray = new Object[]{object, new Boolean(bl)};
            ConstructorExpression constructorExpression = new ConstructorExpression(object.getClass().getName(), objectArray, false);
            object2 = constructorExpression.eval(object.getClass(), (Evaluator)this);
        }
        catch (Throwable throwable) {}
        return object2;
    }

    public Object copyBySerialization(Object object) throws IOException, ClassNotFoundException {
        Object object2 = null;
        if (object instanceof Serializable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        return object2;
    }

    public ClassLocatorInt createClassLists() {
        OrderedTable orderedTable;
        String string = System.getProperty("OmegahatClassList");
        Vector vector2 = string != null ? this.classPath(string) : this.classPath();
        boolean bl = false;
        if (((Hashtable)System.getProperties()).containsKey("groupedClassList")) {
            bl = new Boolean(System.getProperty("groupedClassList"));
        }
        if (bl) {
            System.err.println("Using grouped class lists");
            orderedTable = new GroupedClassLocator(vector2);
        } else {
            orderedTable = new ClassLocator(vector2);
        }
        this.classLists((ClassLocatorInt)((Object)orderedTable));
        if (this.javaVersion() > 1) {
            String string2 = System.getProperty("java.sys.class.path");
            if (string2 == null) {
                string2 = System.getProperty("sun.boot.class.path");
            }
            vector2 = this.classPath(string2);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                this.classLists().add((String)enumeration.nextElement());
            }
        }
        return this.classLists();
    }

    public ExpressionInt currentExpression() {
        return this.currentExpression;
    }

    public ExpressionInt currentExpression(ExpressionInt expressionInt) {
        this.currentExpression = expressionInt;
        this.notifyListeners(expressionInt, false);
        return this.currentExpression();
    }

    public Object data() {
        return this.data;
    }

    public Object data(Object object) {
        this.data = object;
        return this.data();
    }

    public Database database() {
        return this.defaultDatabase();
    }

    public Database database(int n) throws Exception {
        return (Database)this.searchPath().elementAt(n);
    }

    public Database database(String string) throws Exception {
        Enumeration enumeration = this.searchPath().ordered().elements();
        while (enumeration.hasMoreElements()) {
            Database database = (Database)enumeration.nextElement();
            if (!database.getName().equals(string)) continue;
            return database;
        }
        return null;
    }

    public Debugger debugger() {
        return this.debugger;
    }

    public Debugger debugger(Debugger debugger) {
        this.debugger = debugger;
        return this.debugger();
    }

    public Database defaultDatabase() {
        return this.defaultDatabase(true);
    }

    public Database defaultDatabase(Database database) {
        Database database2 = this.defaultDatabase(false);
        this.defaultDatabase = database;
        try {
            this.attach(this.defaultDatabase(), 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return database2;
    }

    public Database defaultDatabase(boolean bl) {
        if (this.defaultDatabase != null) {
            return this.defaultDatabase;
        }
        return bl ? (Database)this.searchPath().ordered().elementAt(0) : null;
    }

    public ErrorHandler defaultErrorHandler() {
        ErrorHandler errorHandler = null;
        String string = null;
        string = this.options().getProperty("errorHandlerClass", true);
        try {
            if (string != null) {
                Object[] objectArray = new Object[]{this};
                errorHandler = (ErrorHandler)new ConstructorExpression(string, objectArray, false).eval(new BasicEvaluator(this));
                return errorHandler;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Couldn't create errorHandler of class " + string);
        }
        return new SystemErrorHandler(this);
    }

    public int detach(int n) {
        return this.searchPath().detach(n);
    }

    public int detach(Database database) {
        return this.searchPath().detach(database);
    }

    public boolean displayTask(Object object, Object object2, String string) {
        block7: {
            try {
                List list2;
                if (this.output(false) != null) {
                    this.output().display(object2);
                    break block7;
                }
                if (object2 == null) break block7;
                String string2 = "";
                if (object2 instanceof List) {
                    string2 = String.valueOf(string2) + ((List)object2).size();
                }
                if ((list2 = (List)object2) != null && list2.size() > 0) {
                    this.show(list2.lastElement());
                }
            }
            catch (Exception exception) {
                try {
                    this.error(exception, "Problem printing result of evaluation!\n" + object + "\n");
                }
                catch (Throwable throwable) {
                    this.stderr().println("Error in error handler for printing " + exception);
                }
            }
        }
        return true;
    }

    public boolean displayTask(Task task) {
        if (this.output(false) != null && this.output() instanceof TaskDisplayFilter) {
            return ((TaskDisplayFilter)this.output).display(task);
        }
        return this.displayTask(task.expression(), task.value(), task.taskString());
    }

    public int displayWarnings() {
        return this.displayWarnings(Math.min(this.warnings().size(), 10));
    }

    public int displayWarnings(int n) {
        this.warnings().size();
        n = Math.min(n, this.warnings().size());
        int n2 = 0;
        while (n2 < n) {
            this.stderr().println(this.warnings().elementAt(n2));
            ++n2;
        }
        return this.warnings().size();
    }

    public DynamicClassLoader dynamicClassLoader() {
        return this.dynamicClassLoader;
    }

    public DynamicClassLoader dynamicClassLoader(DynamicClassLoader dynamicClassLoader) {
        this.dynamicClassLoader = dynamicClassLoader;
        return this.dynamicClassLoader();
    }

    public void endSource() throws EndSourceInputException {
        this.endSource("");
    }

    public void endSource(String string) throws EndSourceInputException {
        this.endSource(string, false);
    }

    public void endSource(String string, boolean bl) throws EndSourceInputException {
        throw new EndSourceInputException(string, this.sourceStack().size() - 1, bl, (Evaluator)this);
    }

    public void endTaskEvaluation(ExpressionInt expressionInt) {
    }

    public Exception error(String string) {
        return this.error(null, string);
    }

    public Exception error(Throwable throwable, String string) {
        return new EvaluationException(string, throwable, this.currentExpression(), this);
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public ErrorHandler errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this.errorHandler();
    }

    public Object evaluate(Object object, String string) throws Throwable {
        Object object2 = null;
        Task task = this.addToHistory(object, object2, string);
        if (object != null && object instanceof ExpressionInt) {
            object2 = this.evaluate(task);
            task.value(object2);
        } else {
            System.err.println("Non expression object returned from parser");
        }
        this.displayTask(task);
        return object2;
    }

    public Object evaluate(String string) {
        if (this.Debug()) {
            System.err.println("[Evaluator] Processing " + string);
        }
        if (string == null) {
            return null;
        }
        if (!string.endsWith(";")) {
            string = String.valueOf(string) + ";";
        }
        ExpressionInt expressionInt = null;
        try {
            expressionInt = this.parse(string);
        }
        catch (Exception exception) {
            this.stderr().println("Error in parsing: " + exception);
            exception.printStackTrace();
            return null;
        }
        Object var3_4 = null;
        if (this.Debug()) {
            System.err.println("Evaluating " + expressionInt.getClass().getName());
            System.err.println(((StatementList)expressionInt).elementAt(0).getClass().getName());
        }
        try {
            return this.evaluate(expressionInt, string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized Object evaluate(Task task) {
        Object object = null;
        try {
            object = this.evaluate(task.expression());
            task.value(object);
        }
        catch (Throwable throwable) {
            task.error(throwable);
        }
        return object;
    }

    public Object evaluate(ExpressionInt expressionInt) throws Throwable {
        Object object = null;
        if (expressionInt == null) {
            try {
                this.evaluationError(new Exception("Empty expression passed to evaluate"));
            }
            catch (Throwable throwable) {
                this.stderr().println("Error in error handler  " + throwable);
            }
            return null;
        }
        this.notifyListeners(expressionInt, true);
        if (this.Debug()) {
            System.out.println("Evaluating expression " + expressionInt);
            if (expressionInt instanceof List) {
                System.out.println("# expressions " + ((List)expressionInt).size());
            }
        }
        Throwable throwable = null;
        try {
            try {
                this.toplevelExpression(this.currentExpression(expressionInt));
                this.initTaskEvaluation(expressionInt);
                object = expressionInt.eval(this);
            }
            catch (EvaluationException evaluationException) {
                this.evaluationError(evaluationException);
                throwable = evaluationException;
                throw evaluationException;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                this.evaluationError(this.error(throwable2, ""));
                throw throwable2;
            }
            Object var5_7 = null;
            this.displayWarnings();
        }
        catch (Throwable throwable3) {
            Object var5_8 = null;
            this.displayWarnings();
            this.warnings().removeAllElements();
            this.endTaskEvaluation(expressionInt);
            throw throwable3;
        }
        this.warnings().removeAllElements();
        this.endTaskEvaluation(expressionInt);
        return object;
    }

    public boolean evaluationError(Throwable throwable) {
        if (this.debugger() != null) {
            this.debugger().error(throwable, this.currentExpression);
        } else {
            ErrorHandler errorHandler = this.errorHandler();
            if (errorHandler == null) {
                errorHandler = this.errorHandler(this.defaultErrorHandler());
            }
            errorHandler.error(throwable, "Error in " + this.currentExpression(), this.currentExpression());
        }
        return true;
    }

    public Vector evaluationListeners() {
        return this.evaluationListeners(true);
    }

    public Vector evaluationListeners(Vector vector2) {
        this.evaluationListeners = vector2;
        return this.evaluationListeners();
    }

    public Vector evaluationListeners(boolean bl) {
        if (this.evaluationListeners == null && bl) {
            this.evaluationListeners = new Vector(3);
        }
        return this.evaluationListeners;
    }

    public boolean exists(String string) {
        Database[] databaseArray = this.find(string, false);
        return databaseArray != null && databaseArray.length != 0;
    }

    public void exit() {
        this.exit(1);
    }

    public void exit(int n) {
        System.exit(n);
    }

    public String expandClassName(String string) {
        try {
            Class clazz = this.findClass(string);
            return clazz.getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String expandedClassPathElement(String string, Object object) {
        String string2 = System.getProperty("file.separator");
        if (object instanceof URL) {
            try {
                URL uRL = (URL)object;
                return new URL(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getFile()) + string2 + string).toString();
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (object instanceof File) {
            return new File(String.valueOf(String.valueOf(object)) + string2 + string).toString();
        }
        return null;
    }

    protected Database[] find(String string, boolean bl) {
        return this.searchPath().find(string, bl);
    }

    public Object findAsField(Name name, int n, boolean bl) throws ObjectNotFoundException, Exception {
        Object object = null;
        int n2 = 1;
        Class clazz = null;
        String string = (String)name.elementAt(0);
        while (true) {
            try {
                clazz = this.findClass(string);
                if (clazz != null) {
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (n2 == n) break;
            string = String.valueOf(string) + "." + (String)name.elementAt(n2);
            ++n2;
        }
        if (clazz == null) {
            throw new ObjectNotFoundException(name);
        }
        object = clazz;
        int n3 = n2;
        while (n3 < n) {
            string = (String)name.elementAt(n3);
            object = this.getField(string, object, n3 == n - 1 && bl);
            ++n3;
        }
        return object;
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.asPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("looking for class `" + string + "'" + (string != null ? string.length() : 0));
            System.err.println(String.valueOf(String.valueOf(this.currentExpression())) + " " + this.currentExpression().parent());
            illegalArgumentException.printStackTrace();
            return null;
        }
        clazz = this.searchForClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public Class findClass(String string, int n) throws ClassNotFoundException {
        if (n > -1) {
            return this.findClass(string);
        }
        try {
            return this.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Class findClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        block4: {
            try {
                return this.findClass(var1_1);
            }
            catch (ClassNotFoundException v0) {
                if (!var2_2) break block4;
                var4_3 = 0;
                ** while (var4_3 < BasicEvaluator.internalPrimitiveClassNames.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var1_1.equals(BasicEvaluator.internalPrimitiveClassNames[var4_3])) {
                    return BasicEvaluator.primitive_classes[var4_3];
                }
                ++var4_3;
                continue;
            }
        }
        throw new ClassNotFoundException(var1_1);
    }

    public Class findClass(Name name) throws ClassNotFoundException {
        return this.findClass(this.asObjectName(name));
    }

    public Function findFunction(String string) throws ObjectNotFoundException, ClassNotFoundException {
        return (Function)this.get(string, class$org$omegahat$Environment$Language$Function != null ? class$org$omegahat$Environment$Language$Function : (class$org$omegahat$Environment$Language$Function = BasicEvaluator.class$("org.omegahat.Environment.Language.Function")));
    }

    public Evaluable findFunctionOrMethod(String string) throws ObjectNotFoundException {
        Vector<Class> vector2 = new Vector<Class>(2);
        vector2.addElement(class$org$omegahat$Environment$Language$Function != null ? class$org$omegahat$Environment$Language$Function : (class$org$omegahat$Environment$Language$Function = BasicEvaluator.class$("org.omegahat.Environment.Language.Function")));
        vector2.addElement(class$org$omegahat$Environment$Language$Method != null ? class$org$omegahat$Environment$Language$Method : (class$org$omegahat$Environment$Language$Method = BasicEvaluator.class$("org.omegahat.Environment.Language.Method")));
        return (Evaluable)this.get(new NameTypeSearchFilter(string, vector2));
    }

    Object findPackage(Name name) {
        Vector vector2 = this.classPath();
        Object object = this.findPackage(name, vector2);
        if (object == null) {
            String string = System.getProperty("java.sys.class.path");
            if (string == null) {
                string = System.getProperty("sun.boot.class.path");
            }
            vector2 = this.classPath(string);
            object = this.findPackage(name, vector2);
        }
        return object;
    }

    Object findPackage(Name name, Vector vector2) {
        String string = System.getProperty("file.separator");
        String string2 = name.collapse(string);
        Iterator iterator = ((AbstractList)vector2).iterator();
        while (iterator.hasNext()) {
            Object object;
            String string3 = (String)iterator.next();
            if (string3.endsWith(string2)) {
                object = new File(string3);
                System.err.println("Looking at " + string3);
                if (((File)object).canRead()) {
                    return object;
                }
            }
            if (string3.startsWith("http:")) continue;
            try {
                object = new ZipFile(string3);
                if (((ZipFile)object).getEntry(string2) != null) {
                    return new File(string3);
                }
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
            object = new File(String.valueOf(string3) + string + string2);
            if (!((File)object).canRead()) continue;
            return new File(string3);
        }
        return null;
    }

    public OrderedTable functionTableList() {
        return this.internalFunctionTables;
    }

    public Object get(String string) throws ObjectNotFoundException {
        Object object = null;
        Database database = this.which(string);
        if (database == null) {
            throw new ObjectNotFoundException(string);
        }
        try {
            object = database.get(string);
        }
        catch (Throwable throwable) {}
        return object;
    }

    public Object get(String string, Class clazz) throws ObjectNotFoundException {
        return this.get(string, clazz, false);
    }

    public Object get(String string, Class clazz, boolean bl) throws ObjectNotFoundException {
        Database[] databaseArray = this.where(string);
        if (databaseArray != null && databaseArray.length > 0) {
            Object object = null;
            int n = 0;
            while (n < databaseArray.length) {
                try {
                    object = databaseArray[n].get(string);
                }
                catch (Throwable throwable) {}
                if (object == null || bl && object.getClass().equals(clazz) || !bl && clazz.isAssignableFrom(object.getClass())) {
                    return object;
                }
                ++n;
            }
        }
        throw new ObjectNotFoundException(string, clazz);
    }

    public Object get(String string, String string2) throws ObjectNotFoundException, ClassNotFoundException {
        return this.get(string, this.findClass(string2));
    }

    public Object get(String string, String string2, boolean bl) throws ObjectNotFoundException, ClassNotFoundException {
        return this.get(string, this.findClass(string2), bl);
    }

    public Object get(String string, boolean bl) throws Throwable {
        return this.get(string, bl, LazyFunctionDatabase.DefaultStripFlag);
    }

    public Object get(String string, boolean bl, boolean bl2) throws Throwable {
        if (bl) {
            return this.get(string);
        }
        Database[] databaseArray = this.find(string, false);
        if (databaseArray == null || databaseArray.length < 1) {
            throw new ObjectNotFoundException(string);
        }
        if (databaseArray[0] instanceof LazyFunctionDatabase) {
            return ((LazyFunctionDatabase)databaseArray[0]).get(string, false);
        }
        this.warning("The object " + string + " is not lazy.");
        return databaseArray[0].get(string);
    }

    public Object get(NameTypeSearchFilter nameTypeSearchFilter) throws ObjectNotFoundException {
        Database[] databaseArray = this.where(nameTypeSearchFilter.name());
        if (databaseArray != null && databaseArray.length > 0) {
            int n = 0;
            while (n < databaseArray.length) {
                Object object = databaseArray[n].get(nameTypeSearchFilter.name());
                if (nameTypeSearchFilter.accept(nameTypeSearchFilter.name(), object)) {
                    return object;
                }
                ++n;
            }
        }
        throw new ObjectNotFoundException(nameTypeSearchFilter.name(), null);
    }

    public Object get(Name name) throws ObjectNotFoundException {
        return this.get(name.element(0));
    }

    public Object getBaseURL(String string) {
        File file = new File(string);
        if (file.canRead()) {
            return file.getParentFile();
        }
        try {
            URL uRL = new URL(string);
            String string2 = new File(uRL.getFile()).getParent();
            return new URL(uRL.getProtocol(), uRL.getHost(), string2);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public EvaluationEvent getEvaluationEvent() {
        return this.evaluationEvent;
    }

    public Vector getEvaluationListeners() {
        return this.evaluationListeners;
    }

    public Object getField(String string, Object object, boolean bl) throws Exception {
        Class clazz = null;
        clazz = !(object instanceof Class) ? object.getClass() : (Class)object;
        if (string.equals("length") && clazz.isArray()) {
            Integer n = new Integer(Array.getLength(object));
            return n;
        }
        Field field = clazz.getField(string);
        Object object2 = bl ? field : field.get(object);
        return object2;
    }

    public Vector getSubEvaluationListeners() {
        return this.SubEvaluationListeners;
    }

    public Object help() throws Exception {
        throw new Exception("At present, the only help facility available uses JHelp. Please see the INSTALL file in the distribution for instructions on how to obtain this and configure omegahat to use it.");
    }

    public void init() {
        this.attach(this.newDatabase("Scratch"));
    }

    public void initTaskEvaluation(ExpressionInt expressionInt) {
    }

    public boolean initialize(Evaluator evaluator) {
        if (evaluator != null) {
            this.options(evaluator.options());
            if (evaluator instanceof BasicEvaluator) {
                BasicEvaluator basicEvaluator = (BasicEvaluator)evaluator;
                this.searchPath(basicEvaluator.searchPath(), true);
                this.classLists(basicEvaluator.classLists());
                this.dynamicClassLoader(basicEvaluator.dynamicClassLoader());
                this.localClasses(basicEvaluator.localClasses());
            }
        }
        this.init();
        return evaluator != null;
    }

    protected OrderedTable internalFunctionTables(OrderedTable orderedTable) {
        this.internalFunctionTables = orderedTable;
        return this.functionTableList();
    }

    public static boolean isPrimitive(Class clazz) {
        boolean bl = primitiveClasses.containsKey(clazz.getName());
        if (!bl) {
            bl = primitiveClasses.contains(clazz);
        }
        return bl;
    }

    public static boolean isPrimitive(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = BasicEvaluator.isPrimitive(object.getClass());
        return bl;
    }

    public int javaVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.1")) {
            return 1;
        }
        return 2;
    }

    public Tokenizer lexer() {
        return this.lexer;
    }

    public Tokenizer lexer(Tokenizer tokenizer) {
        this.lexer = tokenizer;
        return this.lexer();
    }

    public Tokenizer lexer(Reader reader) {
        if (reader != null) {
            String string = this.options().getProperty("defaultLexerClass", true);
            if (string != null) {
                try {
                    ConstructorExpression constructorExpression = new ConstructorExpression(string, new List(reader));
                    Class clazz = this.findClass(string);
                    this.lexer((Tokenizer)constructorExpression.eval(clazz, (Evaluator)this));
                }
                catch (Throwable throwable) {
                    System.err.println("Couldn't find and/or create class " + string);
                    this.lexer(new omegaNestedStringLexer(reader));
                }
            } else {
                this.lexer(new omegaNestedStringLexer(reader));
            }
        }
        return this.lexer;
    }

    public LocalClassLocator localClasses() {
        if (this.localClasses == null) {
            this.localClasses(new LocalClassLocator());
        }
        return this.localClasses;
    }

    public LocalClassLocator localClasses(LocalClassLocator localClassLocator) {
        this.localClasses = localClassLocator;
        return this.localClasses();
    }

    public EvaluatorManager manager() {
        return this.manager;
    }

    public EvaluatorManager manager(EvaluatorManager evaluatorManager) {
        this.manager = evaluatorManager;
        return this.manager();
    }

    public Database newDatabase() {
        String string = "<Temp DB " + this.searchPath().size() + ">";
        return this.newDatabase(string);
    }

    public Database newDatabase(String string) {
        if (this.options().getProperty("defaultDatabaseClass", true) != null) {
            String string2 = this.options().getProperty("defaultDatabaseClass", true);
            try {
                Object[] objectArray = new Object[]{string};
                return (Database)new ConstructorExpression(string2, objectArray, false).eval(this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return new TypedDatabase(string);
    }

    public int notifyListeners(ExpressionInt expressionInt) {
        return this.notifyListeners(expressionInt, false);
    }

    public int notifyListeners(ExpressionInt expressionInt, boolean bl) {
        Enumeration enumeration;
        Vector vector2;
        EvaluationEvent evaluationEvent = this.getEvaluationEvent();
        int n = 0;
        if (bl && (vector2 = this.getEvaluationListeners()) != null) {
            evaluationEvent.setExpr(expressionInt);
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((EvaluationListener)enumeration.nextElement()).nextEvaluation(evaluationEvent);
                    ++n;
                }
                catch (Throwable throwable) {}
            }
        }
        if (!bl && (vector2 = this.getSubEvaluationListeners()) != null) {
            evaluationEvent.setExpr(expressionInt);
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((SubEvaluationListener)enumeration.nextElement()).nextEvaluation(evaluationEvent);
                    ++n;
                }
                catch (Throwable throwable) {}
            }
        }
        return n;
    }

    public String[] objects() {
        return this.objects(this.defaultDatabase());
    }

    public String[] objects(int n) throws Exception {
        return this.objects(this.database(n));
    }

    public String[] objects(Database database) {
        String[] stringArray = null;
        if (database == null || (stringArray = database.objects()) == null) {
            return null;
        }
        return stringArray;
    }

    public Options options() {
        return this.options;
    }

    public Options options(Options options) {
        if (((Hashtable)options).equals(this.options)) {
            return this.options;
        }
        this.options = options;
        return this.options;
    }

    public ObjectDisplayFilter output() {
        return this.output(true);
    }

    public ObjectDisplayFilter output(ObjectDisplayFilter objectDisplayFilter) {
        this.output = objectDisplayFilter;
        return this.output();
    }

    public ObjectDisplayFilter output(boolean bl) {
        if (this.output == null && bl) {
            int n = 5;
            int n2 = 3;
            String string = this.options().getProperty("taskDisplayAbove");
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if ((string = this.options().getProperty("taskDisplayBelow")) != null) {
                n2 = Integer.parseInt(string);
            }
            this.output(new BasicTaskDisplay(this.stdout(), n, n2));
        }
        return this.output;
    }

    public ExpressionInt parse(Tokenizer tokenizer) throws Exception {
        omegaJavaGrammar omegaJavaGrammar2 = this.parser(tokenizer);
        return this.parse(omegaJavaGrammar2);
    }

    public ExpressionInt parse(Reader reader) throws Exception {
        return this.parse(this.lexer(reader));
    }

    public ExpressionInt parse(String string) throws Exception {
        StringReader stringReader = new StringReader(string);
        return this.parse(stringReader);
    }

    public ExpressionInt parse(omegaJavaGrammar omegaJavaGrammar2) throws Exception {
        omegaJavaGrammar2.evaluationUnit();
        return (ExpressionInt)omegaJavaGrammar2.getAST();
    }

    public omegaJavaGrammar parser(Tokenizer tokenizer) {
        omegaJavaGrammar omegaJavaGrammar2 = new omegaJavaGrammar(tokenizer);
        omegaJavaGrammar2.honorCharacters(tokenizer instanceof omegaNestedStringLexer ^ true);
        return omegaJavaGrammar2;
    }

    public static Class primitiveClass(Object object) {
        Class<Object> clazz = null;
        if (object instanceof Integer) {
            clazz = Integer.TYPE;
        } else if (object instanceof Long) {
            clazz = Long.TYPE;
        } else if (object instanceof Boolean) {
            clazz = Boolean.TYPE;
        } else if (object instanceof Double) {
            clazz = Double.TYPE;
        } else if (object instanceof Character) {
            clazz = Character.TYPE;
        } else if (object instanceof Short) {
            clazz = Short.TYPE;
        } else if (object instanceof Byte) {
            clazz = Byte.TYPE;
        } else if (object instanceof Float) {
            clazz = Float.TYPE;
        } else if (object instanceof Void) {
            clazz = Void.TYPE;
        }
        return clazz;
    }

    public boolean q() {
        return this.q(false);
    }

    public boolean q(boolean bl) {
        if (this.manager() != null) {
            return this.manager().q(this, bl);
        }
        System.exit(0);
        return true;
    }

    public boolean remove(String string) {
        Database[] databaseArray = this.find(string, false);
        if (databaseArray != null && databaseArray.length > 0) {
            return this.remove(string, databaseArray[0]);
        }
        return false;
    }

    public boolean remove(String string, int n) {
        Database database = (Database)this.databases.elementAt(n);
        return this.remove(string, database);
    }

    public boolean remove(String string, Database database) {
        database.remove(string);
        return true;
    }

    public boolean removeFunctionTable(Object object) {
        if (this.internalFunctionTables == null) {
            return false;
        }
        boolean bl = this.internalFunctionTables.contains(object);
        if (bl) {
            this.internalFunctionTables.removeElement(object);
        }
        return bl;
    }

    public void run() {
        while (true) {
            // Infinite loop
        }
    }

    public boolean same(Object object, Object object2) {
        return object == object2;
    }

    public Class searchForClass(String string) throws ClassNotFoundException {
        Vector vector2;
        Class clazz;
        block13: {
            block12: {
                char c = System.getProperty("file.separator").charAt(0);
                string = string.replace('.', c);
                clazz = null;
                vector2 = null;
                try {
                    if (ShowMultipleClasses) {
                        vector2 = new Vector(1);
                        vector2 = this.classLists().findClasses(string, vector2);
                        break block12;
                    }
                    clazz = this.classLists().findClass(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (this.localClasses() != null) {
                try {
                    if (ShowMultipleClasses) {
                        this.classLists().findClasses(string, vector2);
                        break block13;
                    }
                    clazz = this.localClasses().findClass(string);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if (this.dynamicClassLoader() != null) {
            clazz = this.dynamicClassLoader().loadClass(string);
        }
        if (ShowMultipleClasses) {
            if (vector2.size() < 1) {
                throw new ClassNotFoundException(string);
            }
            if (vector2.size() > 1) {
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("Found " + vector2.size() + " classes named " + string + "\n");
                int n = 0;
                while (n < vector2.size()) {
                    stringBuffer.append("\t" + n + ") " + vector2.elementAt(n) + "\n");
                    ++n;
                }
                this.warning(stringBuffer.toString());
            }
            clazz = (Class)vector2.elementAt(0);
        }
        return clazz;
    }

    public SearchPath searchPath() {
        if (this.Debug()) {
            Enumeration enumeration = this.databases.elements();
            while (enumeration.hasMoreElements()) {
                System.err.print(String.valueOf(((ObjectDatabase)enumeration.nextElement()).getName()) + " ");
            }
            System.err.println();
        }
        return this.databases;
    }

    public SearchPath searchPath(Vector vector2) {
        return this.searchPath(new SearchPath(vector2));
    }

    public SearchPath searchPath(SearchPath searchPath) {
        return this.searchPath(searchPath, false);
    }

    public SearchPath searchPath(SearchPath searchPath, boolean bl) {
        this.databases = bl ? (SearchPath)searchPath.copy() : searchPath;
        return this.searchPath();
    }

    public EvaluationEvent setEvaluationEvent(EvaluationEvent evaluationEvent) {
        this.evaluationEvent = evaluationEvent;
        return this.evaluationEvent;
    }

    public Vector setEvaluationListeners(Vector vector2) {
        this.evaluationListeners = vector2;
        return this.evaluationListeners;
    }

    public Vector setSubEvaluationListeners(Vector vector2) {
        this.SubEvaluationListeners = vector2;
        return this.SubEvaluationListeners;
    }

    public Object show() {
        return this.show(null, true);
    }

    public Object show(Object object) {
        return this.show(object, true);
    }

    public Object show(Object object, boolean bl) {
        this.output().display(object);
        this.stdout().flush();
        return object;
    }

    public Object source(File file) throws Throwable {
        Object object = null;
        try {
            object = this.source(new FileReader(file), file);
        }
        catch (Exception exception) {
            this.warning("Error sourceing " + file);
            throw exception;
        }
        return object;
    }

    public Object source(Reader reader) throws Throwable {
        return this.source(reader, "Unknown Source");
    }

    public Object source(Reader reader, Object object) throws Throwable {
        Object object2;
        block8: {
            object2 = null;
            this.addSourceInput(object);
            if (this.Debug()) {
                System.err.println("Source'ing from " + object + " (depth = " + this.sourceStack().size() + ")");
            }
            try {
                try {
                    ExpressionInt expressionInt = this.parse(reader);
                    object2 = this.evaluate(expressionInt);
                }
                catch (EndSourceInputException endSourceInputException) {
                    endSourceInputException.source(object);
                    object2 = endSourceInputException;
                }
                catch (Throwable throwable) {
                    System.err.println("Error when source'ing " + this.sourceStack().lastElement() + " " + this.currentExpression());
                    throw throwable;
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
            }
            while (!this.sourceStack().pop().equals(object)) {
            }
            break block8;
            while (!this.sourceStack().pop().equals(object)) {
            }
            throw throwable;
        }
        return object2;
    }

    public Object source(Object object) throws Throwable {
        Object object2 = null;
        if (object instanceof File) {
            object2 = this.source((File)object);
        } else if (object instanceof Reader) {
            object2 = this.source((Reader)object);
        } else if (object instanceof URL) {
            object2 = this.source((URL)object);
        } else if (object instanceof String) {
            object2 = this.source((String)object);
        } else if (object instanceof ArchiveEntry) {
            object2 = this.source((ArchiveEntry)object);
        } else if (object instanceof InputStream) {
            object2 = this.source(new InputStreamReader((InputStream)object));
        } else {
            System.err.println("Looking for source method for " + object.getClass() + " " + object + ". Please report to omega-devel@omegahat.org");
            Class[] classArray = new Class[]{object.getClass()};
            Method method = this.getClass().getMethod("source", classArray);
            Class[] classArray2 = new Class[]{class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = BasicEvaluator.class$("java.lang.Object"))};
            Method method2 = this.getClass().getMethod("source", classArray2);
            if (method != null && !method.equals(method2)) {
                Object[] objectArray = new Object[]{object};
                try {
                    object2 = method.invoke((Object)this, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            } else {
                throw new Exception("No method for `source' with signature " + classArray[0]);
            }
        }
        return object2;
    }

    public Object source(String string) throws Throwable {
        try {
            return this.source(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Object object = this.manager().findFile(string);
            Object object2 = null;
            if (object == null) {
                System.err.println("Searchpath " + ((FileLocator)this.manager().fileLocator()).searchPath());
                throw new FileNotFoundException(string);
            }
            object2 = this.source(object);
            return object2;
        }
    }

    public Object source(String string, boolean bl) throws Throwable {
        if (bl) {
            return this.evaluate(string);
        }
        return this.source(string);
    }

    public Object source(URL uRL) throws Throwable {
        InputStream inputStream = uRL.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return this.source(inputStreamReader, uRL);
    }

    public Object source(ArchiveEntry archiveEntry) throws Throwable {
        InputStream inputStream = archiveEntry.inputStream();
        return this.source(new InputStreamReader(inputStream), archiveEntry);
    }

    public Object source(InputFileInt inputFileInt) throws Throwable {
        return this.source(inputFileInt.getInputStream());
    }

    public Stack sourceStack() {
        return this.sourceStack;
    }

    public PrintWriter stderr() {
        if (this.stderr == null) {
            this.stderr(System.err);
        }
        return this.stderr;
    }

    public PrintWriter stderr(OutputStream outputStream) {
        this.stderr = this.asWriter(outputStream);
        return this.stderr();
    }

    public PrintWriter stdout() {
        if (this.stdout == null) {
            this.stdout(System.out);
        }
        return this.stdout;
    }

    public PrintWriter stdout(OutputStream outputStream) {
        this.stdout = this.asWriter(outputStream);
        return this.stdout();
    }

    public Vector taskHistory() {
        return this.taskHistory;
    }

    public Vector taskHistory(Vector vector2) {
        this.taskHistory = vector2;
        return this.taskHistory();
    }

    public ExpressionInt toplevelExpression() {
        return this.toplevelExpression;
    }

    public ExpressionInt toplevelExpression(ExpressionInt expressionInt) {
        this.toplevelExpression = expressionInt;
        return this.toplevelExpression();
    }

    public boolean useLazyEvaluation() {
        return false;
    }

    public void warning(String string) {
        this.warning(string, false);
    }

    public void warning(String string, boolean bl) {
        if (true) {
            this.stderr().println("Warning:: " + string + "\n");
        } else {
            this.warnings().addElement(string);
        }
    }

    public void warning(Throwable throwable, String string) {
        this.warning(string);
    }

    public Vector warnings() {
        if (this.warningMessages == null) {
            this.warnings(new Vector(1));
        }
        return this.warningMessages;
    }

    public Vector warnings(Vector vector2) {
        this.warningMessages = vector2;
        return this.warnings();
    }

    public Database[] where(String string) {
        return this.find(string, true);
    }

    public Database which(String string) {
        Database[] databaseArray = null;
        databaseArray = this.find(string, false);
        return databaseArray == null ? null : databaseArray[0];
    }

    public Database which(Name name) {
        return this.which(this.asObjectName(name));
    }
}

