/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.TaskManagement;

import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.TaskManagement.DistributedTaskConstants;
import org.omegahat.Environment.TaskManagement.DistributedTaskEvent;
import org.omegahat.Environment.TaskManagement.DistributedTaskListener;
import org.omegahat.Environment.TaskManagement.Task;
import org.omegahat.Environment.TaskManagement.TaskQueue;

public class TaskManager
implements Runnable,
DistributedTaskConstants {
    public boolean debug = false;
    protected TaskQueue tasks;
    protected Vector listeners;

    public TaskManager() {
        this(5);
    }

    public TaskManager(int n) {
        this.tasks(this.createQueue(n));
    }

    public TaskManager(int n, boolean bl) {
        this(n);
        this.debug = bl;
    }

    public TaskManager(TaskQueue taskQueue) {
        if (taskQueue != null) {
            this.tasks(taskQueue);
        } else {
            this.tasks(this.createQueue(5));
        }
    }

    public TaskManager(TaskQueue taskQueue, boolean bl) {
        this(taskQueue);
        this.debug = bl;
    }

    public int addListener(DistributedTaskListener distributedTaskListener) {
        if (this.listeners() == null) {
            this.listeners(new Vector(5));
        }
        this.listeners().addElement(distributedTaskListener);
        return this.listeners().size();
    }

    public int addTask(Task task) {
        return this.tasks().addTask(task);
    }

    public TaskQueue createQueue(int n) {
        return new TaskQueue(n);
    }

    public Object dispatchTask(Task task) {
        try {
            return task.eval();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Task getTask() {
        return this.getTask(true);
    }

    public Task getTask(boolean bl) {
        Task task = null;
        task = this.tasks.getTask();
        return task;
    }

    public boolean isComplete() {
        return false;
    }

    public Vector listeners() {
        return this.listeners;
    }

    public Vector listeners(Vector vector2) {
        this.listeners = vector2;
        return this.listeners();
    }

    public boolean notify(DistributedTaskEvent distributedTaskEvent) {
        return this.notify(distributedTaskEvent, distributedTaskEvent.getID());
    }

    public boolean notify(DistributedTaskEvent distributedTaskEvent, int n) {
        if (this.listeners() == null || this.listeners().size() == 0) {
            return false;
        }
        Enumeration enumeration = this.listeners().elements();
        while (enumeration.hasMoreElements()) {
            DistributedTaskListener distributedTaskListener = (DistributedTaskListener)enumeration.nextElement();
            switch (n) {
                case 0: {
                    distributedTaskListener.taskDispatched(distributedTaskEvent);
                    break;
                }
                case 1: {
                    distributedTaskListener.taskCompleted(distributedTaskEvent);
                    break;
                }
                case 2: {
                    distributedTaskListener.taskError(distributedTaskEvent);
                    break;
                }
                case 4: {
                    distributedTaskListener.serverDiscarded(distributedTaskEvent);
                    break;
                }
                case 5: {
                    distributedTaskListener.serverPoolCleared(distributedTaskEvent);
                    break;
                }
                case 3: {
                    distributedTaskListener.serverRejected(distributedTaskEvent);
                    break;
                }
            }
        }
        return true;
    }

    public boolean notify(Task task, Object object, int n) {
        if (this.listeners() == null || this.listeners().size() == 0) {
            return false;
        }
        DistributedTaskEvent distributedTaskEvent = new DistributedTaskEvent(this, n, task, object);
        return this.notify(distributedTaskEvent);
    }

    public boolean removeListener(DistributedTaskListener distributedTaskListener) {
        if (this.listeners() == null || this.listeners().size() == 0) {
            return false;
        }
        if (this.listeners().contains(distributedTaskListener)) {
            return false;
        }
        this.listeners().removeElement(distributedTaskListener);
        return true;
    }

    public void run() {
        Task task = null;
        while (!this.isComplete()) {
            try {
                task = this.getTask();
                if (task == null) break;
                this.dispatchTask(task);
            }
            catch (Exception exception) {
                this.warn(task, exception);
            }
        }
    }

    public TaskQueue tasks() {
        return this.tasks;
    }

    public TaskQueue tasks(TaskQueue taskQueue) {
        this.tasks = taskQueue;
        return this.tasks();
    }

    public boolean warn(Task task, Exception exception) {
        System.err.println("Error in task : " + task);
        exception.printStackTrace();
        return true;
    }
}

