/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omegahat.Environment.IO.InputFileInt;
import org.omegahat.Environment.Utils.StringUtils;

public class TrimmedProperties
extends Properties {
    public String[][] booleanStrings = new String[][]{{"true", "t"}, {"false", "f"}};
    protected boolean stripQuotes = true;

    public TrimmedProperties() {
    }

    public TrimmedProperties(File file) {
        this.load(file);
    }

    public TrimmedProperties(File file, boolean bl) {
        this.stripQuotes(bl);
        this.load(file);
    }

    public TrimmedProperties(InputStream inputStream) {
        this.load(inputStream);
        this.stripQuotes(true);
        this.trim();
    }

    public TrimmedProperties(String string) {
        this.parse(string);
    }

    public TrimmedProperties(String string, boolean bl) {
        this.stripQuotes(bl);
        this.parse(string);
    }

    public TrimmedProperties(Properties properties) {
        this(properties, true);
    }

    public TrimmedProperties(Properties properties, boolean bl) {
        super(properties);
        this.stripQuotes(bl);
        this.trim();
    }

    public TrimmedProperties(InputFileInt inputFileInt) {
        this(inputFileInt, true);
    }

    public TrimmedProperties(InputFileInt inputFileInt, boolean bl) {
        this.stripQuotes(bl);
        try {
            this.load(inputFileInt.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public TrimmedProperties(boolean bl) {
        this.stripQuotes(bl);
    }

    public boolean asBoolean(String string) throws Exception {
        String string2 = string.toLowerCase();
        int n = 0;
        while (n < this.booleanStrings.length) {
            int n2 = 0;
            while (n2 < this.booleanStrings[n].length) {
                if (string2.equals(this.booleanStrings[n][n2])) {
                    return n == 0;
                }
                ++n2;
            }
            ++n;
        }
        throw new Exception();
    }

    public boolean isBoolean(String string) {
        try {
            this.asBoolean(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized void load(File file) {
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (dataInputStream != null) {
            this.load(dataInputStream);
        }
    }

    public synchronized void load(InputStream inputStream) {
        try {
            super.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.trim();
    }

    public int merge(Properties properties) {
        return this.merge(properties, false);
    }

    public int merge(Properties properties, boolean bl) {
        int n = 0;
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (((Hashtable)this).containsKey(string) && !bl) continue;
            ((Hashtable)this).put(string, ((Hashtable)properties).get(string));
        }
        return n;
    }

    public boolean parse(String string) {
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        this.load(stringBufferInputStream);
        return true;
    }

    public boolean processElement(String string, String string2) {
        return false;
    }

    public int processElements() {
        int n = 0;
        Enumeration enumeration = ((Hashtable)this).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.processElement(string, this.getProperty(string))) continue;
            ++n;
        }
        return n;
    }

    public String[] stringList(String string) {
        return StringUtils.stringList(string);
    }

    public String[] stringList(String string, char c) {
        return StringUtils.stringList(string, c);
    }

    public boolean stripQuotes() {
        return this.stripQuotes;
    }

    public boolean stripQuotes(boolean bl) {
        this.stripQuotes = bl;
        return this.stripQuotes();
    }

    public void trim() {
        String[] stringArray = new String[]{"\"", "'"};
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            String string3 = !string.endsWith(".separator") ? string2.trim() : string2;
            if (this.stripQuotes()) {
                int n = 0;
                while (n < stringArray.length) {
                    if (string3.startsWith(stringArray[n]) && string3.endsWith(stringArray[n])) {
                        string3 = string3.substring(1, string3.length() - 1);
                        break;
                    }
                    ++n;
                }
            }
            ((Hashtable)this).put(string, string3);
        }
    }
}

