/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharQueue;
import java.io.IOException;

public abstract class InputBuffer {
    int nMarkers;
    int markerOffset;
    int numToConsume;
    CharQueue queue = new CharQueue(1);

    public void consume() {
        ++this.numToConsume;
    }

    public abstract void fill(int var1) throws IOException;

    public String getLAChars() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.markerOffset;
        while (n < this.queue.nbrEntries) {
            stringBuffer.append(this.queue.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getMarkedChars() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.markerOffset) {
            stringBuffer.append(this.queue.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isMarked() {
        return this.nMarkers != 0;
    }

    public char LA(int n) throws IOException {
        this.fill(n);
        return this.queue.elementAt(this.markerOffset + n - 1);
    }

    public int mark() {
        this.syncConsume();
        ++this.nMarkers;
        return this.markerOffset;
    }

    public void rewind(int n) {
        this.syncConsume();
        this.markerOffset = n;
        --this.nMarkers;
    }

    protected void syncConsume() {
        while (this.numToConsume > 0) {
            if (this.nMarkers > 0) {
                ++this.markerOffset;
            } else {
                this.queue.removeFirst();
            }
            --this.numToConsume;
        }
    }
}

