/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.CodeAttr;
import jas.DoubleCP;
import jas.ExceptAttr;
import jas.GenericAttr;
import jas.LongCP;
import jas.Method;
import jas.RuntimeConstants;
import jas.SourceAttr;
import jas.Var;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassEnv
implements RuntimeConstants {
    int magic = -889275714;
    short version_lo = (short)3;
    short version_hi = (short)45;
    CP this_class;
    CP super_class;
    short class_access;
    Hashtable cpe = new Hashtable();
    Hashtable cpe_index = null;
    Vector interfaces = new Vector();
    Vector vars = new Vector();
    Vector methods = new Vector();
    SourceAttr source;
    Vector generic = new Vector();

    public void setClass(CP name) {
        this.this_class = name;
        this.addCPItem(name);
    }

    public void setSuperClass(CP name) {
        this.super_class = name;
        this.addCPItem(name);
    }

    public void setClassAccess(short access) {
        this.class_access = access;
    }

    public void addInterface(CP ifc) {
        this.addCPItem(ifc);
        this.interfaces.addElement(ifc);
    }

    public void addInterface(CP[] ilist) {
        int i = 0;
        while (i < ilist.length) {
            this.interfaces.addElement(ilist[i]);
            this.addCPItem(ilist[i]);
            ++i;
        }
    }

    public void addField(Var v) {
        this.vars.addElement(v);
        v.resolve(this);
    }

    public void write(DataOutputStream out) throws IOException, jasError {
        out.writeInt(this.magic);
        out.writeShort(this.version_lo);
        out.writeShort(this.version_hi);
        int curidx = 1;
        this.cpe_index = new Hashtable();
        Enumeration e = this.cpe.elements();
        while (e.hasMoreElements()) {
            CP tmp = (CP)e.nextElement();
            this.cpe_index.put(tmp.getUniq(), new Integer(curidx));
            ++curidx;
            if (!(tmp instanceof LongCP) && !(tmp instanceof DoubleCP)) continue;
            ++curidx;
        }
        out.writeShort((short)curidx);
        Enumeration e2 = this.cpe.elements();
        while (e2.hasMoreElements()) {
            CP now = (CP)e2.nextElement();
            now.write(this, out);
        }
        out.writeShort(this.class_access);
        out.writeShort(this.getCPIndex(this.this_class));
        out.writeShort(this.getCPIndex(this.super_class));
        out.writeShort(this.interfaces.size());
        Enumeration e3 = this.interfaces.elements();
        while (e3.hasMoreElements()) {
            CP c = (CP)e3.nextElement();
            out.writeShort(this.getCPIndex(c));
        }
        out.writeShort(this.vars.size());
        Enumeration e4 = this.vars.elements();
        while (e4.hasMoreElements()) {
            Var v = (Var)e4.nextElement();
            v.write(this, out);
        }
        out.writeShort(this.methods.size());
        Enumeration e5 = this.methods.elements();
        while (e5.hasMoreElements()) {
            Method m = (Method)e5.nextElement();
            m.write(this, out);
        }
        int numExtra = 0;
        if (this.source != null) {
            numExtra = 1;
        }
        numExtra = (short)(numExtra + this.generic.size());
        out.writeShort(numExtra);
        if (this.source != null) {
            this.source.write(this, out);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.write(this, out);
        }
        out.flush();
    }

    public void addCPItem(CP cp) {
        String uniq = cp.getUniq();
        CP intern = (CP)this.cpe.get(uniq);
        if (intern == null) {
            this.cpe.put(uniq, cp);
            cp.resolve(this);
        }
    }

    public void addMethod(short acc, String name, String sig, CodeAttr code, ExceptAttr ex) {
        Method x = new Method(acc, new AsciiCP(name), new AsciiCP(sig), code, ex);
        x.resolve(this);
        this.methods.addElement(x);
    }

    public void setSource(SourceAttr source) {
        this.source = source;
        source.resolve(this);
    }

    public void setSource(String source) {
        this.source = new SourceAttr(source);
        this.source.resolve(this);
    }

    public void addGenericAttr(GenericAttr g) {
        this.generic.addElement(g);
        g.resolve(this);
    }

    public void addMethod(Method m) {
        m.resolve(this);
        this.methods.addElement(m);
    }

    short getCPIndex(CP cp) throws jasError {
        if (this.cpe_index == null) {
            throw new jasError("Internal error: CPE index has not been generated");
        }
        Integer idx = (Integer)this.cpe_index.get(cp.getUniq());
        if (idx == null) {
            throw new jasError("Item " + cp + " not in the class");
        }
        return (short)idx.intValue();
    }
}

