% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_imp_method.R
\name{get_imp_meth}
\alias{get_imp_meth}
\title{Find default imputation methods and order}
\usage{
get_imp_meth(fixed, random = NULL, data, auxvars = NULL)
}
\arguments{
\item{fixed}{a two sided formula describing the fixed-effects part of the
model (see \code{\link[stats]{formula}})}

\item{random}{only for \code{lme_imp}:
a one-sided formula of the form \code{~x1 + ... + xn | g},
where \code{x1 + ... + xn} specifies the model for the random
effects and \code{g} the grouping variable}

\item{data}{a \code{data.frame}}

\item{auxvars}{optional vector of variable names that should be used as
predictors in the imputation procedure (and will be imputed
if necessary) but are not part of the analysis model}
}
\value{
A named vector containing those variables in \code{data}
        that have missing values and their assigned default imputation methods,
        sorted by proportion of missing values.
}
\description{
Find default imputation methods and order
}
\examples{
get_imp_meth(y ~ C1 + C2 + B2 + O2 + M2, data = wideDF)


}
