% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_device.R
\name{jk_device_settings}
\alias{jk_device_settings}
\title{Set JuniperKernel's Graphic Device Settings}
\usage{
jk_device_settings(background_color = "white", width = 10L, height = 5L,
  pointsize = 12L, system_fonts = NULL, user_fonts = NULL,
  device_off = FALSE)
}
\arguments{
\item{background_color}{A character string of the color for the image background.
Examples: "red", "blue", "green".}

\item{width}{Width in inches.}

\item{height}{Height in inches.}

\item{pointsize}{Default point size.}

\item{system_fonts}{Named list of font names to be aliased with fonts installed on your system. If
unspecified, the R default families sans, serif, mono and symbol are aliased to
the family returned by match_family().}

\item{user_fonts}{Named list of fonts to be aliased with font files provided by the user rather
than fonts properly installed on the system. The aliases can be fonts from the
fontquiver package, strings containing a path to a font file, or a list containing
name and file elements with name indicating the font alias in the SVG output
and file the path to a font file.}

\item{device_off}{Use this to toggle the JuniperKernel graphics device on and off. If you would like to
to save plots to a pdf file, e.g., you would first turn off the JuniperKernel device
here and then create a new pdf graphics device.}
}
\value{
Invisibly return a list of the settings.
}
\description{
Set JuniperKernel's Graphic Device Settings
}
\details{
Use this method to set the graphics settings used by JuniperKernel.
}
\author{
Spencer Aiello
}
