% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WarpSin.r
\docType{class}
\name{Warp}
\alias{Warp}
\title{The 'Warp' class object}
\format{\code{\link{R6Class}} object.}
\usage{
Warp
}
\value{
an  \code{\link{R6Class}} object which can be used for doing interpolation using reproducing kernel Hilbert space.
}
\description{
This class provide the warping method which can be used to warp the original signal to sinusoidal like signal.
}
\section{Fields}{

\describe{
\item{\code{y}}{matrix(of size n_s*n_o) containing observation.}

\item{\code{t}}{vector(of length n_o) containing time points for observation.}

\item{\code{b}}{vector(of length n_o) containing coefficients of kernel or basis functions.}

\item{\code{lambda}}{scalar containing the weighting parameter for penalising the length of warped time span.}

\item{\code{ker}}{kernel class object containing sigmoid basis function.}
}}

\section{Methods}{

\describe{
  \item{\code{warpsin(len ,lop,p0,eps)}}{This method is used to warp the initial interpolation into a sinusoidal shape.}   
  \item{\code{slowWarp(lens,peod,eps)}}{This method is used to find the optimised initial hyper parameters for the sigmoid basis function for each ode states.}
  \item{\code{ warpLossLen(par,lam,p0,eps)}}{This method is used to implement the loss function for warping. It is called by the 'warpSin' function.} }
}

\author{
Mu Niu, \email{mu.niu@plymouth.ac.uk}
}
\keyword{data}
