% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FKMO.R
\name{FKMO}
\alias{FKMO}
\title{Optimal KM for continuous Traits in Familial GWAS Data (calculate p-value)}
\usage{
FKMO(
  obj,
  genotypes,
  gid,
  weights = NULL,
  acc = 1e-04,
  acc2 = 1e-04,
  r.all = c(0, 0.25, 0.5, 0.75, 1),
  append.write = NULL
)
}
\arguments{
\item{obj}{results saved from FKMO_Null_Model.R.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match id. Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{gid}{A vector of id mapping to samples in genotype file (class: vector). So the order of samples in gid must be the same as the order in genotypes. Make sure it is not a factor. Although gid doesn't have to be in the same order as id, it is suggested to make them sorted in the same order in order to make all files easily to be tracked. No missing.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers}

\item{acc}{Accuracy of numerical integration used in Davies' method for individual r.all p-values. Default 1e-4.}

\item{acc2}{Accuracy of numerical integration used in Davies' method for the final p-value. Default 1e-4.}

\item{r.all}{A list of predefined proportion of linear kernel and burden test. When r.all=0, regular kernel machine test (FKM); when r.all=1, burden test.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}
}
\value{
output: continuous trait optimal family KM (F-KMO) p-value
}
\description{
This function (FKMO) is used to perform optimal famSKAT analysis for continuous traits in familial GWAS data
}
\examples{
#############################################################################
### Examples for Continuous Traits in Familial GWAS Data using optimal KM ###
#############################################################################
### Subject IDs are numeric ###
data("FKM_numID")
obj1 <- FKMO_Null_Model(phenotype=fkm_n_y$y, id=fkm_n_y$id, fa=fkm_n_y$fa,
mo=fkm_n_y$mo, covariates=NULL)
pvalue1 <- FKMO(obj=obj1, genotypes=fkm_n_gene, gid=fkm_n_geneid$gid, weights=NULL)
# Read in a list of genes files instead of a big file containing all genes
obj <- FKMO_Null_Model(phenotype=fkm_n_y$y, id=fkm_n_y$id, fa=fkm_n_y$fa,
mo=fkm_n_y$mo, covariates=NULL)
gene <- split(fkm_n_gene, fkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- FKMO(obj=obj, genotypes=gene[[k]], gid=fkm_n_geneid$gid, weights=NULL)
}
### Subject IDs are character ###
data("FKM_charID")
obj1 <- FKMO_Null_Model(phenotype=fkm_c_y$y, id=as.character(fkm_c_y$id), 
fa=as.character(fkm_c_y$fa), mo=as.character(fkm_c_y$mo),  covariates=NULL)
pvalue1 <- FKMO(obj=obj1, genotypes=fkm_c_gene, gid=as.character(fkm_c_geneid$gid), 
weights=NULL)
}
