% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HHGKM_K_sample.R
\name{konp_test}
\alias{konp_test}
\title{KONP tests are \eqn{K}-sample Omnibus Non-Proportional hazards tests for right-censored data.}
\usage{
konp_test(time, status, group, n_perm, n_impu = 1)
}
\arguments{
\item{time}{A vector of the observed follow-up times.}

\item{status}{A vector of event indicators, 0=right censored, 1= event at \code{time}.}

\item{group}{A vector denoting the group labels, must contain at least two different values.}

\item{n_perm}{The number of permutations.}

\item{n_impu}{The number of imputations, for each imputation n_perm permutations will be executed.}
}
\value{
Three test statistics and their respective p-values are returned: \cr 

\code{pv_chisq} - returns the p-value based on the KONP test chi-square statistic. \cr 
\code{pv_lr} - returns the p-value based on the KONP test likelihood ratio statistic. \cr 
\code{pv_cauchy} - returns the p-value based on the KONP-based Cauchy-combination test statistic. \cr 
\code{chisq_test_stat} - returns the KONP test chi-squared test statistic. \cr 
\code{lr_test_stat} - returns the KONP test likelihood-ratio test statistic. \cr
\code{cauchy_test_stat} - returns the KONP-based Cauchy-combination test statistic.
}
\description{
KONP tests are \eqn{K}-sample Omnibus Non-Proportional hazards tests for right-censored data.
}
\details{
The KONP tests are powerful non-parametric tests for comparing \eqn{K} (>=2) hazard functions based on right-censored data.
These tests are consistent against any differences between the hazard functions of the groups.
The KONP tests are often more powerful than other existing tests, especially under non-proportional hazard functions.
}
\examples{
## Generate some data to preform the test
set.seed(1)
n <- 50
time <- rexp(n)
status <- sample(c(0,1),n,TRUE)
group <- c(rep(1,25),rep(2,25))

konp_test(time,status,group,n_perm=10^3)

}
