/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;
import org.apache.lucene.analysis.kr.morph.MorphAnalyzer;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.morph.WSOuputComparator;
import org.apache.lucene.analysis.kr.morph.WSOutput;
import org.apache.lucene.analysis.kr.morph.WordEntry;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;
import org.apache.lucene.analysis.kr.utils.SyllableUtil;
import org.apache.lucene.analysis.kr.utils.VerbUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSpaceAnalyzer {
    private MorphAnalyzer morphAnal = new MorphAnalyzer();

    public WordSpaceAnalyzer() {
        this.morphAnal.setExactCompound(false);
    }

    public List analyze(String input) throws MorphException {
        ArrayList stack = new ArrayList();
        WSOutput output = new WSOutput();
        int wStart = 0;
        int sgCount = -9;
        HashMap<Integer, Integer> fCounter = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < input.length()) {
            char[] f = SyllableUtil.getFeature(input.charAt(i));
            String prefix = i == input.length() - 1 ? "X" : input.substring(wStart, i + 2);
            Iterator iter = DictionaryUtil.findWithPrefix(prefix);
            ArrayList<AnalysisOutput> candidates = new ArrayList<AnalysisOutput>();
            WordEntry entry = null;
            if (input.charAt(i) == '\uc788' || input.charAt(i) == '\uc5c6' || input.charAt(i) == '\uc55e') {
                this.addSingleWord(input.substring(wStart, i), candidates);
            } else if (i != input.length() - 1 && iter.hasNext()) {
                sgCount = i;
            } else if (!iter.hasNext() && (entry = DictionaryUtil.getBusa(input.substring(wStart, i + 1))) != null) {
                candidates.add(this.buildSingleOutput(entry));
            } else if (f[SyllableUtil.IDX_EOGAN] == '1' || f[SyllableUtil.IDX_JOSA1] == '1') {
                if (f[SyllableUtil.IDX_JOSA1] == '1') {
                    candidates.addAll(this.anlysisWithJosa(input.substring(wStart), i - wStart));
                }
                if (f[SyllableUtil.IDX_EOGAN] == '1') {
                    candidates.addAll(this.anlysisWithEomi(input.substring(wStart), i - wStart));
                }
            }
            Collections.sort(candidates, new WSOuputComparator());
            this.appendSingleWord(candidates);
            this.analysisCompouns(candidates);
            Collections.sort(candidates, new WSOuputComparator());
            int reseult = this.validationAndAppend(output, candidates, input);
            if (reseult == 1) {
                i = output.getLastEnd() - 1;
                wStart = output.getLastEnd();
            } else if (reseult == -1) {
                Integer index = (Integer)fCounter.get(output.getLastEnd());
                index = index == null ? Integer.valueOf(output.getLastEnd()) : Integer.valueOf(index + 1);
                i = index;
                wStart = output.getLastEnd();
                fCounter.put(output.getLastEnd(), index);
            }
            ++i;
        }
        if (output.getLastEnd() < input.length()) {
            String source = input.substring(output.getLastEnd());
            int score = DictionaryUtil.getWord(source) == null ? 30 : 100;
            AnalysisOutput o = new AnalysisOutput(source, null, null, 'N', 1, score);
            o.setSource(source);
            output.getPhrases().add(o);
            this.morphAnal.confirmCNoun(o);
        }
        return output.getPhrases();
    }

    private List anlysisWithJosa(String snipt, int js) throws MorphException {
        ArrayList<AnalysisOutput> candidates = new ArrayList<AnalysisOutput>();
        if (js < 1) {
            return candidates;
        }
        int jend = this.findJosaEnd(snipt, js);
        if (jend == -1) {
            return candidates;
        }
        String input = snipt.substring(0, jend);
        boolean josaFlag = true;
        int i = input.length() - 1;
        while (i > 0) {
            String stem = input.substring(0, i);
            String josa = input.substring(i);
            char[] feature = SyllableUtil.getFeature(josa.charAt(0));
            if (josaFlag && feature[SyllableUtil.IDX_JOSA1] == '1') {
                this.morphAnal.analysisWithJosa(stem, josa, candidates);
            }
            if (josaFlag && feature[SyllableUtil.IDX_JOSA2] == '0') {
                josaFlag = false;
            }
            if (!josaFlag) break;
            --i;
        }
        if (input.length() == 1) {
            AnalysisOutput o = new AnalysisOutput(input, null, null, 'N', 1, 30);
            candidates.add(o);
        }
        this.fillSourceString(input, candidates);
        return candidates;
    }

    private int findJosaEnd(String snipt, int jstart) throws MorphException {
        char[] chrs;
        int jend = jstart;
        if (snipt.charAt(jstart - 1) == '\uac83' && snipt.charAt(jstart) == '\uc744') {
            return jstart + 1;
        }
        if (snipt.length() > jstart + 2 && snipt.charAt(jstart + 1) == '\uc2a4' && (chrs = MorphUtil.decompose(snipt.charAt(jstart + 2))).length >= 2 && chrs[0] == '\u3139' && chrs[1] == '\u3153') {
            return -1;
        }
        int i = jstart + 1;
        while (i < snipt.length()) {
            char[] f = SyllableUtil.getFeature(snipt.charAt(i));
            if (f[SyllableUtil.IDX_JOSA2] == '0') break;
            jend = i++;
        }
        int start = jend;
        boolean hasJosa = false;
        int i2 = start;
        while (i2 >= jstart) {
            String str = snipt.substring(jstart, i2 + 1);
            if (DictionaryUtil.existJosa(str) && !this.findNounWithinStr(snipt, i2, i2 + 2) && !this.isNounPart(snipt, jstart)) {
                jend = i2;
                hasJosa = true;
                break;
            }
            --i2;
        }
        if (!hasJosa) {
            return -1;
        }
        return jend + 1;
    }

    private void fillSourceString(String source, List<AnalysisOutput> candidates) {
        for (AnalysisOutput o : candidates) {
            o.setSource(source);
        }
    }

    private void appendSingleWord(List<AnalysisOutput> candidates) throws MorphException {
        if (candidates.size() == 0) {
            return;
        }
        String source = candidates.get(0).getSource();
        WordEntry entry = DictionaryUtil.getWordExceptVerb(source);
        if (entry != null) {
            candidates.add(this.buildSingleOutput(entry));
        } else {
            if (candidates.get(0).getPatn() > 11 && candidates.get(0).getPatn() <= 15) {
                return;
            }
            if (source.length() < 5) {
                return;
            }
            AnalysisOutput o = new AnalysisOutput(source, null, null, 'N', 1, 30);
            o.setSource(source);
            this.morphAnal.confirmCNoun(o);
            if (o.getScore() == 100) {
                candidates.add(o);
            }
        }
    }

    private void addSingleWord(String source, List<AnalysisOutput> candidates) throws MorphException {
        WordEntry entry = DictionaryUtil.getWordExceptVerb(source);
        if (entry != null) {
            candidates.add(this.buildSingleOutput(entry));
        } else {
            AnalysisOutput o = new AnalysisOutput(source, null, null, 'N', 1, 30);
            o.setSource(source);
            this.morphAnal.confirmCNoun(o);
            candidates.add(o);
        }
    }

    private void appendAddedWord(String source, List<AnalysisOutput> candidates) throws MorphException {
    }

    private List anlysisWithEomi(String snipt, int estart) throws MorphException {
        String pvword;
        int eend;
        ArrayList<AnalysisOutput> candidates;
        block10: {
            String input;
            candidates = new ArrayList<AnalysisOutput>();
            eend = this.findEomiEnd(snipt, estart);
            int vstart = 0;
            int i = estart - 1;
            while (i >= 0) {
                Iterator iter = DictionaryUtil.findWithPrefix(snipt.substring(i, estart));
                if (!iter.hasNext()) break;
                vstart = i--;
            }
            if (snipt.length() > eend && DictionaryUtil.findWithPrefix(snipt.substring(vstart, eend + 1)).hasNext()) {
                return candidates;
            }
            pvword = null;
            if (vstart != 0) {
                pvword = snipt.substring(0, vstart);
            }
            while (true) {
                input = snipt.substring(vstart, eend);
                this.anlysisWithEomiDetail(input, candidates);
                if (candidates.size() == 0) break block10;
                if (!"\u3139".equals(((AnalysisOutput)candidates.get(0)).getEomi()) && !"\u3141".equals(((AnalysisOutput)candidates.get(0)).getEomi()) && !"\u3134".equals(((AnalysisOutput)candidates.get(0)).getEomi()) || eend <= estart + 1 || ((AnalysisOutput)candidates.get(0)).getPatn() == 11 || ((AnalysisOutput)candidates.get(0)).getPatn() == 3) break;
                --eend;
            }
            if (pvword != null && ((AnalysisOutput)candidates.get(0)).getPatn() >= 11 && ((AnalysisOutput)candidates.get(0)).getPatn() <= 15 && DictionaryUtil.getWord(input) != null) {
                candidates.clear();
            } else if (pvword != null && VerbUtil.verbSuffix(((AnalysisOutput)candidates.get(0)).getStem()) && DictionaryUtil.getNoun(pvword) != null) {
                candidates.clear();
                this.anlysisWithEomiDetail(snipt.substring(0, eend), candidates);
                pvword = null;
            }
        }
        if (candidates.size() > 0 && pvword != null) {
            AnalysisOutput o = new AnalysisOutput(pvword, null, null, 'N', 1, 30);
            this.morphAnal.confirmCNoun(o);
            List<CompoundEntry> cnouns = o.getCNounList();
            if (cnouns.size() == 0) {
                boolean is = DictionaryUtil.getWordExceptVerb(pvword) != null;
                cnouns.add(new CompoundEntry(pvword, 0, is));
            }
            for (AnalysisOutput candidate : candidates) {
                candidate.getCNounList().addAll(cnouns);
                candidate.getCNounList().add(new CompoundEntry(candidate.getStem(), 0, true));
                candidate.setStem(String.valueOf(pvword) + candidate.getStem());
            }
        }
        this.fillSourceString(snipt.substring(0, eend), candidates);
        return candidates;
    }

    private void anlysisWithEomiDetail(String input, List<AnalysisOutput> candidates) throws MorphException {
        boolean eomiFlag = true;
        int strlen = input.length();
        this.morphAnal.analysisWithEomi(input, "", candidates);
        int i = strlen - 1;
        while (i > 0) {
            String stem = input.substring(0, i);
            String eomi = input.substring(i);
            char[] feature = SyllableUtil.getFeature(eomi.charAt(0));
            if (eomiFlag) {
                this.morphAnal.analysisWithEomi(stem, eomi, candidates);
            }
            if (eomiFlag && feature[SyllableUtil.IDX_EOMI2] == '0') {
                eomiFlag = false;
            }
            if (!eomiFlag) break;
            --i;
        }
    }

    private int findEomiEnd(String snipt, int estart) throws MorphException {
        int jend = 0;
        String tail = null;
        char[] chr = MorphUtil.decompose(snipt.charAt(estart));
        tail = chr.length == 3 && chr[2] == '\u3134' ? String.valueOf('\uc740') + snipt.substring(estart + 1) : (chr.length == 3 && chr[2] == '\u3139' ? String.valueOf('\uc744') + snipt.substring(estart + 1) : (chr.length == 3 && chr[2] == '\u3142' ? String.valueOf('\uc2b5') + snipt.substring(estart + 1) : snipt.substring(estart)));
        int start = 0;
        int i = 1;
        while (i < tail.length()) {
            char[] f = SyllableUtil.getFeature(tail.charAt(i));
            if (f[SyllableUtil.IDX_EOGAN] == '0') break;
            start = i++;
        }
        i = start;
        while (i > 0) {
            String str = tail.substring(0, i + 1);
            char[] chrs = MorphUtil.decompose(tail.charAt(i));
            if (DictionaryUtil.existEomi(str) || i < 2 && chrs.length == 3 && (chrs[2] == '\u3139' || chrs[2] == '\u3141' || chrs[2] == '\u3134')) {
                jend = i;
                break;
            }
            --i;
        }
        return estart + jend + 1;
    }

    private int validationAndAppend(WSOutput output, List<AnalysisOutput> candidates, String input) throws MorphException {
        int nEnd;
        char[] f;
        if (candidates.size() == 0) {
            return 0;
        }
        AnalysisOutput o = candidates.remove(0);
        AnalysisOutput po = output.getPhrases().size() > 0 ? output.getPhrases().get(output.getPhrases().size() - 1) : null;
        String ejend = o.getSource().substring(o.getStem().length());
        char[] chrs = po != null ? MorphUtil.decompose(po.getStem().charAt(po.getStem().length() - 1)) : null;
        String pjend = po != null ? po.getSource().substring(po.getStem().length()) : null;
        int ja = 120;
        if (po != null && po.getPatn() >= 11 && po.getPatn() <= 15) {
            char[] chs = MorphUtil.decompose(po.getEomi().charAt(po.getEomi().length() - 1));
            if (chs.length == 3) {
                ja = chs[2];
            } else if (chs.length == 1) {
                ja = chs[0];
            }
        }
        char[] cArray = f = (nEnd = output.getLastEnd() + o.getSource().length()) < input.length() ? SyllableUtil.getFeature(input.charAt(nEnd)) : null;
        if (po != null && po.getPatn() == 1 && candidates.size() > 0 && o.getPatn() == 11 && candidates.get(0).getPatn() == 1) {
            o = candidates.remove(0);
        } else if (po != null && po.getPatn() >= 11 && candidates.size() > 0 && candidates.get(0).getPatn() == 1 && (ja == 12596 || ja == 12601)) {
            o = candidates.remove(0);
        }
        if (o.getPos() == 'N' && MorphUtil.hasVerbOnly(o.getStem())) {
            output.removeLast();
            return -1;
        }
        if (nEnd < input.length() && f[SyllableUtil.IDX_JOSA1] == '1' && DictionaryUtil.getNoun(o.getSource()) != null) {
            return -1;
        }
        if (nEnd < input.length() && o.getScore() == 30 && DictionaryUtil.findWithPrefix(String.valueOf(ejend) + input.charAt(nEnd)).hasNext()) {
            return -1;
        }
        if (po != null && po.getPatn() == 11 && "\u3141".equals(po.getEomi()) && o.getStem().equals("\ud558")) {
            output.removeLast();
            return -1;
        }
        if (po != null && po.getPatn() == 1 && VerbUtil.verbSuffix(o.getStem()) && !"\uc788".equals(o.getStem())) {
            output.removeLast();
            return -1;
        }
        output.addPhrase(o);
        return 1;
    }

    private AnalysisOutput buildSingleOutput(WordEntry entry) {
        char pos = 'N';
        int ptn = 1;
        if (entry.getFeature(0) == '0') {
            pos = 'Z';
            ptn = 21;
        }
        AnalysisOutput o = new AnalysisOutput(entry.getWord(), null, null, pos, ptn, 100);
        o.setSource(entry.getWord());
        return o;
    }

    private void analysisCompouns(List<AnalysisOutput> candidates) throws MorphException {
        boolean changed = false;
        boolean correct = false;
        for (AnalysisOutput o : candidates) {
            if (o.getScore() == 100) {
                if (o.getPatn() != 2) {
                    correct = true;
                }
                if (!"\ud558".equals(o.getVsfx())) continue;
                break;
            }
            if (o.getPatn() > 11 || o.getStem().length() <= 2) continue;
            if (!correct || o.getPatn() != 1) {
                this.morphAnal.confirmCNoun(o);
            }
            if (o.getScore() != 100) continue;
            changed = true;
        }
    }

    private boolean findNounWithinStr(String str, int ws, int es) throws MorphException {
        if (str.length() < es) {
            return false;
        }
        int i = es;
        while (i < str.length()) {
            char[] f = SyllableUtil.getFeature(str.charAt(i));
            if (i == str.length() || f[SyllableUtil.IDX_JOSA1] == '1') {
                return DictionaryUtil.getWord(str.substring(ws, i)) != null;
            }
            ++i;
        }
        return false;
    }

    private boolean isNounPart(String str, int jstart) throws MorphException {
        return false;
    }

    private void printCandidate(WSOutput output) {
        List<AnalysisOutput> os = output.getPhrases();
        for (AnalysisOutput o : os) {
            System.out.print(String.valueOf(o.toString()) + "(" + o.getScore() + ")| ");
        }
        System.out.println("<==");
    }
}

