/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordEntry {
    public static final int IDX_NOUN = 0;
    public static final int IDX_VERB = 1;
    public static final int IDX_BUSA = 2;
    public static final int IDX_DOV = 3;
    public static final int IDX_BEV = 4;
    public static final int IDX_NE = 5;
    public static final int IDX_ADJ = 6;
    public static final int IDX_NPR = 7;
    public static final int IDX_CNOUNX = 8;
    public static final int IDX_REGURA = 9;
    private String word;
    private char[] features;
    private List<CompoundEntry> compounds = new ArrayList<CompoundEntry>();

    public WordEntry() {
    }

    public WordEntry(String word) {
        this.word = word;
    }

    public WordEntry(String word, char[] cs) {
        this.word = word;
        this.features = cs;
    }

    public WordEntry(String word, List c) {
        this.word = word;
        this.compounds = c;
    }

    public void setWord(String w) {
        this.word = w;
    }

    public String getWord() {
        return this.word;
    }

    public void setFeatures(char[] cs) {
        this.features = cs;
    }

    public char getFeature(int index) {
        if (this.features == null || this.features.length < index) {
            return '0';
        }
        return this.features[index];
    }

    public char[] getFeatures() {
        return this.features;
    }

    public void setCompounds(List<CompoundEntry> c) {
        this.compounds = c;
    }

    public List<CompoundEntry> getCompounds() {
        return this.compounds;
    }
}

