% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcfa.R
\name{pcfa}
\alias{pcfa}
\title{Partially Confirmatory Factor Analysis}
\usage{
pcfa(
  dat,
  Q,
  LD = TRUE,
  PPMC = FALSE,
  burn = 5000,
  iter = 5000,
  update = 1000,
  missing = NA,
  rseed = 12345,
  digits = 4,
  alas = FALSE
)
}
\arguments{
\item{dat}{A \eqn{N \times J} \code{matrix} or \code{data.frame} consisting of the
responses of \eqn{N} individuals to \eqn{J} items. Only continuous data are supported currently.}

\item{Q}{A \eqn{J \times K} design matrix for the loading pattern with \eqn{K} factors and \eqn{J} items.
Elements are 1, -1, and 0 for specified, unspecified, and zero-fixed loadings, respectively. For models with
LI or the E-step, one can specify a few (e.g., 2) loadings per factor. For models with LD or the C-step, the
sufficient condition of one specified loading per item is suggested, although there can be a few items
without any specified loading (Chen, Guo, Zhang, & Pan, 2020). See \code{Examples}.}

\item{LD}{logical; \code{TRUE} for allowing LD (model with LD or C-step).}

\item{PPMC}{logical; \code{TRUE} for conducting posterior predictive model checking.}

\item{burn}{Number of burn-in iterations before posterior sampling.}

\item{iter}{Number of formal iterations for posterior sampling.}

\item{update}{Number of iterations to update the sampling information.}

\item{missing}{Value for missing data (default is \code{NA}) (under development).}

\item{rseed}{An integer for the random seed.}

\item{digits}{Number of significant digits to print when printing numeric values.}

\item{alas}{logical; for adaptive Lasso or not. The default is \code{FALSE}, which seems slightly stabler.}
}
\value{
\code{pcfa} returns an object of class \code{pcfa}. It contains a lot of information about
the posteriors that can be summarized using \code{\link{summary.lawbl}}. The factorial eigenvalue
 can be plotted with \code{\link{plot_eigen}}.
}
\description{
\code{PCFA} is a partially confirmatory approach covering a wide range of
the exploratory-confirmatory continuum in factor analytic models (Chen, Guo, Zhang, & Pan, 2020).
 There are two major model variants with different constraints for identification. One assumes local
 independence (LI) with a more exploratory tendency, which can be also called the E-step.
 The other allows local dependence (LD) with a more confirmatory tendency, which can be also
 called the C-step. Parameters are obtained by sampling from the posterior distributions with
 the Markov chain Monte Carlo (MCMC) techniques. Different Bayesian Lasso methods are used to
 regularize the loading pattern and LD. The estimation results can be summarized with \code{\link{summary.lawbl}}
 and the factorial eigenvalue can be plotted with \code{\link{plot_eigen}}.
}
\examples{
\donttest{
####################################
#  Example 1: Estimation with LI   #
####################################

dat <- sim18cfa1$dat
J <- ncol(dat)
K <- 3
Q<-matrix(-1,J,K);
Q[1:2,1]<-Q[9:10,2]<-Q[13:14,3]<-1
Q
m0 <- pcfa(dat = dat, Q = Q, LD = FALSE,burn = 1000, iter = 1000)
summary(m0) # summarize basic information
summary(m0, what = 'lambda') #summarize significant loadings
summary(m0, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m0, what = 'offpsx') #summarize significant LD terms

####################################
#  Example 2: Estimation with LD   #
####################################

Q<-matrix(-1,J,K);
Q[1:6,1]<-Q[7:12,2]<-Q[13:18,3]<-1
Q
m1 <- pcfa(dat = dat, Q = Q,burn = 1000, iter = 1000)
summary(m1) # summarize basic information
summary(m1, what = 'qlambda') #summarize significant loadings in pattern/Q-matrix format
summary(m1, what = 'offpsx') #summarize significant LD terms
}
}
\references{
Chen, J., Guo, Z., Zhang, L., & Pan, J. (2020). A partially confirmatory approach to scale development
 with the Bayesian Lasso. \emph{Psychological Methods}.
 Advance online publication. DOI:10.1037/met0000293
}
