% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LC_fit.R
\name{LC_fit}
\alias{LC_fit}
\title{Linear combination fitting function}
\usage{
LC_fit(sample, standards, LC.vals, float = NULL, E.zero = NULL,
  ex.smaller = NULL)
}
\arguments{
\item{sample}{The sample spectrum}

\item{standards}{The standards spectra}

\item{LC.vals}{Values for ranges of linear combination fitting, with respect to the edge-step}

\item{float}{Set float parameters, defaults to NULL}

\item{E.zero}{Set E0, defaults to NULL}

\item{ex.smaller}{Set value to exclude small portions (as portion of 1), defaults to NULL}
}
\description{
This function allows you to base-line correct and edge-step normalize XANES spectra (background correction)
}
\examples{
data(stdmix)
corr.spec.standards  <- initial_load(specdat[1:4], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec.samples    <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
fit.standards <- std_df(sample = corr.spec.samples[[1]], 
  all.standards = corr.spec.standards)
fit.result <- LC_fit(sample = corr.spec.samples[[1]], 
  standards = fit.standards, LC.vals = c(-14, 46))
print(fit.result)
}
\keyword{correction}
\keyword{normalization,}

