% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_plots.R
\name{plot.LDA_set}
\alias{plot.LDA_set}
\title{Plot a set of LDATS LDA models}
\usage{
\method{plot}{LDA_set}(x, ...)
}
\arguments{
\item{x}{An \code{LDA_set} object of LDA topic models.}

\item{...}{Additional arguments to be passed to subfunctions.}
}
\value{
\code{NULL}.
}
\description{
Generalization of the \code{\link[graphics]{plot}} function to 
  work on a list of LDA topic models (class \code{LDA_set}).
}
\examples{
\donttest{
  data(rodents)
  lda_data <- rodents$document_term_table
  r_LDA <- LDA_set(lda_data, topics = 2, nseeds = 2) 
  plot(r_LDA)
}

}
