% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDproxy.R
\name{LDproxy}
\alias{LDproxy}
\title{Query LDproxy API}
\usage{
LDproxy(snp, pop = "CEU", r2d = "r2", token = NULL, file = FALSE)
}
\arguments{
\item{snp}{an rsID or chromosome coordinate (e.g. "chr7:24966446"), one per query}

\item{pop}{a 1000 Genomes Project population, (e.g. YRI or CEU), multiple allowed, default = "CEU"}

\item{r2d}{either "r2" for LD R2 or "d" for LD D', default = "r2"}

\item{token}{LDlink provided user token, default = NULL, register for token at  \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}
}
\value{
a data frame
}
\description{
Query LDproxy API
}
\examples{
\dontrun{LDproxy("rs456", "YRI", "r2", token = Sys.getenv("LDLINK_TOKEN"))}

}
