% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{predict.LEGIT}
\alias{predict.LEGIT}
\title{Predictions of LEGIT fits}
\usage{
\method{predict}{LEGIT}(object, data, genes, env, ...)
}
\arguments{
\item{object}{An object of class "LEGIT", usually, a result of a call to LEGIT.}

\item{data}{data.frame of the dataset to be used. Do not include elements that are in the datasets \code{genes} and \code{env} and do not include manually coded interactions.}

\item{genes}{data.frame of the variables inside the genetic score \emph{G} (can be any sort of variable, doesn't even have to be genetic).}

\item{env}{data.frame of the variables inside the environmental score \emph{E} (can be any sort of variable, doesn't even have to be environmental).}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns a vector with the predicted values.
}
\description{
Predictions of LEGIT fits.
}
\examples{
train = example_2way(250, 1, seed=777)
test = example_2way(100, 1, seed=777)
fit = LEGIT(train$data, train$G, train$E, y ~ G*E)
ssres = sum((test$data$y - predict(fit, test$data, test$G, test$E))^2)
sstotal = sum((test$data$y - mean(test$data$y))^2)
R2 = 1 - ssres/sstotal
}
