% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OASA.R
\name{OASA}
\alias{OASA}
\title{Orthogonal-Array-Based Simulated Annealing}
\usage{
OASA(OA, n, m, s, r, N, T0, rate, Tmin, Imax, p = 50, q = 1)
}
\arguments{
\item{OA}{A Matrix.}

\item{n}{A positive integer.}

\item{m}{A positive integer.}

\item{s}{A positive integer.}

\item{r}{A positive integer.}

\item{N}{A positive integer.}

\item{T0}{A positive number.}

\item{rate}{A positive percentage.}

\item{Tmin}{A positive number.}

\item{Imax}{A positive integer.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{m} LHD.
}
\description{
\code{OASA} returns a maximin distance LHD constructed by orthogonal-array-based simulated annealing algorithm (OASA)
}
\details{
\itemize{
\item \code{OA} stands for the input orthogonal array matrix.
\item \code{n} stands for the number of rows of OA.
\item \code{m} stands for the number of columns of OA.
\item \code{s} stands for the number of levels of OA.
\item \code{r} stands for the strength of OA.
\item \code{N} stands for the number of iterations.
\item \code{T0} stands for the user-defined initial temperature.
\item \code{rate} stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time.
\item \code{Tmin} stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met.
\item \code{Imax} stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5.
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\examples{
#create an OA(9,2,3,2)
OA=matrix(c(rep(1:3,each=3),rep(1:3,times=3)),ncol=2,nrow=9,byrow = FALSE);OA

#Use above "OA" as the input OA, with with # of iterations =10, initial
#temperature is set to be 10, decrease rate is 10\%, minimium temperature is 1,
#maximum perturbations the algorithm will try without improvements is 5, and p=50
tryOASA=OASA(OA=OA,9,2,3,2,N=10,T0=10,rate=0.1,Tmin=1,Imax=5,p=50,q=1)
tryOASA
}
\references{
Leary, S., Bhaskar, A., and Keane, A. (2003) Optimal orthogonal-array-based latin hypercubes. \emph{Journal of Applied Statistics}, \strong{30}, 585-598.
}
