\name{Setup}
\alias{Setup}
\alias{Setup.limfile}
\alias{Setup.liminput}
\alias{Setup.character}
\title{Creates linear inverse matrices}
\description{Creates the linear problem with equality and inequality equations.
Takes as input either a liminput list, as generated by Read or a filename
with the linear inverse model specifications. Creates:
\item inverse matrices and vectors \bf{A}, \bf{b}, \bf{G}, \bf{h} of the equalities/inequalities:
 \deqn{Ax=b}
 \deqn{Gx>=h}
\item if present, also generates the cost/profit function which is used as:
\deqn{\min(cost)}  or
\deqn{\max(profit)}
\item if the input was a flow network, \code{Setup} will also create the flow matrix (see details)}
\usage{
Setup(...)
Setup.limfile(file, verbose=TRUE, ...)
Setup.character(...)
Setup.liminput(liminput,...)
}
\arguments{
  \item{file }{name of inverse input file}
  \item{verbose }{if TRUE: prints warnings and messages to the screen}
  \item{liminput }{list of elements, as returned by \code{Read}}
  \item{... }{extra parameters allowing this to be a generic function}
}
\value{
  a list containing:
  \item{file }{name of input text file}
  \item{NUnknowns }{number of unknowns}
  \item{NEquations }{number of equations}
  \item{NConstraints }{number of constraints}
  \item{NComponents }{number of components}
  \item{NExternal }{number of externals}
  \item{NVariables }{number of variables}
  \item{A }{matrix A of equalities Ax=B}
  \item{B }{vector B of equalities Ax=B}
  \item{G }{matrix G of inequalities Gx>h}
  \item{H }{vector H of inequalities Gx=h}
  \item{Cost }{cost vector (to minimise), the weight of each unknown; if not specified; 1 for all unknowns}
  \item{Profit }{profit vector (to maximise)}
  \item{Flowmatrix }{matrix where element ij denotes flow from compartment i to j}
  \item{VarA }{matrix VarA of variable equation VarA*x=VarB}
  \item{VarB }{vector VarB of variable equation VarA*x=VarB}
  \item{Flows }{a vector with flow names}
  \item{Parameters }{a data.frame with parameter names and values}
  \item{Components }{a data.frame with state names and values}
  \item{Externals }{a data.frame with external names and values}
  \item{rates }{a data.frame with rate names and values}
  \item{markers }{a data.frame with marker names and values}
  \item{Variables }{a vector with variable names}
  \item{Unknowns }{a vector with names of unknowns (either states or flows)}
  \item{Weight }{a vector with the weights of unknowns- default is 1}
}
\author{Karline Soetaert <k.soetaert@nioo.knaw.nl>}
\examples{
   LIMinputBlending
   Setup(LIMinputBlending )


           }
\seealso{\item \code{\link{Read}} function that reads inverse input files and
  produces the input list used by Setup
  \item \code{\link{Lsei}}, \code{\link{Ldei}}, \code{\link{Linp}} functions to solve inverse problem, based on output generated by \code{setup.limfile}}
\keyword{IO}
\keyword{utilities}

