% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR.R
\name{call_llm}
\alias{call_llm}
\title{Call LLM API}
\usage{
call_llm(config, messages, verbose = FALSE, json = FALSE)
}
\arguments{
\item{config}{An `llm_config` object created by `llm_config()`.}

\item{messages}{A list of message objects (or a character vector for embeddings) to send to the API.}

\item{verbose}{Logical. If `TRUE`, prints the full API response.}

\item{json}{Logical. If `TRUE`, returns the raw JSON response as an attribute.}
}
\value{
The generated text response or embedding results with additional attributes.
}
\description{
Sends a message to the specified LLM API and retrieves the response.
}
\examples{
\dontrun{
  # OpenAI Embedding Example (overwriting api_url):
  openai_embed_config <- llm_config(
    provider = "openai",
    model = "text-embedding-3-small",
    api_key = Sys.getenv("OPENAI_KEY"),
    temperature = 0.3,
    api_url = "https://api.openai.com/v1/embeddings"
  )

  text_input <- c("Political science is a useful subject",
                  "We love sociology",
                  "German elections are different",
                  "A student was always curious.")

  embed_response <- call_llm(openai_embed_config, text_input)

  # Voyage AI Example:
  voyage_config <- llm_config(
    provider = "voyage",
    model = "voyage-large-2",
    api_key = Sys.getenv("VOYAGE_API_KEY")
  )

  embedding_response <- call_llm(voyage_config, text_input)
  embeddings <- parse_embeddings(embedding_response)
  embeddings |> cor() |> print()
}
}
