% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSys.mrgsn.R
\name{AQSysBancroft}
\alias{AQSysBancroft}
\title{Bancroft's Potential Equation - Tieline's correlation}
\usage{
AQSysBancroft(TLdt, ...)
}
\arguments{
\item{TLdt}{- Tieline Experimental data that will be used in the nonlinear fit}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
Parameters K1, r and Statistical data
}
\description{
Bancroft's equation to correlate tieline's data.
}
\examples{
# TLdt is a data.frame which contains series of Tieline's mass fraction
# (upper-rich component, bottom-rich component and water)
# Each column in the data.frame represents a series of one component mass fraction
# For example, an empty data.frame for four tielines can be obtaining using:
TLdt<-matrix(NA,nrow=4,ncol=6)
# Variables order must follows the sequence presented below:
# "mfXt","mfYt","mfXb","mfYb","mfWt","mfWb"
# In which: mf stands for mass fraction; X and Y for the component
# rich in bottom and upper phase, respectively; t or b for top and
# bottom phases and W for water.
# Then you just need to load the data.frame in the function:
\dontrun{
AQSysBancroft(TLdt)
}
}
\references{
Othmer, D.F. and P.E. Tobias, Liquid-Liquid Extraction Data -Toluene and
Acetaldehyde Systems. Industrial & Engineering Chemistry, 1942. 34(6): p. 690-692.
}

