% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSys.R
\name{AQSys.plot}
\alias{AQSys.plot}
\title{Dataset and Fitted Function plot}
\usage{
\method{AQSys}{plot}(XYdt, xlbl = "", ylbl = "", main = NULL,
  col = "blue", type = "p", cex = 1, cexlab = 1, cexaxis = 1,
  cexmain = 1, cexsub = 1, xmax = "", ymax = "", HR = FALSE,
  NP = 100, mathDesc = "merchuk", clwd = NULL, filename = NULL,
  wdir = NULL, save = FALSE, silent = FALSE, ...)
}
\arguments{
\item{XYdt}{Binodal Experimental data that will be used in the nonlinear fit}

\item{xlbl}{Plot's Horizontal axis label.}

\item{ylbl}{Plot's Vertical axis label.}

\item{main}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{col}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{type}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cex}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexlab}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexaxis}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexmain}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexsub}{Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{xmax}{Maximum value for the Horizontal axis' value}

\item{ymax}{Maximum value for the Vertical axis' value}

\item{HR}{Magnify Plot's text to be compatible with High Resolution size [type:Boulean]}

\item{NP}{Number of points used to build the fitted curve. Default is 100. [type:Integer]}

\item{mathDesc}{- Character String specifying the nonlinear empirical equation to fit data. The default method uses
Merchuk's equation. Other possibilities can be seen in AQSysList().}

\item{clwd}{Plot's axis line width}

\item{filename}{A filename chosen by the user to save a given plot}

\item{wdir}{A directory in which the plot file will be saved}

\item{save}{Optimize Plot's elements to be compatible with High Resolution size [type:Boulean]}

\item{silent}{save the file without the user input}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
A plot containing the experimental data, the correspondent curve for the binodal in study and the curve's raw XY data.
}
\description{
The function returns a plot after fitting a dataset to a given equation.
}
\details{
This version uses the plot function and return a regular bidimensional plot.
}
\examples{
#Populating variable XYdt with binodal data
XYdt <- peg4kslt[,1:2]
#Plot XYdt using Merchuk's function
#
AQSys.plot(XYdt)
#
}
