// Generated by rstantools.  Do not edit by hand.

/*
    LMMELSM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    LMMELSM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LMMELSM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_lmmelsmPredObs2_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_lmmelsmPredObs2");
    reader.add_event(337, 335, "end", "model_lmmelsmPredObs2");
    return reader;
}
template <typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T4__>::type, Eigen::Dynamic, Eigen::Dynamic>
lambda_mat(const int& J,
               const int& F,
               const std::vector<int>& J_f,
               const std::vector<std::vector<int> >& F_ind,
               const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lambda_est, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T4__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 5;
        validate_non_negative_index("out", "F", F);
        validate_non_negative_index("out", "J", J);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> out(F, J);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        stan::math::assign(out,rep_matrix(0.0, F, J));
        current_statement_begin__ = 6;
        int count(0);
        (void) count;  // dummy to suppress unused var warning
        stan::math::fill(count, std::numeric_limits<int>::min());
        stan::math::assign(count,1);
        current_statement_begin__ = 7;
        for (int f = 1; f <= F; ++f) {
            current_statement_begin__ = 8;
            for (int jj = 1; jj <= get_base1(J_f, f, "J_f", 1); ++jj) {
                current_statement_begin__ = 9;
                stan::model::assign(out, 
                            stan::model::cons_list(stan::model::index_uni(f), stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(F_ind, f, "F_ind", 1), jj, "F_ind", 2)), stan::model::nil_index_list())), 
                            get_base1(lambda_est, count, "lambda_est", 1), 
                            "assigning variable out");
                current_statement_begin__ = 10;
                stan::math::assign(count, (count + 1));
            }
        }
        current_statement_begin__ = 13;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct lambda_mat_functor__ {
    template <typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T4__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const int& J,
               const int& F,
               const std::vector<int>& J_f,
               const std::vector<std::vector<int> >& F_ind,
               const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& lambda_est, std::ostream* pstream__) const {
        return lambda_mat(J, F, J_f, F_ind, lambda_est, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
z_to_re(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
            const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 24;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(z, transpose(diag_pre_multiply(sigma, L))));
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct z_to_re_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
            const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma, std::ostream* pstream__) const {
        return z_to_re(z, L, sigma, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
z_to_re_bet(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma,
                const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& x_bet_l2,
                const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& zeta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int num(0);
        (void) num;  // dummy to suppress unused var warning
        stan::math::fill(num, std::numeric_limits<int>::min());
        stan::math::assign(num,cols(z));
        current_statement_begin__ = 38;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 39;
        validate_non_negative_index("sigmas", "K", K);
        validate_non_negative_index("sigmas", "num", num);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sigmas(K, num);
        stan::math::initialize(sigmas, DUMMY_VAR__);
        stan::math::fill(sigmas, DUMMY_VAR__);
        stan::math::assign(sigmas,elt_multiply(multiply(rep_vector(1.0, K), transpose(sigma)), stan::math::exp(multiply(x_bet_l2, zeta))));
        current_statement_begin__ = 40;
        validate_non_negative_index("out", "K", K);
        validate_non_negative_index("out", "num", num);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> out(K, num);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 42;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 43;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        multiply(get_base1(z, k, "z", 1), transpose(diag_pre_multiply(get_base1(sigmas, k, "sigmas", 1), L))), 
                        "assigning variable out");
        }
        current_statement_begin__ = 46;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct z_to_re_bet_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma,
                const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& x_bet_l2,
                const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& zeta, std::ostream* pstream__) const {
        return z_to_re_bet(z, L, sigma, x_bet_l2, zeta, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
z_to_re_bet_intercepts(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                           const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma,
                           const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& x_bet_l2,
                           const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& zeta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 59;
        int re_total(0);
        (void) re_total;  // dummy to suppress unused var warning
        stan::math::fill(re_total, std::numeric_limits<int>::min());
        stan::math::assign(re_total,cols(z));
        current_statement_begin__ = 60;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 61;
        int re_intercepts(0);
        (void) re_intercepts;  // dummy to suppress unused var warning
        stan::math::fill(re_intercepts, std::numeric_limits<int>::min());
        stan::math::assign(re_intercepts,cols(zeta));
        current_statement_begin__ = 62;
        validate_non_negative_index("sigmas", "K", K);
        validate_non_negative_index("sigmas", "re_total", re_total);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sigmas(K, re_total);
        stan::math::initialize(sigmas, DUMMY_VAR__);
        stan::math::fill(sigmas, DUMMY_VAR__);
        stan::math::assign(sigmas,multiply(rep_vector(1.0, K), transpose(sigma)));
        current_statement_begin__ = 63;
        validate_non_negative_index("out", "K", K);
        validate_non_negative_index("out", "re_total", re_total);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> out(K, re_total);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 65;
        stan::model::assign(sigmas, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, re_intercepts), stan::model::nil_index_list())), 
                    elt_multiply(stan::model::rvalue(sigmas, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, re_intercepts), stan::model::nil_index_list())), "sigmas"), stan::math::exp(multiply(x_bet_l2, zeta))), 
                    "assigning variable sigmas");
        current_statement_begin__ = 67;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 68;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        multiply(get_base1(z, k, "z", 1), transpose(diag_pre_multiply(get_base1(sigmas, k, "sigmas", 1), L))), 
                        "assigning variable out");
        }
        current_statement_begin__ = 71;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct z_to_re_bet_intercepts_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& z,
                           const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& L,
                           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& sigma,
                           const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& x_bet_l2,
                           const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& zeta, std::ostream* pstream__) const {
        return z_to_re_bet_intercepts(z, L, sigma, x_bet_l2, zeta, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
l1_to_l2(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& l1,
             const std::vector<int>& indices, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 79;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,size(indices));
        current_statement_begin__ = 80;
        int n_col(0);
        (void) n_col;  // dummy to suppress unused var warning
        stan::math::fill(n_col, std::numeric_limits<int>::min());
        stan::math::assign(n_col,cols(l1));
        current_statement_begin__ = 81;
        validate_non_negative_index("l2", "K", K);
        validate_non_negative_index("l2", "n_col", n_col);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> l2(K, n_col);
        stan::math::initialize(l2, DUMMY_VAR__);
        stan::math::fill(l2, DUMMY_VAR__);
        stan::math::assign(l2,stan::model::rvalue(l1, stan::model::cons_list(stan::model::index_multi(indices), stan::model::nil_index_list()), "l1"));
        current_statement_begin__ = 82;
        return stan::math::promote_scalar<fun_return_scalar_t__>(l2);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct l1_to_l2_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& l1,
             const std::vector<int>& indices, std::ostream* pstream__) const {
        return l1_to_l2(l1, indices, pstream__);
    }
};
std::vector<int>
l1_to_l2_indices(const int& K,
                     const std::vector<int>& group, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 92;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        stan::math::assign(N,size(group));
        current_statement_begin__ = 93;
        validate_non_negative_index("where_l1_first_k", "K", K);
        std::vector<int  > where_l1_first_k(K, int(0));
        stan::math::fill(where_l1_first_k, std::numeric_limits<int>::min());
        stan::math::assign(where_l1_first_k,rep_array(0, K));
        current_statement_begin__ = 95;
        for (int n = 1; n <= N; ++n) {
            current_statement_begin__ = 96;
            if (as_bool(logical_eq(get_base1(where_l1_first_k, get_base1(group, n, "group", 1), "where_l1_first_k", 1), 0))) {
                current_statement_begin__ = 97;
                stan::model::assign(where_l1_first_k, 
                            stan::model::cons_list(stan::model::index_uni(get_base1(group, n, "group", 1)), stan::model::nil_index_list()), 
                            n, 
                            "assigning variable where_l1_first_k");
            }
        }
        current_statement_begin__ = 101;
        return stan::math::promote_scalar<fun_return_scalar_t__>(where_l1_first_k);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct l1_to_l2_indices_functor__ {
            std::vector<int>
    operator()(const int& K,
                     const std::vector<int>& group, std::ostream* pstream__) const {
        return l1_to_l2_indices(K, group, pstream__);
    }
};
template <typename T2__>
std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, Eigen::Dynamic> >
mat_to_mat_array(const int& R,
                     const int& C,
                     const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& mat, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 112;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(mat));
        current_statement_begin__ = 113;
        validate_non_negative_index("out", "R", R);
        validate_non_negative_index("out", "C", C);
        validate_non_negative_index("out", "K", K);
        std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>  > out(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(R, C));
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 115;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 116;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        to_matrix(get_base1(mat, k, "mat", 1), R, C), 
                        "assigning variable out");
        }
        current_statement_begin__ = 119;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct mat_to_mat_array_functor__ {
    template <typename T2__>
        std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T2__>::type, Eigen::Dynamic, Eigen::Dynamic> >
    operator()(const int& R,
                     const int& C,
                     const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& mat, std::ostream* pstream__) const {
        return mat_to_mat_array(R, C, mat, pstream__);
    }
};
std::vector<int>
seq_from_to(const int& from,
                const int& to, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 130;
        int length(0);
        (void) length;  // dummy to suppress unused var warning
        stan::math::fill(length, std::numeric_limits<int>::min());
        stan::math::assign(length,((to - from) + 1));
        current_statement_begin__ = 131;
        validate_non_negative_index("out", "length", length);
        std::vector<int  > out(length, int(0));
        stan::math::fill(out, std::numeric_limits<int>::min());
        current_statement_begin__ = 132;
        for (int i = 1; i <= length; ++i) {
            current_statement_begin__ = 133;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((from + i) - 1), 
                        "assigning variable out");
        }
        current_statement_begin__ = 136;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct seq_from_to_functor__ {
            std::vector<int>
    operator()(const int& from,
                const int& to, std::ostream* pstream__) const {
        return seq_from_to(from, to, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_lmmelsmPredObs2
  : public stan::model::model_base_crtp<model_lmmelsmPredObs2> {
private:
        int N;
        int J;
        int F;
        int K;
        int P;
        int Q;
        int R;
        int P_random;
        int Q_random;
        std::vector<int> P_random_ind;
        std::vector<int> Q_random_ind;
        std::vector<int> group;
        matrix_d x_loc;
        matrix_d x_sca;
        matrix_d x_bet;
        std::vector<int> J_f;
        std::vector<std::vector<int> > F_ind;
        matrix_d y;
        int prior_only;
        int L2_pred_only;
        int intercept_only;
        int lambda_total;
        std::vector<int> l1_indices;
        matrix_d x_loc_l2;
        matrix_d x_sca_l2;
        matrix_d x_bet_l2;
        int re_intercepts;
        int re_mu_betas;
        int re_logsd_betas;
        int re_total;
        std::vector<int> re_ind_mu;
        std::vector<int> re_ind_logsd;
        std::vector<int> re_ind_mu_betas;
        std::vector<int> re_ind_logsd_betas;
        matrix_d x_loc_re;
        matrix_d x_sca_re;
public:
    model_lmmelsmPredObs2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_lmmelsmPredObs2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_lmmelsmPredObs2_namespace::model_lmmelsmPredObs2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 142;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 143;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            current_statement_begin__ = 144;
            context__.validate_dims("data initialization", "F", "int", context__.to_vec());
            F = int(0);
            vals_i__ = context__.vals_i("F");
            pos__ = 0;
            F = vals_i__[pos__++];
            current_statement_begin__ = 145;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            current_statement_begin__ = 146;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            current_statement_begin__ = 147;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            current_statement_begin__ = 148;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            current_statement_begin__ = 149;
            context__.validate_dims("data initialization", "P_random", "int", context__.to_vec());
            P_random = int(0);
            vals_i__ = context__.vals_i("P_random");
            pos__ = 0;
            P_random = vals_i__[pos__++];
            current_statement_begin__ = 150;
            context__.validate_dims("data initialization", "Q_random", "int", context__.to_vec());
            Q_random = int(0);
            vals_i__ = context__.vals_i("Q_random");
            pos__ = 0;
            Q_random = vals_i__[pos__++];
            current_statement_begin__ = 151;
            validate_non_negative_index("P_random_ind", "P_random", P_random);
            context__.validate_dims("data initialization", "P_random_ind", "int", context__.to_vec(P_random));
            P_random_ind = std::vector<int>(P_random, int(0));
            vals_i__ = context__.vals_i("P_random_ind");
            pos__ = 0;
            size_t P_random_ind_k_0_max__ = P_random;
            for (size_t k_0__ = 0; k_0__ < P_random_ind_k_0_max__; ++k_0__) {
                P_random_ind[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 152;
            validate_non_negative_index("Q_random_ind", "Q_random", Q_random);
            context__.validate_dims("data initialization", "Q_random_ind", "int", context__.to_vec(Q_random));
            Q_random_ind = std::vector<int>(Q_random, int(0));
            vals_i__ = context__.vals_i("Q_random_ind");
            pos__ = 0;
            size_t Q_random_ind_k_0_max__ = Q_random;
            for (size_t k_0__ = 0; k_0__ < Q_random_ind_k_0_max__; ++k_0__) {
                Q_random_ind[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 154;
            validate_non_negative_index("group", "N", N);
            context__.validate_dims("data initialization", "group", "int", context__.to_vec(N));
            group = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("group");
            pos__ = 0;
            size_t group_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < group_k_0_max__; ++k_0__) {
                group[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 155;
            validate_non_negative_index("x_loc", "N", N);
            validate_non_negative_index("x_loc", "P", P);
            context__.validate_dims("data initialization", "x_loc", "matrix_d", context__.to_vec(N,P));
            x_loc = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, P);
            vals_r__ = context__.vals_r("x_loc");
            pos__ = 0;
            size_t x_loc_j_2_max__ = P;
            size_t x_loc_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < x_loc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_loc_j_1_max__; ++j_1__) {
                    x_loc(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 156;
            validate_non_negative_index("x_sca", "N", N);
            validate_non_negative_index("x_sca", "Q", Q);
            context__.validate_dims("data initialization", "x_sca", "matrix_d", context__.to_vec(N,Q));
            x_sca = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, Q);
            vals_r__ = context__.vals_r("x_sca");
            pos__ = 0;
            size_t x_sca_j_2_max__ = Q;
            size_t x_sca_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < x_sca_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_sca_j_1_max__; ++j_1__) {
                    x_sca(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 157;
            validate_non_negative_index("x_bet", "N", N);
            validate_non_negative_index("x_bet", "R", R);
            context__.validate_dims("data initialization", "x_bet", "matrix_d", context__.to_vec(N,R));
            x_bet = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, R);
            vals_r__ = context__.vals_r("x_bet");
            pos__ = 0;
            size_t x_bet_j_2_max__ = R;
            size_t x_bet_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < x_bet_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < x_bet_j_1_max__; ++j_1__) {
                    x_bet(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 160;
            validate_non_negative_index("J_f", "F", F);
            context__.validate_dims("data initialization", "J_f", "int", context__.to_vec(F));
            J_f = std::vector<int>(F, int(0));
            vals_i__ = context__.vals_i("J_f");
            pos__ = 0;
            size_t J_f_k_0_max__ = F;
            for (size_t k_0__ = 0; k_0__ < J_f_k_0_max__; ++k_0__) {
                J_f[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 161;
            validate_non_negative_index("F_ind", "F", F);
            validate_non_negative_index("F_ind", "J", J);
            context__.validate_dims("data initialization", "F_ind", "int", context__.to_vec(F,J));
            F_ind = std::vector<std::vector<int> >(F, std::vector<int>(J, int(0)));
            vals_i__ = context__.vals_i("F_ind");
            pos__ = 0;
            size_t F_ind_k_0_max__ = F;
            size_t F_ind_k_1_max__ = J;
            for (size_t k_1__ = 0; k_1__ < F_ind_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < F_ind_k_0_max__; ++k_0__) {
                    F_ind[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 162;
            validate_non_negative_index("y", "N", N);
            validate_non_negative_index("y", "J", J);
            context__.validate_dims("data initialization", "y", "matrix_d", context__.to_vec(N,J));
            y = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, J);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_2_max__ = J;
            size_t y_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < y_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                    y(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 165;
            context__.validate_dims("data initialization", "prior_only", "int", context__.to_vec());
            prior_only = int(0);
            vals_i__ = context__.vals_i("prior_only");
            pos__ = 0;
            prior_only = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_only", prior_only, 0);
            check_less_or_equal(function__, "prior_only", prior_only, 1);
            current_statement_begin__ = 166;
            context__.validate_dims("data initialization", "L2_pred_only", "int", context__.to_vec());
            L2_pred_only = int(0);
            vals_i__ = context__.vals_i("L2_pred_only");
            pos__ = 0;
            L2_pred_only = vals_i__[pos__++];
            check_greater_or_equal(function__, "L2_pred_only", L2_pred_only, 0);
            check_less_or_equal(function__, "L2_pred_only", L2_pred_only, 1);
            // initialize transformed data variables
            current_statement_begin__ = 171;
            intercept_only = int(0);
            stan::math::fill(intercept_only, std::numeric_limits<int>::min());
            stan::math::assign(intercept_only,(primitive_value(logical_eq(P, 0)) && primitive_value(logical_eq(Q, 0))));
            current_statement_begin__ = 172;
            lambda_total = int(0);
            stan::math::fill(lambda_total, std::numeric_limits<int>::min());
            stan::math::assign(lambda_total,sum(J_f));
            current_statement_begin__ = 173;
            validate_non_negative_index("l1_indices", "K", K);
            l1_indices = std::vector<int>(K, int(0));
            stan::math::fill(l1_indices, std::numeric_limits<int>::min());
            stan::math::assign(l1_indices,l1_to_l2_indices(K, group, pstream__));
            current_statement_begin__ = 175;
            validate_non_negative_index("x_loc_l2", "K", K);
            validate_non_negative_index("x_loc_l2", "P", P);
            x_loc_l2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(K, P);
            stan::math::fill(x_loc_l2, DUMMY_VAR__);
            current_statement_begin__ = 176;
            validate_non_negative_index("x_sca_l2", "K", K);
            validate_non_negative_index("x_sca_l2", "Q", Q);
            x_sca_l2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(K, Q);
            stan::math::fill(x_sca_l2, DUMMY_VAR__);
            current_statement_begin__ = 177;
            validate_non_negative_index("x_bet_l2", "K", K);
            validate_non_negative_index("x_bet_l2", "R", R);
            x_bet_l2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(K, R);
            stan::math::fill(x_bet_l2, DUMMY_VAR__);
            current_statement_begin__ = 179;
            re_intercepts = int(0);
            stan::math::fill(re_intercepts, std::numeric_limits<int>::min());
            stan::math::assign(re_intercepts,(F * 2));
            current_statement_begin__ = 180;
            re_mu_betas = int(0);
            stan::math::fill(re_mu_betas, std::numeric_limits<int>::min());
            stan::math::assign(re_mu_betas,(P_random * F));
            current_statement_begin__ = 181;
            re_logsd_betas = int(0);
            stan::math::fill(re_logsd_betas, std::numeric_limits<int>::min());
            stan::math::assign(re_logsd_betas,(Q_random * F));
            current_statement_begin__ = 182;
            re_total = int(0);
            stan::math::fill(re_total, std::numeric_limits<int>::min());
            stan::math::assign(re_total,((re_intercepts + re_mu_betas) + re_logsd_betas));
            current_statement_begin__ = 184;
            validate_non_negative_index("re_ind_mu", "F", F);
            re_ind_mu = std::vector<int>(F, int(0));
            stan::math::fill(re_ind_mu, std::numeric_limits<int>::min());
            stan::math::assign(re_ind_mu,seq_from_to(1, F, pstream__));
            current_statement_begin__ = 185;
            validate_non_negative_index("re_ind_logsd", "F", F);
            re_ind_logsd = std::vector<int>(F, int(0));
            stan::math::fill(re_ind_logsd, std::numeric_limits<int>::min());
            stan::math::assign(re_ind_logsd,seq_from_to((F + 1), (F * 2), pstream__));
            current_statement_begin__ = 186;
            validate_non_negative_index("re_ind_mu_betas", "re_mu_betas", re_mu_betas);
            re_ind_mu_betas = std::vector<int>(re_mu_betas, int(0));
            stan::math::fill(re_ind_mu_betas, std::numeric_limits<int>::min());
            stan::math::assign(re_ind_mu_betas,seq_from_to(((F * 2) + 1), ((F * 2) + (P_random * F)), pstream__));
            current_statement_begin__ = 187;
            validate_non_negative_index("re_ind_logsd_betas", "re_logsd_betas", re_logsd_betas);
            re_ind_logsd_betas = std::vector<int>(re_logsd_betas, int(0));
            stan::math::fill(re_ind_logsd_betas, std::numeric_limits<int>::min());
            stan::math::assign(re_ind_logsd_betas,seq_from_to((((F * 2) + (P_random * F)) + 1), (((F * 2) + (P_random * F)) + (Q_random * F)), pstream__));
            current_statement_begin__ = 189;
            validate_non_negative_index("x_loc_re", "N", N);
            validate_non_negative_index("x_loc_re", "P_random", P_random);
            x_loc_re = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, P_random);
            stan::math::fill(x_loc_re, DUMMY_VAR__);
            stan::math::assign(x_loc_re,stan::model::rvalue(x_loc, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(P_random_ind), stan::model::nil_index_list())), "x_loc"));
            current_statement_begin__ = 190;
            validate_non_negative_index("x_sca_re", "N", N);
            validate_non_negative_index("x_sca_re", "Q_random", Q_random);
            x_sca_re = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, Q_random);
            stan::math::fill(x_sca_re, DUMMY_VAR__);
            stan::math::assign(x_sca_re,stan::model::rvalue(x_sca, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(Q_random_ind), stan::model::nil_index_list())), "x_sca"));
            // execute transformed data statements
            current_statement_begin__ = 193;
            if (as_bool(L2_pred_only)) {
                current_statement_begin__ = 194;
                stan::math::assign(x_loc_l2, l1_to_l2(x_loc, l1_indices, pstream__));
                current_statement_begin__ = 195;
                stan::math::assign(x_sca_l2, l1_to_l2(x_sca, l1_indices, pstream__));
            }
            current_statement_begin__ = 197;
            if (as_bool(logical_gt(R, 0))) {
                current_statement_begin__ = 198;
                stan::math::assign(x_bet_l2, l1_to_l2(x_bet, l1_indices, pstream__));
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 205;
            validate_non_negative_index("nu", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 207;
            validate_non_negative_index("sigma", "J", J);
            num_params_r__ += J;
            current_statement_begin__ = 212;
            validate_non_negative_index("mu_beta", "P", P);
            validate_non_negative_index("mu_beta", "F", F);
            num_params_r__ += (P * F);
            current_statement_begin__ = 216;
            validate_non_negative_index("logsd_beta", "Q", Q);
            validate_non_negative_index("logsd_beta", "F", F);
            num_params_r__ += (Q * F);
            current_statement_begin__ = 217;
            validate_non_negative_index("epsilon_L", "F", F);
            validate_non_negative_index("epsilon_L", "F", F);
            num_params_r__ += ((F * (F - 1)) / 2);
            current_statement_begin__ = 222;
            validate_non_negative_index("mu_logsd_betas_random_z", "K", K);
            validate_non_negative_index("mu_logsd_betas_random_z", "re_total", re_total);
            num_params_r__ += (K * re_total);
            current_statement_begin__ = 223;
            validate_non_negative_index("mu_logsd_betas_random_L", "re_total", re_total);
            validate_non_negative_index("mu_logsd_betas_random_L", "re_total", re_total);
            num_params_r__ += ((re_total * (re_total - 1)) / 2);
            current_statement_begin__ = 224;
            validate_non_negative_index("mu_logsd_betas_random_sigma", "re_total", re_total);
            num_params_r__ += re_total;
            current_statement_begin__ = 228;
            validate_non_negative_index("zeta", "R", R);
            validate_non_negative_index("zeta", "re_intercepts", re_intercepts);
            num_params_r__ += (R * re_intercepts);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_lmmelsmPredObs2() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 205;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        validate_non_negative_index("nu", "J", J);
        context__.validate_dims("parameter initialization", "nu", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            nu(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 207;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "J", J);
        context__.validate_dims("parameter initialization", "sigma", "row_vector_d", context__.to_vec(J));
        Eigen::Matrix<double, 1, Eigen::Dynamic> sigma(J);
        size_t sigma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 212;
        if (!(context__.contains_r("mu_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        validate_non_negative_index("mu_beta", "P", P);
        validate_non_negative_index("mu_beta", "F", F);
        context__.validate_dims("parameter initialization", "mu_beta", "matrix_d", context__.to_vec(P,F));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_beta(P, F);
        size_t mu_beta_j_2_max__ = F;
        size_t mu_beta_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < mu_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_beta_j_1_max__; ++j_1__) {
                mu_beta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(mu_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 216;
        if (!(context__.contains_r("logsd_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable logsd_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("logsd_beta");
        pos__ = 0U;
        validate_non_negative_index("logsd_beta", "Q", Q);
        validate_non_negative_index("logsd_beta", "F", F);
        context__.validate_dims("parameter initialization", "logsd_beta", "matrix_d", context__.to_vec(Q,F));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> logsd_beta(Q, F);
        size_t logsd_beta_j_2_max__ = F;
        size_t logsd_beta_j_1_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < logsd_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < logsd_beta_j_1_max__; ++j_1__) {
                logsd_beta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(logsd_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable logsd_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 217;
        if (!(context__.contains_r("epsilon_L")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable epsilon_L missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("epsilon_L");
        pos__ = 0U;
        validate_non_negative_index("epsilon_L", "F", F);
        validate_non_negative_index("epsilon_L", "F", F);
        context__.validate_dims("parameter initialization", "epsilon_L", "matrix_d", context__.to_vec(F,F));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> epsilon_L(F, F);
        size_t epsilon_L_j_2_max__ = F;
        size_t epsilon_L_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < epsilon_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < epsilon_L_j_1_max__; ++j_1__) {
                epsilon_L(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(epsilon_L);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable epsilon_L: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 222;
        if (!(context__.contains_r("mu_logsd_betas_random_z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_logsd_betas_random_z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_logsd_betas_random_z");
        pos__ = 0U;
        validate_non_negative_index("mu_logsd_betas_random_z", "K", K);
        validate_non_negative_index("mu_logsd_betas_random_z", "re_total", re_total);
        context__.validate_dims("parameter initialization", "mu_logsd_betas_random_z", "matrix_d", context__.to_vec(K,re_total));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_z(K, re_total);
        size_t mu_logsd_betas_random_z_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_z_j_1_max__; ++j_1__) {
                mu_logsd_betas_random_z(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(mu_logsd_betas_random_z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_logsd_betas_random_z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 223;
        if (!(context__.contains_r("mu_logsd_betas_random_L")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_logsd_betas_random_L missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_logsd_betas_random_L");
        pos__ = 0U;
        validate_non_negative_index("mu_logsd_betas_random_L", "re_total", re_total);
        validate_non_negative_index("mu_logsd_betas_random_L", "re_total", re_total);
        context__.validate_dims("parameter initialization", "mu_logsd_betas_random_L", "matrix_d", context__.to_vec(re_total,re_total));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_L(re_total, re_total);
        size_t mu_logsd_betas_random_L_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_L_j_1_max__ = re_total;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_L_j_1_max__; ++j_1__) {
                mu_logsd_betas_random_L(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cholesky_factor_corr_unconstrain(mu_logsd_betas_random_L);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_logsd_betas_random_L: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 224;
        if (!(context__.contains_r("mu_logsd_betas_random_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_logsd_betas_random_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_logsd_betas_random_sigma");
        pos__ = 0U;
        validate_non_negative_index("mu_logsd_betas_random_sigma", "re_total", re_total);
        context__.validate_dims("parameter initialization", "mu_logsd_betas_random_sigma", "vector_d", context__.to_vec(re_total));
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_logsd_betas_random_sigma(re_total);
        size_t mu_logsd_betas_random_sigma_j_1_max__ = re_total;
        for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_sigma_j_1_max__; ++j_1__) {
            mu_logsd_betas_random_sigma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, mu_logsd_betas_random_sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_logsd_betas_random_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 228;
        if (!(context__.contains_r("zeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        validate_non_negative_index("zeta", "R", R);
        validate_non_negative_index("zeta", "re_intercepts", re_intercepts);
        context__.validate_dims("parameter initialization", "zeta", "matrix_d", context__.to_vec(R,re_intercepts));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> zeta(R, re_intercepts);
        size_t zeta_j_2_max__ = re_intercepts;
        size_t zeta_j_1_max__ = R;
        for (size_t j_2__ = 0; j_2__ < zeta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
                zeta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(zeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 205;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.row_vector_constrain(J, lp__);
            else
                nu = in__.row_vector_constrain(J);
            current_statement_begin__ = 207;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.row_vector_constrain(J, lp__);
            else
                sigma = in__.row_vector_constrain(J);
            current_statement_begin__ = 212;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_beta = in__.matrix_constrain(P, F, lp__);
            else
                mu_beta = in__.matrix_constrain(P, F);
            current_statement_begin__ = 216;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> logsd_beta;
            (void) logsd_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                logsd_beta = in__.matrix_constrain(Q, F, lp__);
            else
                logsd_beta = in__.matrix_constrain(Q, F);
            current_statement_begin__ = 217;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> epsilon_L;
            (void) epsilon_L;  // dummy to suppress unused var warning
            if (jacobian__)
                epsilon_L = in__.cholesky_factor_corr_constrain(F, lp__);
            else
                epsilon_L = in__.cholesky_factor_corr_constrain(F);
            current_statement_begin__ = 222;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_z;
            (void) mu_logsd_betas_random_z;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_logsd_betas_random_z = in__.matrix_constrain(K, re_total, lp__);
            else
                mu_logsd_betas_random_z = in__.matrix_constrain(K, re_total);
            current_statement_begin__ = 223;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_L;
            (void) mu_logsd_betas_random_L;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_logsd_betas_random_L = in__.cholesky_factor_corr_constrain(re_total, lp__);
            else
                mu_logsd_betas_random_L = in__.cholesky_factor_corr_constrain(re_total);
            current_statement_begin__ = 224;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu_logsd_betas_random_sigma;
            (void) mu_logsd_betas_random_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_logsd_betas_random_sigma = in__.vector_lb_constrain(0, re_total, lp__);
            else
                mu_logsd_betas_random_sigma = in__.vector_lb_constrain(0, re_total);
            current_statement_begin__ = 228;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.matrix_constrain(R, re_intercepts, lp__);
            else
                zeta = in__.matrix_constrain(R, re_intercepts);
            // transformed parameters
            current_statement_begin__ = 233;
            validate_non_negative_index("mu_logsd_betas_random", "K", K);
            validate_non_negative_index("mu_logsd_betas_random", "re_total", re_total);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random(K, re_total);
            stan::math::initialize(mu_logsd_betas_random, DUMMY_VAR__);
            stan::math::fill(mu_logsd_betas_random, DUMMY_VAR__);
            stan::math::assign(mu_logsd_betas_random,(logical_lt(R, 1) ? stan::math::promote_scalar<local_scalar_t__>(z_to_re(mu_logsd_betas_random_z, mu_logsd_betas_random_L, mu_logsd_betas_random_sigma, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(z_to_re_bet_intercepts(mu_logsd_betas_random_z, mu_logsd_betas_random_L, mu_logsd_betas_random_sigma, x_bet_l2, zeta, pstream__)) ));
            current_statement_begin__ = 236;
            validate_non_negative_index("mu_random", "K", K);
            validate_non_negative_index("mu_random", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> mu_random(K, F);
            stan::math::initialize(mu_random, DUMMY_VAR__);
            stan::math::fill(mu_random, DUMMY_VAR__);
            stan::math::assign(mu_random,stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_mu), stan::model::nil_index_list())), "mu_logsd_betas_random"));
            current_statement_begin__ = 237;
            validate_non_negative_index("logsd_random", "K", K);
            validate_non_negative_index("logsd_random", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> logsd_random(K, F);
            stan::math::initialize(logsd_random, DUMMY_VAR__);
            stan::math::fill(logsd_random, DUMMY_VAR__);
            stan::math::assign(logsd_random,stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_logsd), stan::model::nil_index_list())), "mu_logsd_betas_random"));
            current_statement_begin__ = 238;
            validate_non_negative_index("mu_beta_random", "P_random", P_random);
            validate_non_negative_index("mu_beta_random", "F", F);
            validate_non_negative_index("mu_beta_random", "K", K);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > mu_beta_random(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(P_random, F));
            stan::math::initialize(mu_beta_random, DUMMY_VAR__);
            stan::math::fill(mu_beta_random, DUMMY_VAR__);
            stan::math::assign(mu_beta_random,mat_to_mat_array(P_random, F, stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_mu_betas), stan::model::nil_index_list())), "mu_logsd_betas_random"), pstream__));
            current_statement_begin__ = 239;
            validate_non_negative_index("logsd_beta_random", "Q_random", Q_random);
            validate_non_negative_index("logsd_beta_random", "F", F);
            validate_non_negative_index("logsd_beta_random", "K", K);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > logsd_beta_random(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(Q_random, F));
            stan::math::initialize(logsd_beta_random, DUMMY_VAR__);
            stan::math::fill(logsd_beta_random, DUMMY_VAR__);
            stan::math::assign(logsd_beta_random,mat_to_mat_array(Q_random, F, stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_logsd_betas), stan::model::nil_index_list())), "mu_logsd_betas_random"), pstream__));
            current_statement_begin__ = 240;
            validate_non_negative_index("eta", "N", N);
            validate_non_negative_index("eta", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta(N, F);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 241;
            validate_non_negative_index("eta_logsd", "N", N);
            validate_non_negative_index("eta_logsd", "F", F);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> eta_logsd(N, F);
            stan::math::initialize(eta_logsd, DUMMY_VAR__);
            stan::math::fill(eta_logsd, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 243;
            stan::math::assign(eta, stan::model::rvalue(mu_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "mu_random"));
            current_statement_begin__ = 244;
            stan::math::assign(eta, add(eta, rep_matrix(nu, N)));
            current_statement_begin__ = 245;
            if (as_bool(logical_gte(P, 1))) {
                current_statement_begin__ = 246;
                if (as_bool(L2_pred_only)) {
                    current_statement_begin__ = 247;
                    stan::math::assign(eta, add(eta, stan::model::rvalue(multiply(x_loc_l2, mu_beta), stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "multiply(x_loc_l2, mu_beta)")));
                } else {
                    current_statement_begin__ = 249;
                    stan::math::assign(eta, add(eta, multiply(x_loc, mu_beta)));
                }
            }
            current_statement_begin__ = 253;
            if (as_bool(logical_gte(P_random, 1))) {
                current_statement_begin__ = 254;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 255;
                    stan::model::assign(eta, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta"), multiply(get_base1(x_loc_re, n, "x_loc_re", 1), get_base1(mu_beta_random, get_base1(group, n, "group", 1), "mu_beta_random", 1))), 
                                "assigning variable eta");
                }
            }
            current_statement_begin__ = 259;
            stan::math::assign(eta_logsd, stan::model::rvalue(logsd_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "logsd_random"));
            current_statement_begin__ = 260;
            stan::math::assign(eta_logsd, add(eta_logsd, rep_matrix(sigma, N)));
            current_statement_begin__ = 261;
            if (as_bool(logical_gte(Q, 1))) {
                current_statement_begin__ = 262;
                if (as_bool(L2_pred_only)) {
                    current_statement_begin__ = 263;
                    stan::math::assign(eta_logsd, add(eta_logsd, stan::model::rvalue(multiply(x_sca_l2, logsd_beta), stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "multiply(x_sca_l2, logsd_beta)")));
                } else {
                    current_statement_begin__ = 265;
                    stan::math::assign(eta_logsd, add(eta_logsd, multiply(x_sca, logsd_beta)));
                }
            }
            current_statement_begin__ = 269;
            if (as_bool(logical_gte(Q_random, 1))) {
                current_statement_begin__ = 270;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 271;
                    stan::model::assign(eta_logsd, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(eta_logsd, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta_logsd"), multiply(get_base1(x_sca_re, n, "x_sca_re", 1), get_base1(logsd_beta_random, get_base1(group, n, "group", 1), "logsd_beta_random", 1))), 
                                "assigning variable eta_logsd");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 233;
            size_t mu_logsd_betas_random_j_1_max__ = K;
            size_t mu_logsd_betas_random_j_2_max__ = re_total;
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(mu_logsd_betas_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: mu_logsd_betas_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_logsd_betas_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 236;
            size_t mu_random_j_1_max__ = K;
            size_t mu_random_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < mu_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < mu_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(mu_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: mu_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 237;
            size_t logsd_random_j_1_max__ = K;
            size_t logsd_random_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < logsd_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < logsd_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(logsd_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: logsd_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable logsd_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 238;
            size_t mu_beta_random_k_0_max__ = K;
            size_t mu_beta_random_j_1_max__ = P_random;
            size_t mu_beta_random_j_2_max__ = F;
            for (size_t k_0__ = 0; k_0__ < mu_beta_random_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < mu_beta_random_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < mu_beta_random_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(mu_beta_random[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: mu_beta_random" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_beta_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 239;
            size_t logsd_beta_random_k_0_max__ = K;
            size_t logsd_beta_random_j_1_max__ = Q_random;
            size_t logsd_beta_random_j_2_max__ = F;
            for (size_t k_0__ = 0; k_0__ < logsd_beta_random_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < logsd_beta_random_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < logsd_beta_random_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(logsd_beta_random[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: logsd_beta_random" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable logsd_beta_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 240;
            size_t eta_j_1_max__ = N;
            size_t eta_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 241;
            size_t eta_logsd_j_1_max__ = N;
            size_t eta_logsd_j_2_max__ = F;
            for (size_t j_1__ = 0; j_1__ < eta_logsd_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < eta_logsd_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(eta_logsd(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: eta_logsd" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_logsd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 299;
            lp_accum__.add(std_normal_log<propto__>(nu));
            current_statement_begin__ = 301;
            lp_accum__.add(std_normal_log<propto__>(sigma));
            current_statement_begin__ = 303;
            lp_accum__.add(std_normal_log<propto__>(to_vector(zeta)));
            current_statement_begin__ = 304;
            lp_accum__.add(std_normal_log<propto__>(to_vector(mu_beta)));
            current_statement_begin__ = 305;
            lp_accum__.add(std_normal_log<propto__>(to_vector(logsd_beta)));
            current_statement_begin__ = 307;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(epsilon_L, 1));
            current_statement_begin__ = 308;
            lp_accum__.add(std_normal_log<propto__>(to_vector(mu_logsd_betas_random_z)));
            current_statement_begin__ = 309;
            lp_accum__.add(lkj_corr_cholesky_log<propto__>(mu_logsd_betas_random_L, 1));
            current_statement_begin__ = 310;
            lp_accum__.add(std_normal_log<propto__>(mu_logsd_betas_random_sigma));
            current_statement_begin__ = 312;
            if (as_bool(logical_negation(prior_only))) {
                current_statement_begin__ = 316;
                if (as_bool((primitive_value(L2_pred_only) || primitive_value(intercept_only)))) {
                    {
                    current_statement_begin__ = 317;
                    validate_non_negative_index("epsilon_cov_L", "F", F);
                    validate_non_negative_index("epsilon_cov_L", "F", F);
                    validate_non_negative_index("epsilon_cov_L", "K", K);
                    std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>  > epsilon_cov_L(K, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(F, F));
                    stan::math::initialize(epsilon_cov_L, DUMMY_VAR__);
                    stan::math::fill(epsilon_cov_L, DUMMY_VAR__);
                    current_statement_begin__ = 318;
                    for (int k = 1; k <= K; ++k) {
                        current_statement_begin__ = 319;
                        stan::model::assign(epsilon_cov_L, 
                                    stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                                    diag_pre_multiply(stan::math::exp(get_base1(eta_logsd, get_base1(l1_indices, k, "l1_indices", 1), "eta_logsd", 1)), epsilon_L), 
                                    "assigning variable epsilon_cov_L");
                    }
                    current_statement_begin__ = 321;
                    for (int n = 1; n <= N; ++n) {
                        current_statement_begin__ = 322;
                        lp_accum__.add(multi_normal_cholesky_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "y"), get_base1(eta, n, "eta", 1), get_base1(epsilon_cov_L, get_base1(group, n, "group", 1), "epsilon_cov_L", 1)));
                    }
                    }
                } else {
                    current_statement_begin__ = 325;
                    for (int n = 1; n <= N; ++n) {
                        current_statement_begin__ = 326;
                        lp_accum__.add(multi_normal_cholesky_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "y"), stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "eta"), diag_pre_multiply(stan::math::exp(stan::model::rvalue(eta_logsd, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "eta_logsd")), epsilon_L)));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("nu");
        names__.push_back("sigma");
        names__.push_back("mu_beta");
        names__.push_back("logsd_beta");
        names__.push_back("epsilon_L");
        names__.push_back("mu_logsd_betas_random_z");
        names__.push_back("mu_logsd_betas_random_L");
        names__.push_back("mu_logsd_betas_random_sigma");
        names__.push_back("zeta");
        names__.push_back("mu_logsd_betas_random");
        names__.push_back("mu_random");
        names__.push_back("logsd_random");
        names__.push_back("mu_beta_random");
        names__.push_back("logsd_beta_random");
        names__.push_back("eta");
        names__.push_back("eta_logsd");
        names__.push_back("Omega_eta");
        names__.push_back("Omega_mean_logsd");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(F);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(re_total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re_total);
        dims__.push_back(re_total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re_total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(R);
        dims__.push_back(re_intercepts);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(re_total);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(P_random);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dims__.push_back(Q_random);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(F);
        dims__.push_back(F);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(re_total);
        dims__.push_back(re_total);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_lmmelsmPredObs2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, 1, Eigen::Dynamic> nu = in__.row_vector_constrain(J);
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            vars__.push_back(nu(j_1__));
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> sigma = in__.row_vector_constrain(J);
        size_t sigma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            vars__.push_back(sigma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_beta = in__.matrix_constrain(P, F);
        size_t mu_beta_j_2_max__ = F;
        size_t mu_beta_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < mu_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_beta_j_1_max__; ++j_1__) {
                vars__.push_back(mu_beta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> logsd_beta = in__.matrix_constrain(Q, F);
        size_t logsd_beta_j_2_max__ = F;
        size_t logsd_beta_j_1_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < logsd_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < logsd_beta_j_1_max__; ++j_1__) {
                vars__.push_back(logsd_beta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> epsilon_L = in__.cholesky_factor_corr_constrain(F);
        size_t epsilon_L_j_2_max__ = F;
        size_t epsilon_L_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < epsilon_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < epsilon_L_j_1_max__; ++j_1__) {
                vars__.push_back(epsilon_L(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_z = in__.matrix_constrain(K, re_total);
        size_t mu_logsd_betas_random_z_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_z_j_1_max__; ++j_1__) {
                vars__.push_back(mu_logsd_betas_random_z(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random_L = in__.cholesky_factor_corr_constrain(re_total);
        size_t mu_logsd_betas_random_L_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_L_j_1_max__ = re_total;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_L_j_1_max__; ++j_1__) {
                vars__.push_back(mu_logsd_betas_random_L(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> mu_logsd_betas_random_sigma = in__.vector_lb_constrain(0, re_total);
        size_t mu_logsd_betas_random_sigma_j_1_max__ = re_total;
        for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_sigma_j_1_max__; ++j_1__) {
            vars__.push_back(mu_logsd_betas_random_sigma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> zeta = in__.matrix_constrain(R, re_intercepts);
        size_t zeta_j_2_max__ = re_intercepts;
        size_t zeta_j_1_max__ = R;
        for (size_t j_2__ = 0; j_2__ < zeta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
                vars__.push_back(zeta(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 233;
            validate_non_negative_index("mu_logsd_betas_random", "K", K);
            validate_non_negative_index("mu_logsd_betas_random", "re_total", re_total);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_logsd_betas_random(K, re_total);
            stan::math::initialize(mu_logsd_betas_random, DUMMY_VAR__);
            stan::math::fill(mu_logsd_betas_random, DUMMY_VAR__);
            stan::math::assign(mu_logsd_betas_random,(logical_lt(R, 1) ? stan::math::promote_scalar<local_scalar_t__>(z_to_re(mu_logsd_betas_random_z, mu_logsd_betas_random_L, mu_logsd_betas_random_sigma, pstream__)) : stan::math::promote_scalar<local_scalar_t__>(z_to_re_bet_intercepts(mu_logsd_betas_random_z, mu_logsd_betas_random_L, mu_logsd_betas_random_sigma, x_bet_l2, zeta, pstream__)) ));
            current_statement_begin__ = 236;
            validate_non_negative_index("mu_random", "K", K);
            validate_non_negative_index("mu_random", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> mu_random(K, F);
            stan::math::initialize(mu_random, DUMMY_VAR__);
            stan::math::fill(mu_random, DUMMY_VAR__);
            stan::math::assign(mu_random,stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_mu), stan::model::nil_index_list())), "mu_logsd_betas_random"));
            current_statement_begin__ = 237;
            validate_non_negative_index("logsd_random", "K", K);
            validate_non_negative_index("logsd_random", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> logsd_random(K, F);
            stan::math::initialize(logsd_random, DUMMY_VAR__);
            stan::math::fill(logsd_random, DUMMY_VAR__);
            stan::math::assign(logsd_random,stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_logsd), stan::model::nil_index_list())), "mu_logsd_betas_random"));
            current_statement_begin__ = 238;
            validate_non_negative_index("mu_beta_random", "P_random", P_random);
            validate_non_negative_index("mu_beta_random", "F", F);
            validate_non_negative_index("mu_beta_random", "K", K);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > mu_beta_random(K, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P_random, F));
            stan::math::initialize(mu_beta_random, DUMMY_VAR__);
            stan::math::fill(mu_beta_random, DUMMY_VAR__);
            stan::math::assign(mu_beta_random,mat_to_mat_array(P_random, F, stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_mu_betas), stan::model::nil_index_list())), "mu_logsd_betas_random"), pstream__));
            current_statement_begin__ = 239;
            validate_non_negative_index("logsd_beta_random", "Q_random", Q_random);
            validate_non_negative_index("logsd_beta_random", "F", F);
            validate_non_negative_index("logsd_beta_random", "K", K);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > logsd_beta_random(K, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(Q_random, F));
            stan::math::initialize(logsd_beta_random, DUMMY_VAR__);
            stan::math::fill(logsd_beta_random, DUMMY_VAR__);
            stan::math::assign(logsd_beta_random,mat_to_mat_array(Q_random, F, stan::model::rvalue(mu_logsd_betas_random, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_multi(re_ind_logsd_betas), stan::model::nil_index_list())), "mu_logsd_betas_random"), pstream__));
            current_statement_begin__ = 240;
            validate_non_negative_index("eta", "N", N);
            validate_non_negative_index("eta", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta(N, F);
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            current_statement_begin__ = 241;
            validate_non_negative_index("eta_logsd", "N", N);
            validate_non_negative_index("eta_logsd", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> eta_logsd(N, F);
            stan::math::initialize(eta_logsd, DUMMY_VAR__);
            stan::math::fill(eta_logsd, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 243;
            stan::math::assign(eta, stan::model::rvalue(mu_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "mu_random"));
            current_statement_begin__ = 244;
            stan::math::assign(eta, add(eta, rep_matrix(nu, N)));
            current_statement_begin__ = 245;
            if (as_bool(logical_gte(P, 1))) {
                current_statement_begin__ = 246;
                if (as_bool(L2_pred_only)) {
                    current_statement_begin__ = 247;
                    stan::math::assign(eta, add(eta, stan::model::rvalue(multiply(x_loc_l2, mu_beta), stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "multiply(x_loc_l2, mu_beta)")));
                } else {
                    current_statement_begin__ = 249;
                    stan::math::assign(eta, add(eta, multiply(x_loc, mu_beta)));
                }
            }
            current_statement_begin__ = 253;
            if (as_bool(logical_gte(P_random, 1))) {
                current_statement_begin__ = 254;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 255;
                    stan::model::assign(eta, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta"), multiply(get_base1(x_loc_re, n, "x_loc_re", 1), get_base1(mu_beta_random, get_base1(group, n, "group", 1), "mu_beta_random", 1))), 
                                "assigning variable eta");
                }
            }
            current_statement_begin__ = 259;
            stan::math::assign(eta_logsd, stan::model::rvalue(logsd_random, stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "logsd_random"));
            current_statement_begin__ = 260;
            stan::math::assign(eta_logsd, add(eta_logsd, rep_matrix(sigma, N)));
            current_statement_begin__ = 261;
            if (as_bool(logical_gte(Q, 1))) {
                current_statement_begin__ = 262;
                if (as_bool(L2_pred_only)) {
                    current_statement_begin__ = 263;
                    stan::math::assign(eta_logsd, add(eta_logsd, stan::model::rvalue(multiply(x_sca_l2, logsd_beta), stan::model::cons_list(stan::model::index_multi(group), stan::model::nil_index_list()), "multiply(x_sca_l2, logsd_beta)")));
                } else {
                    current_statement_begin__ = 265;
                    stan::math::assign(eta_logsd, add(eta_logsd, multiply(x_sca, logsd_beta)));
                }
            }
            current_statement_begin__ = 269;
            if (as_bool(logical_gte(Q_random, 1))) {
                current_statement_begin__ = 270;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 271;
                    stan::model::assign(eta_logsd, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                add(stan::model::rvalue(eta_logsd, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "eta_logsd"), multiply(get_base1(x_sca_re, n, "x_sca_re", 1), get_base1(logsd_beta_random, get_base1(group, n, "group", 1), "logsd_beta_random", 1))), 
                                "assigning variable eta_logsd");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_logsd_betas_random_j_2_max__ = re_total;
                size_t mu_logsd_betas_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_j_1_max__; ++j_1__) {
                        vars__.push_back(mu_logsd_betas_random(j_1__, j_2__));
                    }
                }
                size_t mu_random_j_2_max__ = F;
                size_t mu_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < mu_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < mu_random_j_1_max__; ++j_1__) {
                        vars__.push_back(mu_random(j_1__, j_2__));
                    }
                }
                size_t logsd_random_j_2_max__ = F;
                size_t logsd_random_j_1_max__ = K;
                for (size_t j_2__ = 0; j_2__ < logsd_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < logsd_random_j_1_max__; ++j_1__) {
                        vars__.push_back(logsd_random(j_1__, j_2__));
                    }
                }
                size_t mu_beta_random_j_2_max__ = F;
                size_t mu_beta_random_j_1_max__ = P_random;
                size_t mu_beta_random_k_0_max__ = K;
                for (size_t j_2__ = 0; j_2__ < mu_beta_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < mu_beta_random_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < mu_beta_random_k_0_max__; ++k_0__) {
                            vars__.push_back(mu_beta_random[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t logsd_beta_random_j_2_max__ = F;
                size_t logsd_beta_random_j_1_max__ = Q_random;
                size_t logsd_beta_random_k_0_max__ = K;
                for (size_t j_2__ = 0; j_2__ < logsd_beta_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < logsd_beta_random_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < logsd_beta_random_k_0_max__; ++k_0__) {
                            vars__.push_back(logsd_beta_random[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t eta_j_2_max__ = F;
                size_t eta_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                        vars__.push_back(eta(j_1__, j_2__));
                    }
                }
                size_t eta_logsd_j_2_max__ = F;
                size_t eta_logsd_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < eta_logsd_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < eta_logsd_j_1_max__; ++j_1__) {
                        vars__.push_back(eta_logsd(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 333;
            validate_non_negative_index("Omega_eta", "F", F);
            validate_non_negative_index("Omega_eta", "F", F);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega_eta(F, F);
            stan::math::initialize(Omega_eta, DUMMY_VAR__);
            stan::math::fill(Omega_eta, DUMMY_VAR__);
            stan::math::assign(Omega_eta,multiply_lower_tri_self_transpose(epsilon_L));
            current_statement_begin__ = 334;
            validate_non_negative_index("Omega_mean_logsd", "re_total", re_total);
            validate_non_negative_index("Omega_mean_logsd", "re_total", re_total);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Omega_mean_logsd(re_total, re_total);
            stan::math::initialize(Omega_mean_logsd, DUMMY_VAR__);
            stan::math::fill(Omega_mean_logsd, DUMMY_VAR__);
            stan::math::assign(Omega_mean_logsd,multiply_lower_tri_self_transpose(mu_logsd_betas_random_L));
            // validate, write generated quantities
            current_statement_begin__ = 333;
            stan::math::check_corr_matrix(function__, "Omega_eta", Omega_eta);
            size_t Omega_eta_j_2_max__ = F;
            size_t Omega_eta_j_1_max__ = F;
            for (size_t j_2__ = 0; j_2__ < Omega_eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Omega_eta_j_1_max__; ++j_1__) {
                    vars__.push_back(Omega_eta(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 334;
            stan::math::check_corr_matrix(function__, "Omega_mean_logsd", Omega_mean_logsd);
            size_t Omega_mean_logsd_j_2_max__ = re_total;
            size_t Omega_mean_logsd_j_1_max__ = re_total;
            for (size_t j_2__ = 0; j_2__ < Omega_mean_logsd_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Omega_mean_logsd_j_1_max__; ++j_1__) {
                    vars__.push_back(Omega_mean_logsd(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_lmmelsmPredObs2";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_beta_j_2_max__ = F;
        size_t mu_beta_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < mu_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t logsd_beta_j_2_max__ = F;
        size_t logsd_beta_j_1_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < logsd_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < logsd_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "logsd_beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t epsilon_L_j_2_max__ = F;
        size_t epsilon_L_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < epsilon_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < epsilon_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "epsilon_L" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_logsd_betas_random_z_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_logsd_betas_random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_logsd_betas_random_L_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_L_j_1_max__ = re_total;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_L_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_L_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_logsd_betas_random_L" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_logsd_betas_random_sigma_j_1_max__ = re_total;
        for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_logsd_betas_random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zeta_j_2_max__ = re_intercepts;
        size_t zeta_j_1_max__ = R;
        for (size_t j_2__ = 0; j_2__ < zeta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "zeta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_logsd_betas_random_j_2_max__ = re_total;
            size_t mu_logsd_betas_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu_logsd_betas_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_random_j_2_max__ = F;
            size_t mu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t logsd_random_j_2_max__ = F;
            size_t logsd_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < logsd_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < logsd_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "logsd_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_beta_random_j_2_max__ = F;
            size_t mu_beta_random_j_1_max__ = P_random;
            size_t mu_beta_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_beta_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_beta_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_beta_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mu_beta_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t logsd_beta_random_j_2_max__ = F;
            size_t logsd_beta_random_j_1_max__ = Q_random;
            size_t logsd_beta_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < logsd_beta_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < logsd_beta_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < logsd_beta_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "logsd_beta_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t eta_j_2_max__ = F;
            size_t eta_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_logsd_j_2_max__ = F;
            size_t eta_logsd_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_logsd_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_logsd_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_logsd" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t Omega_eta_j_2_max__ = F;
        size_t Omega_eta_j_1_max__ = F;
        for (size_t j_2__ = 0; j_2__ < Omega_eta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_eta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega_eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Omega_mean_logsd_j_2_max__ = re_total;
        size_t Omega_mean_logsd_j_1_max__ = re_total;
        for (size_t j_2__ = 0; j_2__ < Omega_mean_logsd_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Omega_mean_logsd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Omega_mean_logsd" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t nu_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < nu_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nu" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_j_1_max__ = J;
        for (size_t j_1__ = 0; j_1__ < sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_beta_j_2_max__ = F;
        size_t mu_beta_j_1_max__ = P;
        for (size_t j_2__ = 0; j_2__ < mu_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t logsd_beta_j_2_max__ = F;
        size_t logsd_beta_j_1_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < logsd_beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < logsd_beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "logsd_beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t epsilon_L_j_1_max__ = ((F * (F - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < epsilon_L_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "epsilon_L" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_logsd_betas_random_z_j_2_max__ = re_total;
        size_t mu_logsd_betas_random_z_j_1_max__ = K;
        for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_z_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_z_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_logsd_betas_random_z" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t mu_logsd_betas_random_L_j_1_max__ = ((re_total * (re_total - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_L_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_logsd_betas_random_L" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t mu_logsd_betas_random_sigma_j_1_max__ = re_total;
        for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_sigma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_logsd_betas_random_sigma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t zeta_j_2_max__ = re_intercepts;
        size_t zeta_j_1_max__ = R;
        for (size_t j_2__ = 0; j_2__ < zeta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < zeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "zeta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_logsd_betas_random_j_2_max__ = re_total;
            size_t mu_logsd_betas_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_logsd_betas_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_logsd_betas_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu_logsd_betas_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_random_j_2_max__ = F;
            size_t mu_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t logsd_random_j_2_max__ = F;
            size_t logsd_random_j_1_max__ = K;
            for (size_t j_2__ = 0; j_2__ < logsd_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < logsd_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "logsd_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mu_beta_random_j_2_max__ = F;
            size_t mu_beta_random_j_1_max__ = P_random;
            size_t mu_beta_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < mu_beta_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < mu_beta_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_beta_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "mu_beta_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t logsd_beta_random_j_2_max__ = F;
            size_t logsd_beta_random_j_1_max__ = Q_random;
            size_t logsd_beta_random_k_0_max__ = K;
            for (size_t j_2__ = 0; j_2__ < logsd_beta_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < logsd_beta_random_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < logsd_beta_random_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "logsd_beta_random" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t eta_j_2_max__ = F;
            size_t eta_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t eta_logsd_j_2_max__ = F;
            size_t eta_logsd_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < eta_logsd_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eta_logsd_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "eta_logsd" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t Omega_eta_j_1_max__ = ((F * (F - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < Omega_eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Omega_eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Omega_mean_logsd_j_1_max__ = ((re_total * (re_total - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < Omega_mean_logsd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "Omega_mean_logsd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_lmmelsmPredObs2_namespace::model_lmmelsmPredObs2 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
