% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spl1D.R, R/spl2D.R, R/spl3D.R
\name{spl1D}
\alias{spl1D}
\alias{spl2D}
\alias{spl3D}
\title{Fit P-splines}
\usage{
spl1D(
  x,
  nseg,
  pord = 2,
  degree = 3,
  scaleX = TRUE,
  xlim = NULL,
  cond = NULL,
  level = NULL
)

spl2D(
  x1,
  x2,
  nseg,
  pord = 2,
  degree = 3,
  scaleX = TRUE,
  x1lim = NULL,
  x2lim = NULL,
  cond = NULL,
  level = NULL
)

spl3D(
  x1,
  x2,
  x3,
  nseg,
  pord = 2,
  degree = 3,
  scaleX = TRUE,
  x1lim = range(x1),
  x2lim = range(x2),
  x3lim = range(x3)
)
}
\arguments{
\item{x, x1, x2, x3}{The variables in the data containing the values of
the \code{x} covariates.}

\item{nseg}{The number of segments}

\item{pord}{The order of penalty, default \code{pord = 2}}

\item{degree}{The degree of B-spline basis, default \code{degree = 3}}

\item{scaleX}{Should the fixed effects be scaled.}

\item{xlim, x1lim, x2lim, x3lim}{A numerical vector of length 2 containing the
domain of the corresponding x covariate where the knots should be placed.
Default set to \code{NULL}, when the covariate range will be used.}

\item{cond}{Conditional factor: splines are defined conditional on the level.
Default \code{NULL}.}

\item{level}{The level of the conditional factor. Default \code{NULL}.}
}
\value{
A list with the following elements:
\itemize{
  \item \code{X} - design matrix for fixed effect. The intercept is not included.
  \item \code{Z} - design matrix for random effect.
  \item \code{lGinv} - a list of precision matrices
  \item \code{knots} - a list of vectors with knot positions
  \item \code{dim.f} - the dimensions of the fixed effect.
  \item \code{dim.r} - the dimensions of the random effect.
  \item \code{term.labels.f} - the labels for the fixed effect terms.
  \item \code{term.labels.r} - the labels for the random effect terms.
  \item \code{x} - a list of vectors for the spline variables.
  \item \code{pord} - the order of the penalty.
  \item \code{degree} - the degree of the B-spline basis.
  \item \code{scaleX} - logical indicating if the fixed effects are scaled.
  \item \code{EDnom} - the nominal effective dimensions.
}
}
\description{
Fit multi dimensional P-splines using sparse implementation.
}
\section{Functions}{
\itemize{
\item \code{spl2D()}: 2-dimensional splines

\item \code{spl3D()}: 3-dimensional splines

}}
\examples{
## Fit model on john.alpha data from agridat package.
data(john.alpha, package = "agridat")

## Fit a model with a 1-dimensional spline at the plot level.
LMM1_spline <- LMMsolve(fixed = yield ~ rep + gen,
                       spline = ~spl1D(x = plot, nseg = 20),
                       data = john.alpha)

summary(LMM1_spline)

## Fit model on US precipitation data from spam package.
data(USprecip, package = "spam")

## Only use observed data
USprecip <- as.data.frame(USprecip)
USprecip <- USprecip[USprecip$infill == 1, ]

## Fit a model with a 2-dimensional P-spline.
LMM2_spline <- LMMsolve(fixed = anomaly ~ 1,
                       spline = ~spl2D(x1 = lon, x2 = lat, nseg = c(41, 41)),
                       data = USprecip)

summary(LMM2_spline)

}
\seealso{
\code{\link{LMMsolve}}
}
