% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.lmm}
\alias{fitted.lmm}
\title{Predicted Mean Value For Linear Mixed Model}
\usage{
\method{fitted}{lmm}(object, newdata = NULL, keep.newdata = FALSE, ...)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{newdata}{[data.frame] the covariate values for each cluster.}

\item{keep.newdata}{[logical] Should the argument \code{newdata} be output along side the predicted values?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A vector of length the number of row of newdata
}
\description{
Predicted Mean Value For Linear Mixed Model
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

## fit Linear Mixed Model
eUN.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id, structure = "UN", data = dL, df = FALSE)

## prediction
fitted(eUN.lmm)
fitted(eUN.lmm, newdata = data.frame(X1 = 1, X2 = 2, X5 = 3))
fitted(eUN.lmm, newdata = data.frame(X1 = 1, X2 = 2, X5 = 3), keep.newdata = TRUE)
}
