% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.Wald_lmm}
\alias{autoplot.Wald_lmm}
\title{Graphical Display For Linear Hypothesis Test}
\usage{
\method{autoplot}{Wald_lmm}(
  object,
  type = "forest",
  plot = TRUE,
  size.text = 16,
  add.args = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{Wald_lmm} object.}

\item{type}{[character] what to display: a forest plot (\code{"forest"}) or a heatmap (\code{"heat"}).}

\item{plot}{[logical] should the plot be displayed?}

\item{size.text}{[numeric, >0] size of the font used to display text.}

\item{add.args}{[list] additional arguments used to customized the graphical display.
Must be a named list. See details.}

\item{...}{arguments passed to the confint method.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Graphical Display For Linear Hypothesis Test
}
\details{
Argument \strong{add.args}: parameters specific to the forest plot: \itemize{
\item \code{color}: [logical] should the estimates be colored by global null hypothesis, e.g. when testing the effect of a 3 factor covariate, the two corresponding coefficient will have the same color. Alternatively a vector of positive integers giving the color with which each estimator should be displayed.
\item \code{color}: [logical] should the estimates be represented by a different shape per global null hypothesis, e.g. when testing the effect of a 3 factor covariate, the two corresponding coefficient will have the same type of point. Alternatively a vector of positive integers describing the shape to be used for each estimator.
\item \code{ci}: [logical] should confidence intervals be displayed?
\item \code{size.estimate}: [numeric, >0] size of the dot used to display the estimates.
\item \code{size.ci}: [numeric, >0] thickness of the line used to display the confidence intervals.
\item \code{width.ci}: [numeric, >0] width of the line used to display the confidence intervals.
\item \code{size.null}: [numeric, >0] thickness of the line used to display the null hypothesis. 
}
Parameters specific to the heatmap plot: \itemize{
\item \code{limits}: [numeric vector of length 2] minimum and maximum value of the colorscale relative to the correlation.
\item \code{low}, \code{mid}, \code{high}: [character] color for the the colorscale relative to the correlation.
\item \code{midpoint}: [numeric] correlation value associated with the color defined by argument \code{mid}
}
}
\examples{
## From the multcomp package
if(require(datasets) && require(ggplot2)){

## only tests with 1 df
ff <- Fertility ~ Agriculture + Examination + Education + Catholic + Infant.Mortality
e.lmm <- lmm(ff, data = swiss)
e.aovlmm <- anova(e.lmm)

autoplot(e.aovlmm, type = "forest")
autoplot(e.aovlmm, type = "heat") ## 3 color gradient
autoplot(e.aovlmm, type = "heat", add.args = list(mid = NULL)) ## 2 color gradient

## test with more than 1 df
e.lmm2 <- lmm(breaks ~ tension + wool, data = warpbreaks)
e.aovlmm2 <- anova(e.lmm2)
autoplot(e.aovlmm2)
autoplot(e.aovlmm2, add.args = list(color = FALSE, shape = FALSE))
}

}
